#ifndef CLASS_FRAME
#define CLASS_FRAME "MakeMDI_Frame"
// ==========================================================Purpose 
// FRAME.H - Top level application window. 
// 
// MAKEMDI adaptation of Windows 3.1 SDK MAKEAPP system. 
// 
// MDI application design based on Chapter 7 of	 
// "Windows 3: A Developer's Guide" by Jeffrey Richter. 
// 
// Adaptation developed with permission of the author by  
// John F. Holliday, Technisoft Corporation 
// Telephone: (515) 472-9803, CompuServe: 71271,634 
//
// [DMM]	25-Nov-1992: Fixed crashing on exit
//			Also tabified file to tabsize of 4
//
//			David M. Miller, Business Visions, Inc.
//			Telephone: (212) 747-6118
//			CompuServe: 72676,327
//			internet: dmiller@hera.sbi.com
// ==========================================================Private 

// Window procedure 

LRESULT CALLBACK _export Frame_WndProc(HWND, UINT, WPARAM, LPARAM);


// Default message handler 

#define Frame_DefProc	DefWindowProc


// Instance data structure 

typedef struct tagFRAME {
	HWND			hWnd;				// Instance window handle. 
	HWND			hWndClient;			// Client window handle. 
	HWND			hWndActiveMDIChild; // Active MDI child window. 
	WORD			wNumSheets;			// Number of Sheet windows created. 
	WORD			wNumCharts;			// Number of Chart windows created. 
	HMENU			hMenu;				/* Menu used when no MDI children are
										   active. */
	DLGPROC			fpProcRibbon;		// Ribbon dialog procedure address. 
	HWND			hdlgRibbon;			// Ribbon modeless dialog box. 
	BOOL			fStatusBarOn;		// Is the status bar showing? 
	BOOL			fMDIChildIsMaximized;		/* Is the active child
												   maximized? */
	HWND			hWndMenuHelp;		/* Window that last received a
										   WM_MENUSELECT message. */
	DWORD			dwMenuHelp;			/* Menu help code placed here by
										   hWndMenuHelp window. */
}				FRAME;


// Instance data pointer access functions 

#if defined(M_I86SM) || defined(M_I86MM)
#define Frame_GetPtr(hWnd)			(FRAME*)GetWindowWord((hWnd), 0)
#define Frame_SetPtr(hWnd, pfrm)	(FRAME*)SetWindowWord((hWnd), 0, (WORD)(pfrm))
#else
#define Frame_GetPtr(hWnd)			(FRAME*)GetWindowLong((hWnd), 0)
#define Frame_SetPtr(hWnd, pfrm)	(FRAME*)SetWindowLong((hWnd), 0, (LONG)(pfrm))
#endif

// Helper macros 

#define GETFRAME(hWnd)				((HWND) (GetParent(GetParent(hWnd))))

// Frame message handler macros 

#define HANDLE_FW_MDICHILDDESTROY(hWnd, wParam, lParam, fn) \
   ((fn)((hWnd)), 0)
#define FORWARD_FW_MDICHILDDESTROY(hWnd, fn) \
   (void)(fn)((hWnd), FW_MDICHILDDESTROY, 0, 0L)

#define HANDLE_FW_GETSTATBARRECT(hWnd, wParam, lParam, fn) \
   ((fn)((hWnd), (LPRECT)(LPARAM)(lParam)), 0)
#define FORWARD_FW_GETSTATBARRECT(hWnd, lpRect, fn) \
   (void)(fn)((hWnd), FW_GETSTATBARRECT, 0, (LPARAM)(LPRECT)(lpRect))

#define HANDLE_FW_DRAWSTATUSDIVIDE(hWnd, wParam, lParam, fn) \
   ((fn)((hWnd), (LPPAINTSTRUCT)(LPARAM)(lParam)), 0)
#define FORWARD_FW_DRAWSTATUSDIVIDE(hWnd, lps, fn) \
   (void)(fn)((hWnd), FW_DRAWSTATUSDIVIDE, 0, (LPARAM)(LPPAINTSTRUCT)(lps))

#define HANDLE_FW_RESIZEMDICLIENT(hWnd, wParam, lParam, fn) \
   ((fn)((hWnd)), 0)
#define FORWARD_FW_RESIZEMDICLIENT(hWnd, fn) \
   (void)(fn)((hWnd), FW_RESIZEMDICLIENT, 0, 0L)

#define HANDLE_FW_SETMENUHELP(hWnd, wParam, lParam, fn) \
   ((fn)((hWnd),(HWND)(WPARAM)(wParam),(DWORD)(LPARAM)(lParam)), 0)
#define FORWARD_FW_SETMENUHELP(hWnd, hWndMenuHelp, dwMenuHelp, fn) \
   (void)(fn)((hWnd), FW_SETMENUHELP, (WPARAM)(HWND)(hWndMenuHelp), \
   (LPARAM)(DWORD)(dwMenuHelp))

#define HANDLE_FW_GETMENUHELP(hWnd, wParam, lParam, fn) \
   (LRESULT)(DWORD)((fn)(hWnd))
#define FORWARD_FW_GETMENUHELP(hWnd, fn) \
   (DWORD)(fn)((hWnd), FW_GETMENUHELP, 0, 0L)

// Application message handler macros 

#define HANDLE_AW_PAINTMENUHELP(hWnd, wParam, lParam, fn) \
   ((fn)((hWnd),(LPPAINTSTRUCT)(LPARAM)(lParam)), 0)
#define FORWARD_AW_PAINTMENUHELP(hWnd, ps, fn) \
   (void)(fn)((hWnd), AW_PAINTMENUHELP, 0, (LPARAM)(LPPAINTSTRUCT)(ps))

#define HANDLE_AC_PAINTSTATBAR(hWnd, wParam, lParam, fn) \
   ((fn)((hWnd),(HDC)(WPARAM)(wParam),(LPPAINTSTRUCT)(LPARAM)(lParam)), 0)
#define FORWARD_AC_PAINTSTATBAR(hWnd, hdc, ps, fn) \
   (void)(fn)((hWnd), AC_PAINTSTATBAR, 0, (WPARAM)(HDC)(wParam), \
   (LPARAM)(LPPAINTSTRUCT)(ps))




// Message handler declarations 

BOOL			Frame_OnCreate(FRAME * pfrm, CREATESTRUCT FAR * lpCreateStruct);
void			Frame_OnDestroy(FRAME * pfrm);

BOOL			Frame_OnQueryEndSession(FRAME * pfrm);
void			Frame_OnEndSession(FRAME * pfrm, BOOL fEnding);
void			Frame_OnClose(FRAME * pfrm);

void			Frame_OnSize(FRAME * pfrm, UINT state, int cx, int cy);

void			Frame_OnPaint(FRAME * pfrm);
BOOL			Frame_OnEraseBkgnd(FRAME * pfrm, HDC hdc);

void			Frame_OnActivate(FRAME * pfrm, UINT state, HWND hWndActDeact, BOOL fMinimized);
void			Frame_OnSetFocus(FRAME * pfrm, HWND hWndOldFocus);
void			Frame_OnKillFocus(FRAME * pfrm, HWND hWndNewFocus);

void			Frame_OnKey(FRAME * pfrm, UINT vk, BOOL fDown, int cRepeat, UINT flags);
void			Frame_OnChar(FRAME * pfrm, UINT ch, int cRepeat);
void			Frame_OnMouseMove(FRAME * pfrm, int x, int y, UINT keyFlags);
void			Frame_OnLButtonDown(FRAME * pfrm, BOOL fDoubleClick, int x, int y, UINT keyFlags);
void			Frame_OnLButtonUp(FRAME * pfrm, int x, int y, UINT keyFlags);

void			Frame_OnInitMenu(FRAME * pfrm, HMENU hMenu);
void			Frame_OnInitMenuPopup(FRAME * pfrm, HMENU hMenu, int item, BOOL fSystemMenu);

void			Frame_OnCommand(FRAME * pfrm, int id, HWND hWndCtl, UINT codeNotify);

void			Frame_OnSysCommand(FRAME * pfrm, WORD cmd, int x, int y);
void			Frame_OnNclButtonDown(FRAME * pfrm, BOOL fDoubleClick, int x, int y, UINT codeHitTest);
void			Frame_OnMenuSelect(FRAME * pfrm, HMENU hMenu, int item, HMENU hmenuPopup, UINT flags);
void			Frame_OnEnterIdle(FRAME * pfrm, WORD source, HWND hWndSource);

void			Frame_OnMdiChildDestroy(FRAME * pfrm);
void			Frame_OnGetStatBarRect(FRAME * pfrm, LPRECT lpRect);
void			Frame_OnDrawStatusDivide(FRAME * pfrm, LPPAINTSTRUCT lpps);
void			Frame_OnResizeMdiClient(FRAME * pfrm);
void			Frame_OnSetMenuHelp(FRAME * pfrm, HWND hWndMenuHelp, DWORD dwMenuHelp);
DWORD			Frame_OnGetMenuHelp(FRAME * pfrm);
void			Frame_OnPaintMenuHelp(FRAME * pfrm, LPPAINTSTRUCT lpps);

// ===========================================================Public 

BOOL			Frame_Initialize(APP * papp);
void			Frame_Terminate(APP * papp);

HWND			Frame_CreateWindow(LPCSTR lpszText,
									int x,
									int y,
									int cx,
									int cy,
									HINSTANCE hinst);

void WINAPI		Frame_TileVertically(HWND hWndMDIClient);
HWND WINAPI		Frame_CreateMDIChild(LPSTR szClassName,
									LPSTR szWindowName,
									DWORD dwStyle,
									short x,
									short y,
									short nWidth,
									short nHeight,
									HWND hWndMDIClient,
									HANDLE hInstance,
									LPARAM lParam);


void WINAPI		Frame_ChangeMDIMenu(HWND hWndFrame,
									HWND hWndClient,
									HMENU hMenuNew,
									WORD wMenuID);

//--------------------------------------------------------------End 
#endif							// !CLASS_FRAME 
