#define _RIBBON_C
//----------------------------------------------------------------- 
// MAKEMDI adaptation of Windows 3.1 SDK MAKEAPP system. 
// 
// MDI application design based on Chapter 7 of	 
// "Windows 3: A Developer's Guide" by Jeffrey Richter. 
// 
// Adaptation developed with permission of the author by  
// John F. Holliday, Technisoft Corporation 
// Telephone: (515) 472-9803, CompuServe: 71271,634 
//
// [DMM]	25-Nov-1992: Fixed crashing on exit
//			Also tabified file to tabsize of 4
//
//			David M. Miller, Business Visions, Inc.
//			Telephone: (212) 747-6118
//			CompuServe: 72676,327
//			internet: dmiller@hera.sbi.com
//----------------------------------------------------------------- 
#include "makemdi.h"


static BOOL fDefDlgEx = FALSE;



BOOL CALLBACK _export Ribbon_DlgProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CheckDefDlgRecursion(&fDefDlgEx);
	return SetDlgMsgResult(hwndDlg, msg, RibbonDlg_DlgProc(hwndDlg, msg, wParam, lParam));
}




LRESULT	RibbonDlg_DlgProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {
		HANDLE_MSG(hwndDlg, WM_INITDIALOG, RibbonDlg_OnInitDialog);
		HANDLE_MSG(hwndDlg, WM_COMMAND, RibbonDlg_OnCommand);
		HANDLE_MSG(hwndDlg, WM_ENABLE, RibbonDlg_OnEnable);
		HANDLE_MSG(hwndDlg, WM_PAINT, RibbonDlg_OnPaint);

	default:
		return RibbonDlg_DefProc(hwndDlg, msg, wParam, lParam);
	}
}




BOOL RibbonDlg_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	HWND hCtl;
	int i;

	// Add strings to the font combobox. 

	hCtl = GetDlgItem(hDlg, CTL_FONT);
	i = IDS_FONT;

	while (LoadString(g_app.hinst, i++, g_app.szBuf, sizeof(g_app.szBuf)) != 0)
		SendMessage(hCtl, CB_ADDSTRING, 0, (LPARAM)(LPSTR)g_app.szBuf);
	SendMessage(hCtl, CB_SETCURSEL, 0, 0);

	// Add strings to the fontsize combobox. 

	hCtl = GetDlgItem(hDlg, CTL_SIZE);
	i = IDS_SIZE;

	while (LoadString(g_app.hinst, i++, g_app.szBuf, sizeof(g_app.szBuf)) != 0)
		SendMessage(hCtl, CB_ADDSTRING, 0, (LONG)(LPSTR)g_app.szBuf);
	SendMessage(hCtl, CB_SETCURSEL, 0, 0);

	return TRUE;
}





void RibbonDlg_OnEnable(HWND hDlg, BOOL fEnable)
{
	HWND hCtl;

	// Make all child windows have the same status as the dialog box. 

	hCtl = GetWindow(hDlg, GW_CHILD);

	while (hCtl != NULL) {
		EnableWindow(hCtl, fEnable);
		hCtl = GetWindow(hCtl, GW_HWNDNEXT);
	}
}




void RibbonDlg_OnPaint(HWND hDlg)
//----------------------------------------------------------------- 
// Paint a horizontal dividing line between the Ribbon and the 
// MDICLIENT window. 
//----------------------------------------------------------------- 
{
	PAINTSTRUCT		ps;
	HPEN			hPen;
	RECT			rc;

	BeginPaint(hDlg, &ps);

	hPen = CreatePen(PS_SOLID, GetSystemMetrics(SM_CYBORDER), RGB(0, 0, 0));

	SelectObject(ps.hdc, hPen);
	GetClientRect(hDlg, &rc);

	MoveTo(ps.hdc, 0, rc.bottom - GetSystemMetrics(SM_CYBORDER));
	LineTo(ps.hdc, rc.right, rc.bottom - GetSystemMetrics(SM_CYBORDER));

	EndPaint(hDlg, &ps);
	DeletePen(hPen);
}




void RibbonDlg_OnCommand(HWND hDlg, UINT id, HWND hWndCtl, UINT code)
//----------------------------------------------------------------- 
// Make sure that focus is given back to the Frame after an	 
// option is chosen by the user. 
//----------------------------------------------------------------- 
{
	switch (id) {
		case CTL_FONT:
		case CTL_SIZE:
		if (code != CBN_SELCHANGE)
			break;
		SetFocus(GetParent(hDlg));
		break;

	case CTL_BOLD:
	case CTL_ITALIC:
	case CTL_UNDERLINE:
		if (code != BN_CLICKED)
			break;
		SetFocus(GetParent(hDlg));
		break;

	case IDOK:
	case IDCANCEL:
		SetFocus(GetParent(hDlg));
		break;
	}
}
