#ifndef CLASS_SHEET
#define CLASS_SHEET "MakeMDI_Sheet"
// ==========================================================Purpose 
// SHEET.H - MDI Sheet window managment. 
// 
// MAKEMDI adaptation of Windows 3.1 SDK MAKEAPP system. 
// 
// MDI application design based on Chapter 7 of	 
// "Windows 3: A Developer's Guide" by Jeffrey Richter. 
// 
// Adaptation developed with permission of the author by  
// John F. Holliday, Technisoft Corporation 
// Telephone: (515) 472-9803, CompuServe: 71271,634 
//
// [DMM]	25-Nov-1992: Fixed crashing on exit
//			Also tabified file to tabsize of 4
//
//			David M. Miller, Business Visions, Inc.
//			Telephone: (212) 747-6118
//			CompuServe: 72676,327
//			internet: dmiller@hera.sbi.com
// ==========================================================Private 

// Window procedure 

LRESULT CALLBACK _export Sheet_WndProc(HWND, UINT, WPARAM, LPARAM);


// Default message handler 

#define Sheet_DefProc				DefMDIChildProc


// Instance data structure 

typedef struct tagSHEET {
	HWND			hWnd;
	HWND			hWndPrevChild;
	HMENU			hMenu;
	HANDLE			hAccelTable;
	COLORREF		clrText;
	LPCSTR			lpszText;
}				SHEET;


// Instance data pointer access functions 

#if defined(M_I86SM) | defined(M_I86MM)
#define Sheet_GetPtr(hWnd)			   (SHEET*)GetWindowWord((hWnd), 0)
#define Sheet_SetPtr(hWnd, psheet)	   (SHEET*)SetWindowWord((hWnd), 0, (WORD)(psheet))
#else
#define Sheet_GetPtr(hWnd)			   (SHEET*)GetWindowLong((hWnd), 0)
#define Sheet_SetPtr(hWnd, psheet)	   (SHEET*)SetWindowLong((hWnd), 0, (LONG)(psheet))
#endif

// Message handler functions 

BOOL			Sheet_OnCreate(SHEET *, CREATESTRUCT FAR *);
int				Sheet_OnMouseActivate(SHEET *, HWND, UINT, UINT);
void			Sheet_OnMenuSelect(SHEET *, HMENU, int, HMENU, UINT);
void			Sheet_OnEnterIdle(SHEET *, UINT, HWND);
BOOL			Sheet_OnSetCursor(SHEET *, HWND, UINT, UINT);
void			Sheet_OnLButtonDown(SHEET *, BOOL, int, int, UINT);
void			Sheet_OnClose(SHEET *);

void			Sheet_OnMdiActivate(SHEET *, BOOL, HWND, HWND);
void			Sheet_OnDestroy(SHEET *);
void			Sheet_OnPaint(SHEET *);
BOOL			Sheet_OnEraseBkgnd(SHEET *, HDC);
BOOL			Sheet_OnQueryEndSession(SHEET *);
void			Sheet_OnEndSession(SHEET *, BOOL);
void			Sheet_OnCommand(SHEET *, int, HWND, UINT);
void			Sheet_OnPaintStatBar(SHEET *, HDC, LPPAINTSTRUCT);
void			Sheet_OnPaintMenuHelp(SHEET *, LPPAINTSTRUCT);


// ===========================================================Public 

BOOL			Sheet_Initialize(APP * papp);
void			Sheet_Terminate(APP * papp);

HWND			Sheet_CreateWindow(HWND hWndParent, int x, int y, int cx, int cy, BOOL fVisible, COLORREF clrText, LPCSTR lpszText);

// ==============================================================End 
#endif							// !CLASS_SHEET
