
#include <windows.h>
#include <string.h>

char winclassname [] = "MANYCURS";

HANDLE ghInst;

long FAR PASCAL _export WINPROC( HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
    static BOOL tfLButtonDown;
    static HCURSOR hcPrevCursor;
    static WORD wTimer;

    switch( msg )
    {
        case WM_CREATE :
            tfLButtonDown = FALSE;
            wTimer = SetTimer( hWnd, 1, 1000, NULL );
            return 0L;
        case WM_LBUTTONDOWN :
            if( tfLButtonDown == FALSE )
            {
                tfLButtonDown = TRUE;
                SetCapture( hWnd );
                hcPrevCursor = SetCursor( LoadCursor( ghInst, "LDOWN" ) );
            } else {
                tfLButtonDown = FALSE;
            }
            return 0L;
        case WM_TIMER :
            if( tfLButtonDown == TRUE )
            {
                SetCursor( LoadCursor( ghInst, "TIMER" ) );
            }
            return 0L;
        case WM_MOUSEMOVE :
            if( tfLButtonDown == TRUE )
            {
                SetCursor( LoadCursor( ghInst, "MOVED" ) );
            }
            return 0L;
        case WM_LBUTTONUP :
            tfLButtonDown = FALSE;
            SetCursor( hcPrevCursor );
            ReleaseCapture();
            return 0L;
        case WM_DESTROY :
            if( wTimer != 0 ) KillTimer( hWnd, wTimer );
            PostQuitMessage( 0 );
            return 0L;
    }
    return DefWindowProc( hWnd, msg, wParam, lParam );
}

BOOL Register_Window( HANDLE hInst )
{
    WNDCLASS wc;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WINPROC;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
    wc.hCursor = LoadCursor( 0, IDC_ARROW );
    wc.hbrBackground = GetStockObject( WHITE_BRUSH );
    wc.lpszMenuName = NULL;
    wc.lpszClassName = winclassname;
    return RegisterClass( &wc );
}

BOOL Init_Instance( HANDLE hInst, int nCmdShw )
{
    HWND hWnd;

    hWnd = CreateWindow
    (
        winclassname, winclassname,
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT,
        0, 0,
        hInst, NULL
	);
    if( hWnd == NULL ) return FALSE;
    ShowWindow( hWnd, nCmdShw );
    UpdateWindow( hWnd );
    return TRUE;
}

int PASCAL WINMAIN( HANDLE hInst, HANDLE hPrvInst, LPSTR lpCmdLn, int nCmdShw )
{
	MSG msg;

    ghInst = hInst;
    if( hPrvInst == 0 )
    {
        if( Register_Window( hInst ) == FALSE )
        {
            return FALSE;
        }
    }
    if( Init_Instance( hInst, nCmdShw ) == FALSE )
    {
        return FALSE;
    }
    while( GetMessage( &msg, 0, 0, 0 ) )
    {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
    }
    return msg.wParam;
}

