{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Demo program                                 }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program MDI;

{$R MDIAPP1.RES}

uses WObjects, WinTypes, WinProcs;

type

  { Define a TApplication descendant }
TMDIApp = object(TApplication)
  procedure InitMainWindow; virtual;
end;

PMyMDIWindow = ^TMyMDIWindow;
TMyMDIWindow = Object(TMDIWindow)
   constructor Init(aTitle:PChar; aMenu:hMenu);
   function createChild: PWindowsObject; virtual;
   procedure SetupWindow; virtual;
end;

PMyWindow = ^TMyWindow;
TMyWindow = object(TWindow)
  constructor init(aParent:PWindowsObject; aTitle:Pchar);
end;


constructor TMyWindow.init(aParent:PWindowsObject; aTitle:Pchar);
var
  Appbox, Topicbox: PEdit;
begin
  TWindow.Init(aParent,aTitle);
  Application^.SetKbHandler(@Self);
  EnableKbHandler;
  AppBox := New(PEdit,
            Init(@Self, 120, 'Test', 20, 30, 150, 30, 40, False));
  TopicBox := New(PEdit,
              Init(@Self, 121, 'Data', 20, 90, 150, 30, 40, False));
end;

procedure TMyMDIWindow.SetupWindow;
var
  PTempStatic:PStatic;
begin
  TMDIWindow.SetupWindow;
end;

function TMyMDIWindow.CreateChild:PWindowsObject;
var
  PMD : PWindow;
begin
  PMD := New(PMyWindow, Init(@Self, 'Dialog_1'));
  Application^.Makewindow(PMD);
  ShowWindow(PMD^.HWindow, SW_ShowNormal);
end;

constructor TMyMDIWindow.Init(aTitle:PChar; aMenu:hMenu);
begin
  TMDIWindow.Init(aTitle, aMenu);
end;

{ Construct the THelloApp's MainWindow object, loading its menu }
procedure TMDIApp.InitMainWindow;
begin
  MainWindow := New(PMyMDIWindow, Init('MDI Conformist',
    LoadMenu(HInstance, 'MDIMenu')));
end;

{ Declare a variable of type TMDIApp}
var
  MDIApp: TMDIApp;

{ Run the MDIApp }
begin
  MDIApp.Init('MDIApp');
  MDIApp.Run;
  MDIApp.Done;
end.
