{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program MDISplash;

{$R MDISplsh.RES}

uses WObjects, WinTypes, WinProcs;

type
  TMDIApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyMDIWin = ^TMyMDIWin;
  TMyMDIWin = object(TMDIWindow)
    procedure InitClientWindow; virtual;
  end;

  PMyMDIClient = ^TMyMDIClient;
  TMyMDIClient = object(TMDIClient)
    procedure WMPaint(var msg: TMessage); virtual wm_first + wm_Paint;
  end;


var
  hBits : hBitMap;
  MDIApp: TMDIApp;

procedure TMyMDIWin.InitClientWindow;
begin
  ClientWnd := new(PMyMDIClient, init(@Self));
end;

procedure TMyMDIClient.WMPaint(var msg: TMessage);
var
  hMemoryDC, TheDc: hDC;
  PS: TPaintStruct;
  OldObject: Thandle;
  BitStruct: TBitMap;
  Rect1: TRect;
  Maxx, Maxy: integer;

begin
  TMDIClient.wmPaint(Msg);
  invalidateRect(HWindow, nil, false);
  TheDC := beginPaint(HWindow, Ps);
  hMemoryDC := CreateCompatibleDC(TheDC);
  OldObject := selectObject(hMemoryDC, HBits);
  GetObject(hbits, sizeof(TBitMap), @BitStruct);
  GetClientRect(HWindow, Rect1);
  maxx := Rect1.Right  - Rect1.Left;
  maxy := Rect1.Bottom - Rect1.Top;
  StretchBlt(TheDC, 0, 0, Maxx, Maxy, hMemoryDC,
               0,0, bitstruct.bmWidth, Bitstruct.bmHeight, SRCCopy);

  SelectObject(hMemoryDC, OldObject);
  DeleteDC(hMemoryDC);
  Endpaint(hWindow, PS);
end;

procedure TMDIApp.InitMainWindow;
begin
  MainWindow := New(PMyMDIWin, Init('MDI Splash Background',
                    LoadMenu(HInstance, 'MDIMenu')));
  hBits := LoadBitmap(hinstance, 'MDIBackground');
end;

begin
  MDIApp.Init('MDISplashApp');
  MDIApp.Run;
  MDIApp.Done;
end.
