#include <windows.h>
#include <stdlib.h>
#include "mditbar.h"


long CALLBACK _export FrameWndProc (HWND, UINT, WPARAM, LPARAM) ;
BOOL CALLBACK _export CloseEnumProc(HWND, LONG) ;
long CALLBACK _export ChildWndProc (HWND, UINT, WPARAM, LPARAM) ;

BOOL CALLBACK _export ToolbarProc(HWND, UINT, WPARAM, LPARAM) ;

// global variables

HWND   ghwndToolbar, ghwndFrame, ghwndClient;
HINSTANCE ghInstance;

char   szFrameClass [] = "MDIFrame" ;
char   szChildClass [] = "MDIChild" ;

HMENU  hmnuMain, hmnuChild;
HMENU  hmnuMainWindow, hmnuChildWindow;

#pragma argsused
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     MSG      msg ;
     WNDCLASS wndclass ;

     ghInstance=hInstance;

     if (!hPrevInstance) 
          {
          // frame class

          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = FrameWndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = ghInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = COLOR_APPWORKSPACE + 1 ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szFrameClass ;

          RegisterClass (&wndclass) ;

          // child class

          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = ChildWndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = sizeof (LOCALHANDLE) ;
          wndclass.hInstance     = ghInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szChildClass ;

          RegisterClass (&wndclass) ;
          }

     hmnuMain  = LoadMenu (ghInstance, "MdiMenuInit") ;
     hmnuChild = LoadMenu (ghInstance, "MdiMenuChild") ;

     hmnuMainWindow  = GetSubMenu (hmnuMain,   INIT_MENU_POS) ;
     hmnuChildWindow = GetSubMenu (hmnuChild,  CHILD_MENU_POS) ;


     ghwndFrame = CreateWindow (szFrameClass, "MDI Toolbar Demo",
                               WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                               CW_USEDEFAULT, CW_USEDEFAULT,
                               CW_USEDEFAULT, CW_USEDEFAULT,
                               NULL, hmnuMain, ghInstance, NULL) ;

     ghwndClient = GetWindow (ghwndFrame, GW_CHILD) ;

     ghwndToolbar=CreateDialog(hInstance, "TEST_BAR", ghwndFrame,
        (DLGPROC) ToolbarProc);
     

     ShowWindow (ghwndFrame, nCmdShow) ;
     UpdateWindow (ghwndFrame) ;


     while (GetMessage (&msg, NULL, 0, 0))
          {
          if (!TranslateMDISysAccel (ghwndClient, &msg))
               {
               TranslateMessage (&msg) ;
               DispatchMessage (&msg) ;
               }
          }
     return msg.wParam ;
     }

#pragma argsused
long CALLBACK _export FrameWndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
     {
     CLIENTCREATESTRUCT cc ;
     FARPROC            lpfnEnum ;
     HWND               hwndChild, hwndNext ;
     MDICREATESTRUCT    mc;

     switch (message)
          {
          case WM_CREATE:          // Create the client window

               cc.hWindowMenu  = hmnuMainWindow ;
               cc.idFirstChild = IDM_FIRSTCHILD ;

               ghwndClient = CreateWindow ("MDICLIENT", NULL,
                              WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE |
                              WS_HSCROLL | WS_VSCROLL | WS_CLIPSIBLINGS,
                              0, 0, 0, 0, hwnd, 1, ghInstance,
                              (LPSTR) &cc) ;
               return 0 ;

          case WM_COMMAND:
               switch (wParam)
                    {
                    case IDM_NEWCHILD:

                         mc.szClass = szChildClass ;
                         mc.szTitle = "Child" ;
                         mc.hOwner  = ghInstance ;
                         mc.x       = CW_USEDEFAULT ;
                         mc.y       = CW_USEDEFAULT ;
                         mc.cx      = CW_USEDEFAULT ;
                         mc.cy      = CW_USEDEFAULT ;
                         mc.style   = 0 ;
                         mc.lParam  = NULL ;

                         hwndChild = SendMessage (ghwndClient, WM_MDICREATE, 0,
                                        (LONG) (LPMDICREATESTRUCT) &mc) ;
                         return 0 ;

                    case IDM_CLOSE:

                         hwndChild = LOWORD (SendMessage (ghwndClient,
                                                  WM_MDIGETACTIVE, 0, 0L)) ;

                         if (SendMessage (hwndChild, WM_QUERYENDSESSION, 0, 0L))
                              SendMessage (ghwndClient, WM_MDIDESTROY,
                                           hwndChild, 0L) ;
                         return 0 ;

                    case IDM_TILE:
                         SendMessage (ghwndClient, WM_MDITILE, 0, 0L) ;
                         return 0 ;

                    case IDM_CASCADE:
                         SendMessage (ghwndClient, WM_MDICASCADE, 0, 0L) ;
                         return 0 ;

                    case IDM_ARRANGE:
                         SendMessage (ghwndClient, WM_MDIICONARRANGE, 0, 0L) ;
                         return 0 ;

                    case IDM_CLOSEALL:

                         lpfnEnum = MakeProcInstance (CloseEnumProc, ghInstance) ;
                         EnumChildWindows (ghwndClient, lpfnEnum, 0L) ;
                         FreeProcInstance (lpfnEnum) ;
                         return 0 ;

                    case IDM_EXIT:

                         SendMessage (hwnd, WM_CLOSE, 0, 0L) ;
                         return 0 ;

                    default:

                         hwndChild = LOWORD (SendMessage (ghwndClient,
                                                WM_MDIGETACTIVE, 0, 0L)) ;

                        if (IsWindow (hwndChild))
                             SendMessage (hwndChild, WM_COMMAND,
                                          wParam, lParam) ;

                        break ;
                    }
               break ;

          case WM_SIZE:
               {
                RECT rc, rcTemp;

                GetClientRect(hwnd,&rc);
                GetClientRect(ghwndToolbar,&rcTemp);
                rc.top+=rcTemp.bottom;
                rc.bottom-=rcTemp.bottom;

                MoveWindow(ghwndClient, 0,rc.top,rc.right,rc.bottom, TRUE);
                MoveWindow(ghwndToolbar, 0, 0, rc.right, rc.top, TRUE);

                return 0;
                }

          case WM_QUERYENDSESSION:
          case WM_CLOSE:

               SendMessage (hwnd, WM_COMMAND, IDM_CLOSEALL, 0L) ;

               if (NULL != GetWindow (ghwndClient, GW_CHILD))
                    return 0 ;

               break ;

          case WM_DESTROY :
               PostQuitMessage (0) ;
               return 0 ;
          }

     return DefFrameProc (hwnd, ghwndClient, message, wParam, lParam) ;
     }

#pragma argsused
BOOL CALLBACK _export CloseEnumProc (HWND hwnd, LONG lParam)
     {
     if (GetWindow (hwnd, GW_OWNER))
          return 1 ;

     SendMessage (GetParent (hwnd), WM_MDIRESTORE, hwnd, 0L) ;

     if (!SendMessage (hwnd, WM_QUERYENDSESSION, 0, 0L))
          return 1 ;

     SendMessage (GetParent (hwnd), WM_MDIDESTROY, hwnd, 0L) ;
          return 1 ;
     }

#pragma argsused
long CALLBACK _export ChildWndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
     {
     HMENU           hMenu ;

     switch (message)
          {

          case WM_MDIACTIVATE:


               if (wParam == TRUE)
                    SendMessage (ghwndClient, WM_MDISETMENU, 0,
                                 MAKELONG (hmnuChild, hmnuChildWindow)) ;

               if (wParam == FALSE)
                    SendMessage (ghwndClient, WM_MDISETMENU, 0,
                                 MAKELONG (hmnuMain, hmnuMainWindow)) ;

               DrawMenuBar (ghwndFrame) ;
               return 0 ;

          case WM_QUERYENDSESSION:
          case WM_CLOSE:
               if (IDOK != MessageBox (hwnd, "OK to close window?", "Child",
                                       MB_ICONQUESTION | MB_OKCANCEL))
                    return 0 ;

               break ;
          }

     return DefMDIChildProc (hwnd, message, wParam, lParam) ;
     }


#pragma argsused
BOOL CALLBACK _export ToolbarProc (HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

     switch (uMsg)
          {

          case WM_COMMAND:
               switch (wParam)
               {
                  case IDC_ONE:
                       MessageBeep(MB_ICONEXCLAMATION);
                       return TRUE;

                  case IDC_TWO:
                       MessageBeep(MB_ICONQUESTION);
                       return TRUE;
               }
               break;
          }
     return FALSE;
}


