/*----------------------------------------------------------------------------
 MLHTEST.C
 Multiple Local Heap Demo
 10-3-90
 danq
----------------------------------------------------------------------------*/

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include "mlocal.h"
#include "listmgr.h"
#include "mltest.h"

// Window class names
static char szFrame[] = "MDIframe";
static char szChild[] = "MDIchild";

// Output strings
static char szPrint[] = "  %04u    %04X    %05u          %02X   %s";
static char szSum[]   = "Size: %05u  Used: %05u  Free: %05u";
static char szBar[]   = "-------------------------------------------------";
static char szBlank[] = "                                                 ";
static char szTitle[] = "Handle  Offset   Length  Lock Count   Flags      ";

// Global Variables
extern      WORD _B000h;
HANDLE      hInst;
HANDLE      hAccel;
HWND        hwndFrame;
HWND        hwndMDIClient;
HWND        hwndActive;
WORD        wActiveMenu;
WORD        wSelectedColor;
WORD        wLastCheck;
WORD        wLFlags;
INT         xChar,yChar;
DWORD       na;
HLIST       hList;


typedef struct tStruct {
	int    a;
	int    b;
	char   c;
} TSTRUCT, FAR * LPTSTRUCT;

/*----------------------------------------------------------------------------
	MonoAtSay(INT,INT, LPSTR) : VOID
	Outputs a string directly to the monochrome video hardware
----------------------------------------------------------------------------*/
VOID MonoAtSay(INT x, INT y, LPSTR tmp)
{

	LPSTR scr = (LPSTR) MAKELONG((((y * 80) + x) * 2),&_B000h);
	
	_asm {
		push    ds
		push    di
		push    si

		les     di,scr
		lds     si,tmp
		mov     ah,0x70

MOloop: lodsb
		cmp     al,0
		je      MOdone
		stosw
		jmp short MOloop

MOdone: pop     si
		pop     di
		pop     ds
	}
}

/*----------------------------------------------------------------------------
	InitializeApplication(void) : BOOL
	Registers window classes.
----------------------------------------------------------------------------*/
BOOL InitializeApplication()
{
	WNDCLASS    WndClass;

	memset(&WndClass, 0, sizeof(WndClass));

	//Prepare MDIFrame class structure
	WndClass.style          = 0;
	WndClass.lpfnWndProc    = MDIFrameWndProc;
	WndClass.hInstance      = hInst;
	WndClass.hIcon          = LoadIcon(hInst, MAINICON);
	WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
	WndClass.hbrBackground  = COLOR_APPWORKSPACE;
	WndClass.lpszMenuName   = AppMenu;
	WndClass.lpszClassName  = szFrame;

	//Register MDIframe class
	if (!RegisterClass(&WndClass))
		return FALSE;

	//Prepare MDIChild class structure
	WndClass.lpfnWndProc    = MDIChildWndProc;
	WndClass.hIcon          = LoadIcon(hInst, CHILDICON);
	WndClass.lpszMenuName   = NULL;
	WndClass.lpszClassName  = szChild;
	WndClass.cbWndExtra     = WE_EXTRA;

	// Register MDIChild class
	if (!RegisterClass(&WndClass))
		return FALSE;

	return TRUE;
}

/*----------------------------------------------------------------------------
	InitializeInstance(WORD) : BOOL
	Called for every instance of MLHTest.
----------------------------------------------------------------------------*/
BOOL InitializeInstance(WORD nCmdShow)
{
	char   sz[80];
	HDC    hdc;
	HMENU  hmenu;
	CLIENTCREATESTRUCT ccs;

	LoadString(hInst, IDS_APPNAME, sz, sizeof(sz));
	hwndFrame = CreateWindow (szFrame,
		sz,
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		CW_USEDEFAULT,0,
		CW_USEDEFAULT,0,
		NULL,
		NULL,
		hInst,
		NULL);

	if (!hwndFrame)
		return FALSE;

	ccs.hWindowMenu  = GetSubMenu(GetMenu(hwndFrame), WINDOWMENU);
	ccs.idFirstChild = IDM_WINDOWCHILD;

	hwndMDIClient = CreateWindow ("MDIclient",
		NULL,
		WS_CHILD|WS_CLIPCHILDREN,
		0,0,
		0,0,
		hwndFrame,
		0x100,
		hInst,
		(LPSTR)&ccs);

	if (!hwndMDIClient)
		return FALSE;

	if (!(hAccel = LoadAccelerators(hInst, IDMLHTest)))
		return FALSE;

	ShowWindow(hwndFrame,nCmdShow);

	UpdateWindow(hwndFrame);
	ShowWindow(hwndMDIClient, nCmdShow);
	UpdateWindow(hwndMDIClient);
	wActiveMenu = WINDOWMENU;
	na = 1;
	return TRUE;
}


/*----------------------------------------------------------------------------
  WinMain( HANDLE, HANDLE, LPSTR, int ) : int
  Calls the initialization routines and contains the message loop.
----------------------------------------------------------------------------*/
INT PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInst,LPSTR lpCmdLine, INT nCmdShow)
{
	MSG         msg;

	hInst = hInstance;

	// Initialize things needed for this application
	if (!hPrevInst) {
		if (!InitializeApplication())
			return 0;
	}

	// Create the frame and do other initialization
	if (!InitializeInstance(nCmdShow))
		return 0;


	// Process messages
	while (GetMessage(&msg, NULL, 0, 0)) {
		if (!TranslateMDISysAccel(hwndMDIClient, &msg) &&
			  !TranslateAccelerator(hwndFrame, hAccel, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return msg.wParam;
}

/*----------------------------------------------------------------------------
  RepaintChild(VOID) : VOID
  Sends a WM_PAINT to the active MDI Child
----------------------------------------------------------------------------*/
VOID RePaintChild(VOID)
{
	InvalidateRect(hwndActive, (LPRECT) NULL, TRUE);
}

/*----------------------------------------------------------------------------
  RepaintChild(VOID) : VOID
  Sends a WM_PAINT to the active MDI Child
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
  LockArena(VOID) : LPLOCALARENA
  Locks the Active MDIChilds arena
----------------------------------------------------------------------------*/
LPLOCALARENA LockArena(VOID)
{
	return ((LPLOCALARENA)MultLocalLock(ActiveHeap, ActiveArena));
}

/*----------------------------------------------------------------------------
  UnlockArena(VOID) : VOID
  Unlocks the Active MDIChilds arena
----------------------------------------------------------------------------*/
VOID UnlockArena(VOID)
{
	MultLocalUnlock(ActiveHeap, ActiveArena);
}

/*----------------------------------------------------------------------------
  ChangeMDIMenu(VOID) : VOID
  Changes the frame Menu based on what state the active MDI child is in.
----------------------------------------------------------------------------*/
VOID ChangeMDIMenu(VOID)
{
	HMENU hMenu;
	HMENU hWindowMenu;
	int i;

	i = (((hwndActive) && (!IsIconic(hwndActive))) ? WINDOWMENUCHILD : WINDOWMENU);
	if (wActiveMenu != i) {
		wActiveMenu = i;
		if (i == WINDOWMENUCHILD)
			hMenu = LoadMenu (hInst, ChildMenu);
		else
			hMenu = LoadMenu (hInst, AppMenu);
		hWindowMenu = GetSubMenu (hMenu, i);
		hMenu = (HMENU) SendMessage (hwndMDIClient, WM_MDISETMENU, 0, MAKELONG(hMenu,hWindowMenu));
		DestroyMenu (hMenu);
		DrawMenuBar (hwndFrame);
	}
}

/*----------------------------------------------------------------------------
  AboutDialog(HWND) : VOID
  Displays the About Dialog
----------------------------------------------------------------------------*/
VOID AboutDialog(HWND hwnd)
{
	FARPROC lpProc;
	lpProc = MakeProcInstance( MainDlgAbout, hInst );
	DialogBox( hInst, "MainAbout", hwnd, lpProc );
	FreeProcInstance( lpProc );
}

/*----------------------------------------------------------------------------
  AvoidArenaHandle(HANDLE) : BOOL
  Returns FALSE if passed handle is the local arena
----------------------------------------------------------------------------*/
BOOL AvoidArenaHandle(HANDLE h)
{
	if (h == ActiveArena) {
		MessageBox(hwndFrame,"Cannot Access Arena Handle", "Error", MB_ICONEXCLAMATION);
		return (FALSE);
	}
	else
		return (TRUE);
}

/*----------------------------------------------------------------------------
  GetSize(LPSTR) : WORD
  Displays the appropriate size dialog and returns user input value
----------------------------------------------------------------------------*/
WORD GetSize (LPSTR dlg)
{
	WORD    i;
	FARPROC lpProc;
	lpProc = MakeProcInstance(NewHeapDlgProc, hInst);
	i = DialogBox(hInst, dlg, hwndFrame, lpProc);
	FreeProcInstance(lpProc);
	return(i);
}

/*----------------------------------------------------------------------------
  GetAllocSize(VOID) : WORD
  Displays the Alloc size dialog and returns user input values
  Allocation Flags are returned in wLFlags global variable
----------------------------------------------------------------------------*/
WORD GetAllocSize (VOID)
{
	WORD    i;
	FARPROC lpProc;
	lpProc = MakeProcInstance(AllocDlgProc, hInst);
	i = DialogBox(hInst, "Alloc", hwndFrame, lpProc);
	FreeProcInstance(lpProc);
	return(i);
}

/*----------------------------------------------------------------------------
  GetSize(VOID) : HANDLE
  Displays the Handle dialog and returns user input value
----------------------------------------------------------------------------*/
HANDLE GetHandle (VOID)
{
	HANDLE i;
	FARPROC lpProc;
	lpProc = MakeProcInstance( HandleDlgProc, hInst );
	i = DialogBox( hInst, "Memory", hwndActive, lpProc );
	FreeProcInstance( lpProc );
	if (!AvoidArenaHandle(i))
		return FALSE;
	else
		return i;
}



/*----------------------------------------------------------------------------
  GetHandleAndSize(VOID) : WORD
  Displays the ReAlloc dialog and returns user input values
  Handle is returned in wLFlags global
----------------------------------------------------------------------------*/
WORD GetHandleAndSize ( VOID)
{
	WORD i;
	FARPROC lpProc;
	lpProc = MakeProcInstance( ReAllocDlgProc, hInst );
	i = DialogBox( hInst, "ReAlloc", hwndActive, lpProc );
	FreeProcInstance(lpProc);
	if (!AvoidArenaHandle(wLFlags))
		return FALSE;
	else
		return i;
}

/*----------------------------------------------------------------------------
  MyListCompare() : WORD
  Comparison Routine for ListSort

  Returns : LESSTHAN
			EQUAL
			GREATERTHAN

----------------------------------------------------------------------------*/
WORD FAR PASCAL MyListCompare(LPTSTRUCT lpComp1,LPTSTRUCT lpComp2)
{
	if (lpComp1->c > lpComp2->c)
		return(GREATERTHAN);
	if (lpComp1->c < lpComp2->c)
		return(LESSTHAN);
	if (lpComp1->c = lpComp2->c)
		return(EQUAL);
}

/*----------------------------------------------------------------------------
  MDIFrameWndProc( hwndMain, message, wParam, lParam ) : LONG;
  Handles messages for the MDI desktop.  This includes any WM_COMMAND
  messages that are received for the MDIchild windows.
----------------------------------------------------------------------------*/
LONG FAR PASCAL MDIFrameWndProc(HWND hwnd, unsigned msg,WORD wParam, LONG lParam)
{
	WORD wSize;
	HANDLE hlMem;
	LPLOCALARENA lpArena;
	INT i;

	switch (msg) {

		case WM_COMMAND:

			switch( wParam ) {

				case IDM_NEW:
					if (wSize = GetSize("NewHeap"))
						MLHTestCreate((wSize * 1024));
					break;
				case IDM_LISTMGR:
					{
						LPTSTRUCT lpTmp,lpTmp1;
						int i;
						FARPROC lpCompare;
						char ch = 'z';
						char st[11];
						
						hList = ListCreate(sizeof(TSTRUCT));
						for (i=1;i<=26;i++) {
							lpTmp = ListAllocNode(hList);
							lpTmp->a = i;
							lpTmp->b = i * 0x10;
							lpTmp->c = ch;
							ch--;
							ListAddNode(hList, lpTmp);
						}
						ListDump(hList);

						lpCompare = MakeProcInstance(MyListCompare, hInst);
						ListQSort(hList, lpCompare);
						FreeProcInstance(lpCompare);

						ListDump(hList);

						lpTmp = ListGetFirstNode(hList);
						i = 0;
						while (lpTmp) {
							st[i] = lpTmp->c;
							i++;
							lpTmp = ListGetNextNode(hList, lpTmp);
						}
						st[i] = 0;
						MessageBox(hwnd,(LPSTR) st, "Sort Results", MB_ICONSTOP);

						lpTmp  = ListGetNode(hList,5);
						lpTmp1 = ListGetPrevNode(hList,lpTmp);
						ListDeleteNode(hList,lpTmp);

						ListDump(hList);

						lpTmp = ListAllocNode(hList);
						lpTmp->a = 5;
						lpTmp->b = 5 * 0x10;
						ListInsertNode(hList, lpTmp1, lpTmp);

						ListDump(hList);

						lpTmp = ListGetFirstNode(hList);
						while (lpTmp) {
							i = lpTmp->a + lpTmp->b;
							lpTmp = ListGetNextNode(hList, lpTmp);
						}
						ListFree(hList);
						
					}
					break;
					
				case IDM_FARLOCAL:
					{
						char szText[80];
						FHANDLE tmp;
						if (wSize = GetSize("ShrinkHeap")) {
							for (i=1;i<10240;i++) {
								if(!(tmp = FarLocalAlloc(LMEM_FIXED | LMEM_ZEROINIT, wSize))) {
									MessageBox(hwnd, "Failure","FarLocal",MB_ICONSTOP);
									break;

								}
								else {
									na++;
									sprintf(szText, "Heap:Handle %Fp (Allocation :%07lu)",tmp, na);
									MonoAtSay(0,0,szText);
								}
							}
						}
					}
					break;

				case IDM_ABOUT:
					AboutDialog(hwnd);
					break;

				case IDM_WINDOWTILE:
					SendMessage(hwndMDIClient, WM_MDITILE, 0, 0L);
					break;

				case IDM_WINDOWCASCADE:
					SendMessage(hwndMDIClient, WM_MDICASCADE, 0, 0L);
					break;

				case IDM_WINDOWICONS:
					SendMessage(hwndMDIClient, WM_MDIICONARRANGE, 0, 0L);
					break;

				case IDM_WINDOWCLOSEALL:
					CloseAllChildren();
					ShowWindow(hwndMDIClient, SW_SHOW);
					break;

				case IDM_MENUCHANGE:
					ChangeMDIMenu();
					break;

				case IDM_EXIT:
					PostMessage(hwndFrame, WM_SYSCOMMAND, SC_CLOSE, 0L);
					break;

				case IDM_ALLOC:
					if (lpArena = LockArena()) {
						for (i=1;i<=ARENALIMIT;i++) {
							if (lpArena->handle == 0) {
								if (wSize = GetAllocSize()) {
									lpArena->handle = MultLocalAlloc(ActiveHeap, wLFlags, wSize);
									lpArena->wFlags = wLFlags;
									RePaintChild();
								}
								break;
							}
							lpArena++;
						}
						UnlockArena();
					}
					break;

				case IDM_COMPACT:
					if (wSize = GetSize("ShrinkHeap")) {
						MultLocalCompact(ActiveHeap, (wSize * 1024));
						RePaintChild();
					}
					break;

				case IDM_DISCARD:
					if (hlMem = GetHandle()) {
						MultLocalDiscard(ActiveHeap, hlMem);
						RePaintChild();
					}
					break;

				case IDM_FREE:
					if (hlMem = GetHandle()) {
						if ((MultLocalFlags(ActiveHeap, hlMem) & LMEM_LOCKCOUNT) == 0) {
							if (lpArena = LockArena()) {
								for (i=1;i<=ARENALIMIT;i++) {
									if (lpArena->handle == hlMem) {
										lpArena->handle = MultLocalFree(ActiveHeap, hlMem);
										RePaintChild();
										break;
									}
									lpArena++;
								}
								UnlockArena();
							}
						}
						else
							MessageBox(hwnd,"Cannot Free Locked Objects", "Error", MB_ICONEXCLAMATION);
					}
					break;

				case IDM_LOCK:
					if (hlMem = GetHandle()) {
						MultLocalLock(ActiveHeap, hlMem);
						RePaintChild();
					}
					break;

				case IDM_REALLOC:
					if (wSize = GetHandleAndSize()) {
						hlMem = wLFlags;
						if (lpArena = LockArena()) {
							for (i=1;i<=ARENALIMIT;i++) {
								if (lpArena->handle == hlMem) {
									MultLocalReAlloc(ActiveHeap, hlMem, wSize, lpArena->wFlags);
									RePaintChild();
									break;
								}
								lpArena++;
							}
							UnlockArena();
						}
					}
					break;

				case IDM_SHRINK:
					if (wSize = GetSize("ShrinkHeap")) {
						MultLocalShrink(ActiveHeap, (wSize * 1024));
						RePaintChild();
					}
					break;

				case IDM_UNLOCK:
					if (hlMem = GetHandle()) {
						MultLocalUnlock(ActiveHeap, hlMem);
						RePaintChild();
					}
					break;
			}
			break;

		case WM_DESTROY:
			PostQuitMessage( 0 );
			break;
	}
	return DefFrameProc( hwnd, hwndMDIClient, msg, wParam, lParam );
}


/*----------------------------------------------------------------------------
  Create a document window of a given color on the MDI desktop.
  Allocate the heap for this window and store the handle in
  the window extra bytes.

  Also stores the handle to our pseudo arena and arena size in
  window extra words. This is for this test app only and not a
  a part of the heap management routines.
----------------------------------------------------------------------------*/

BOOL MLHTestCreate(int wSize)
{
	char szTitle[80];
	HWND hWnd;
	HANDLE hMem;
	HANDLE hLMem;
	MDICREATESTRUCT  mcs;


	// Allocate and Initialize Heap
	if (hMem = MultLocalInit(wSize)) {

		// Format the MDI Child Title
		sprintf( szTitle, "%s %X", "Heap ID", hMem);

		mcs.szTitle    = szTitle;
		mcs.szClass    = szChild;
		mcs.hOwner     = hInst;
		mcs.x = mcs.cx = CW_USEDEFAULT;
		mcs.y = mcs.cy = CW_USEDEFAULT;
		mcs.style      = CHILDSTYLE;

		if (hWnd = (HANDLE) SendMessage(hwndMDIClient,WM_MDICREATE,0,(LONG)(LPMDICREATESTRUCT)&mcs)) {

			// Store the handle to the heap in the winextra word
			SetWindowWord(hWnd, WE_HEAP, hMem);

			// Allocate space for ARENALIMIT arena entries
			if (hLMem = MultLocalAlloc(hMem, (LMEM_MOVEABLE | LMEM_ZEROINIT), (ARENALIMIT * sizeof(LOCALARENA))))
				// Store the arena handle in window extra word
				SetWindowWord(hWnd, WE_ARENA, hLMem);
				RePaintChild();
			}

		else {                  // Failure, so we need to clean up
			GlobalUnlock(hMem); // LocalInit calls GlobalLock
			GlobalFree(hMem);   // Free the Heap
			return(FALSE);
		}
		return(TRUE);
	}
	else
		return(FALSE);
}


VOID WalkArena(HWND hwnd)
{
	char szText[80];
	PAINTSTRUCT paint;
	LPLOCALARENA lpArena;
	INT i,y;
	WORD wFlags,wCount,wBSize,wHSize;
	HANDLE hOldFont;
	HWND hwndOldActive = hwndActive;

	hwndActive = hwnd;
	BeginPaint(hwnd, &paint);
	hOldFont = SelectObject(paint.hdc,GetStockObject(OEM_FIXED_FONT));
	SetBkColor(paint.hdc, GetSysColor(COLOR_APPWORKSPACE - 1));

	if (lpArena = LockArena()) {
		wFlags  = MultLocalFlags(ActiveHeap, ActiveArena);
		wCount = (wFlags & LMEM_LOCKCOUNT);
		wHSize = MultLocalSize(ActiveHeap, ActiveArena);
		strcpy(szText, szTitle);
		y=0;
		TextOut(paint.hdc, 0, y, szText, strlen(szText));
		TextOut(paint.hdc, 0, ((++y) * yChar), szBar, strlen(szBar));

		sprintf(szText, szPrint, ActiveArena, LOWORD( (DWORD) lpArena), wHSize, wCount, "Arena Table");
		TextOut(paint.hdc, 0, ((++y) * yChar), szText, strlen(szText));

		for (i=1;i<=ARENALIMIT;i++) {
			if (lpArena->handle != 0) {

				wFlags = MultLocalFlags(ActiveHeap, lpArena->handle);
				wCount = (wFlags & LMEM_LOCKCOUNT);
				wBSize = MultLocalSize(ActiveHeap, lpArena->handle);
				wHSize += wBSize;

				lpArena->offset = LOWORD( (DWORD) MultLocalLock(ActiveHeap,lpArena->handle));
				MultLocalUnlock(ActiveHeap, lpArena->handle);
				if ((wFlags & LMEM_DISCARDED) == LMEM_DISCARDED)
					sprintf(szText, szPrint,lpArena->handle, lpArena->offset, wBSize, wCount, "Discarded  ");
				else if ((wFlags & LMEM_DISCARDABLE) == LMEM_DISCARDABLE)
					sprintf(szText, szPrint,lpArena->handle, lpArena->offset, wBSize, wCount, "Discardable");
				else if (lpArena->handle == lpArena->offset)
					sprintf(szText, szPrint,lpArena->handle, lpArena->offset, wBSize, wCount, "Fixed      ");
				else
					sprintf(szText, szPrint,lpArena->handle, lpArena->offset, wBSize, wCount, "           ");

				TextOut(paint.hdc, 0, ((++y) * yChar), szText, strlen(szText));
			}
			lpArena++;
		}
		TextOut(paint.hdc, 0, ((++y) * yChar), szBar, strlen(szBar));
		wBSize = GlobalSize(ActiveHeap);
		sprintf(szText, szSum, wBSize, wHSize, (wBSize - wHSize));
		TextOut(paint.hdc, 0, ((++y) * yChar), szText, strlen(szText));
		UnlockArena();
	}
	SelectObject(paint.hdc,hOldFont);
	EndPaint(hwnd, &paint);
	hwndActive = hwndOldActive;
}

/*----------------------------------------------------------------------------
  MDIChildWndProc(hwndChild, msg, wParam, lParam ) : LONG;
  Handle messages for our documents.
----------------------------------------------------------------------------*/
LONG FAR PASCAL MDIChildWndProc(HWND hwndChild,unsigned msg, WORD wParam, LONG lParam)
{
	HANDLE hlTemp, hMem;
	LPLOCALARENA lpArena;

	switch (msg) {

		case WM_CREATE:
			{
				HANDLE oldFont;
				TEXTMETRIC tm;
				LPCREATESTRUCT lpCS = (LPCREATESTRUCT) lParam;
				HDC hdc = GetDC(hwndChild);
				oldFont = SelectObject(hdc,GetStockObject(OEM_FIXED_FONT));
				lpCS->cx = LOWORD(GetTextExtent(hdc, szBar, strlen(szBar))) +
				  (2 * GetSystemMetrics(SM_CXFRAME));
				SelectObject(hdc,oldFont);
				GetTextMetrics(hdc, &tm);
				xChar = tm.tmAveCharWidth;
				yChar = tm.tmHeight + tm.tmExternalLeading;
				ReleaseDC(hwndChild, hdc);
				MoveWindow(hwndChild, lpCS->x, lpCS->y, lpCS->cx, lpCS->cy, FALSE);
			}
			break;

		case WM_MDIACTIVATE:
			if (wParam)
				 hwndActive = hwndChild;
			else
				 hwndActive = NULL;
			PostMessage(hwndFrame, WM_COMMAND, IDM_MENUCHANGE, 0L);
			break;

		case WM_SIZE:
			switch (wParam) {
				case SIZEICONIC:
				case SIZENORMAL:
				PostMessage(hwndFrame, WM_COMMAND, IDM_MENUCHANGE, 0L);
				break;
			}
			break;

		case WM_PAINT:
			WalkArena(hwndChild);
			break;

		case WM_DESTROY:
			hMem = GetWindowWord(hwndChild, WE_HEAP);
			GlobalUnlock(hMem);
			if (GlobalFree(hMem))
				MessageBox(hwndFrame,"Cannot Free Heap", "Error", MB_ICONEXCLAMATION);
			break;
	}
	return DefMDIChildProc(hwndChild, msg, wParam, lParam );
}


/*----------------------------------------------------------------------------
  MainDlgAbout( hDlg, message, wParam, lParam ) : INT
  Handle the ABOUT dialog box.
----------------------------------------------------------------------------*/
INT FAR PASCAL MainDlgAbout(HWND hDlg,unsigned msg, WORD wParam, LONG lParam)
{
	int         iReturn = FALSE;  /* Return value */
	switch(msg) {
		case WM_INITDIALOG:
			iReturn = TRUE;
			break;

		case WM_COMMAND:
			EndDialog(hDlg, TRUE);
			break;
	}
	return iReturn;
}

/*----------------------------------------------------------------------------
  CloseAllChildren () : VOID
  Destroys all MDI child windows
----------------------------------------------------------------------------*/
VOID PASCAL CloseAllChildren ()
{
	register HWND hwnd;
	ShowWindow(hwndMDIClient,SW_HIDE);
	while (hwnd = GetWindow (hwndMDIClient, GW_CHILD)) {
		while (hwnd && GetWindow (hwnd, GW_OWNER))
			hwnd = GetWindow (hwnd, GW_HWNDNEXT);

		if (!hwnd)
			break;

		SendMessage (hwndMDIClient, WM_MDIDESTROY, (WORD)hwnd, 0L);
	}
}


/*----------------------------------------------------------------------------
  ReAllocDlgAbout( hDlg, message, wParam, lParam ) : INT
  Handles messages for the ReAlloc dialog box.
----------------------------------------------------------------------------*/
WORD FAR PASCAL ReAllocDlgProc(HWND hDlg, unsigned msg, WORD wParam, LONG lParam)
{
	int iReturn = FALSE;
	switch(msg) {

		case WM_INITDIALOG:
			SetDlgItemInt(hDlg, ID_BYTES, 1024, FALSE);
			iReturn = TRUE;
			break;

		case WM_COMMAND:
			switch (wParam) {
				case IDOK:
					EndDialog(hDlg, GetDlgItemInt(hDlg, ID_BYTES, NULL, FALSE));
					wLFlags = GetDlgItemInt(hDlg, ID_HANDLE, NULL, FALSE);
					break;

				case IDCANCEL:
					EndDialog(hDlg, 0);
					break;
			 }
			 break;
	}
	return iReturn;
}

/*----------------------------------------------------------------------------
  HandleDlgAbout( hDlg, message, wParam, lParam ) : INT
  Handles messages for the Handle dialog box.
----------------------------------------------------------------------------*/
HANDLE FAR PASCAL HandleDlgProc(HWND hDlg, unsigned msg, WORD wParam, LONG lParam)
{
	int iReturn = FALSE;
	switch(msg) {

		case WM_INITDIALOG:
			iReturn = TRUE;
			break;

		case WM_COMMAND:
			switch (wParam) {

				case IDOK:
					EndDialog(hDlg, GetDlgItemInt(hDlg, ID_HANDLE, NULL, FALSE));
					break;

				case IDCANCEL:
					EndDialog(hDlg, 0);
					break;
			}
			break;
	}
	return iReturn;
}


/*----------------------------------------------------------------------------
  NewHeapDlgAbout( hDlg, message, wParam, lParam ) : INT
  Handles messages for the NewHeap dialog box.
----------------------------------------------------------------------------*/
INT FAR PASCAL NewHeapDlgProc(HWND hDlg,unsigned msg,WORD wParam, LONG lParam)
{
	int iReturn = FALSE;

	switch(msg) {

		case WM_INITDIALOG:
			SetDlgItemInt(hDlg, ID_BYTES, 4, FALSE);
			iReturn = TRUE;
			break;

		case WM_COMMAND:
			switch (wParam) {
				case IDOK:
					EndDialog(hDlg, GetDlgItemInt(hDlg, ID_BYTES, NULL, FALSE));
					break;
				case IDCANCEL:
					EndDialog(hDlg, 0);
					break;
			}
			break;
	}
	return iReturn;
}

#define GetButtonValue(id,value) (IsDlgButtonChecked(hDlg,id)?value:0)
#define SetButton(id,value) CheckDlgButton(hDlg,id,value)
#define ToggleButton(id) CheckDlgButton(hDlg,id,(IsDlgButtonChecked(hDlg,id)?FALSE:TRUE))

/*----------------------------------------------------------------------------
  AllocDlgProc( hDlg, message, wParam, lParam ) : INT
  Handles messages for the Alloc dialog box.
----------------------------------------------------------------------------*/
WORD FAR PASCAL AllocDlgProc(HWND hDlg, unsigned msg, WORD wParam, LONG lParam)
{
	int iReturn = FALSE;
	switch(msg) {
	
		case WM_INITDIALOG:
			SetDlgItemInt(hDlg, ID_ABYTES, 1024, FALSE);
			SetButton(ID_DISC, FALSE);
			SetButton(ID_FIXED, FALSE);
			SetButton(ID_MOVES, TRUE);
			SetButton(ID_NOCOMP, TRUE);
			SetButton(ID_NODISC, TRUE);
			SetButton(ID_ZERO, TRUE);
			iReturn = TRUE;
			break;

		case WM_COMMAND:
			switch (wParam) {

				case ID_FIXED:
					SetButton(ID_MOVES, FALSE);
					SetButton(ID_DISC, FALSE);
					SetButton(wParam, TRUE);
					break;

				case ID_MOVES:
					SetButton(ID_FIXED, FALSE);
					SetButton(wParam, TRUE);
					break;

				case ID_DISC:
					if (!IsDlgButtonChecked(hDlg, ID_FIXED))
						ToggleButton(wParam);
					break;

				case ID_NOCOMP:
				case ID_NODISC:
				case ID_ZERO:
					ToggleButton(wParam);
					break;

				case IDOK:
					wLFlags =  GetButtonValue(ID_DISC, LMEM_DISCARDABLE);
					wLFlags |= GetButtonValue(ID_FIXED, LMEM_FIXED);
					wLFlags |= GetButtonValue(ID_MOVES, LMEM_MOVEABLE);
					wLFlags |= GetButtonValue(ID_NOCOMP, LMEM_NOCOMPACT);
					wLFlags |= GetButtonValue(ID_NODISC, LMEM_NODISCARD);
					wLFlags |= GetButtonValue(ID_ZERO, LMEM_ZEROINIT);
					EndDialog(hDlg, GetDlgItemInt(hDlg, ID_ABYTES, NULL, FALSE));
					break;

				case IDCANCEL:
					wLFlags = 0;
					EndDialog(hDlg, 0);
					break;
			}
			break;
	}
	return iReturn;
}
