/*-----------------------------------------------------------------------------
 MLHTEST.H
 MDI Multiple Local Heap Demo
 11-3-90
 danq
-----------------------------------------------------------------------------*/

// Macros
#ifdef RC_INVOKED
#define ID(id) id
#else
#define ID(id) MAKEINTRESOURCE(id)
#endif

#define INT                int
#define ActiveHeap         GetWindowWord(hwndActive, WE_HEAP)
#define ActiveArena        GetWindowWord(hwndActive, WE_ARENA)

// MDI Window Positions
#define WINDOWMENU         1
#define WINDOWMENUCHILD    2

// Style attributes of MDI children
#define CHILDSTYLE         0

// Limit of allocations per heap.
// Note: Just necessary for this test app

#define ARENALIMIT         25

// pseudo arena structure
typedef struct tagLocalArena {
	HANDLE   handle;
	WORD     offset;
	WORD     wFlags;
} LOCALARENA, FAR * LPLOCALARENA;

// Strings
#define IDS_APPNAME        1

// File Menu Selections
#define IDM_NEW            0x101
#define IDM_ABOUT          0x102
#define IDM_EXIT           0x103
#define IDM_FARLOCAL       0x104
#define IDM_LISTMGR        0x105

// Action Menu Selections
#define IDM_ALLOC          0x200
#define IDM_COMPACT        0x201
#define IDM_DISCARD        0x202
#define IDM_FREE           0x204
#define IDM_LOCK           0x206
#define IDM_REALLOC        0x207
#define IDM_SHRINK         0x208
#define IDM_UNLOCK         0x209

// Window Menu Selections
#define IDM_WINDOWTILE     0x300
#define IDM_WINDOWCASCADE  0x301
#define IDM_WINDOWICONS    0x302
#define IDM_WINDOWCLOSEALL 0x303
#define IDM_WINDOWCHILD    0x304

// menu change message
#define IDM_MENUCHANGE     0x401

// heap dialogs
#define ID_BYTES           0x500
#define ID_HANDLE          0x501

// Alloc dialog
#define ID_ABYTES          0x600
#define ID_DISC            0x601
#define ID_FIXED           0x602
#define ID_MOVES           0x603
#define ID_NOCOMP          0x604
#define ID_NODISC          0x605
#define ID_ZERO            0x606

// Resource ID's
#define IDMLHTest          ID(1)
#define MAINICON           ID(2)
#define CHILDICON          ID(3)
#define AppMenu            ID(4)
#define ChildMenu          ID(5)

// Window extra byte definitions
#define WE_EXTRA           4  // Number of Window Extra Bytes
#define WE_ARENA           0  // Local Arena Handle
#define WE_HEAP            2  // Global Memory Handle to Local Heap

// Function Prototypes
BOOL InitializeApplication(void);
BOOL InitializeInstance(unsigned int);
BOOL MLHTestCreate(INT);
INT PASCAL WinMain(HANDLE, HANDLE, LPSTR, INT);
LONG FAR PASCAL MDIFrameWndProc(HWND, unsigned, WORD, LONG);
LONG FAR PASCAL MDIChildWndProc(HWND, unsigned, WORD, LONG);
INT FAR PASCAL MainDlgAbout(HWND, unsigned, WORD, LONG);
INT FAR PASCAL NewHeapDlgProc(HWND, unsigned, WORD, LONG);
WORD FAR PASCAL AllocDlgProc(HWND, unsigned, WORD, LONG);
WORD FAR PASCAL ReAllocDlgProc(HWND, unsigned, WORD, LONG);
HANDLE FAR PASCAL HandleDlgProc(HWND, unsigned, WORD, LONG);
BOOL PASCAL QueryCloseAllChildren (VOID);
VOID PASCAL CloseAllChildren (VOID);
