// @(#) %M% V%I% %H%
//
// File name
// -------------
// NEWTRACK.CPP
//
// (c) Cavendish Software Ltd 1991, 1992
//
// Document References
// -------------------
// This is a general purpose module, and as such has no document references
//
// Document References
// -------------------
// This is a general purpose module, and as such has no document references
//
// File Description
// ----------------
// Newtrack v2.0/Windows.  This part of NewTrack must be included in
//	each .EXE or .DLL.
//

// PREPROCESSOR SYMBOL DEFINITIONS -- Complete Exclusion
#if (!defined(USE_NEWTRACK)) || (USE_NEWTRACK)
	

// HEADER FILES
#include <alloc.h>
#include <dos.h>
#include <windows.h>
#include <newtrack.hpp>


// PREPROCESSOR SYMBOL DEFINITIONS
#define USE_WINDOWSALLOC		0


// GLOBAL VARIABLES
int _far __newtrack = 1;


// FUNCTIONS

// Deletes the pointer, with validation if active
void operator delete(void far *p)
{
	// If it's a valid pointer or there is no module checking, free it up
	if (!__newtrack || (p = NT_Delete((NT_PTR) p)) != 0)
	{
#if USE_WINDOWSALLOC
		HGLOBAL	hglb = *(((HGLOBAL *)p) - 1);
		if (GlobalUnlock(hglb) == 0)
			GlobalFree(hglb);
#else
		free(p);
#endif
    }
}

// Allocates a pointer, tracking the pointer if active
void far *operator new(unsigned size)
{
	unsigned int	cseg;
	unsigned int	coff;

	NT_GETCALLER(2, cseg, coff);
	return NT_AllocMem(size, MK_FP(cseg, coff));
}

// Allocates a pointer, tracking the pointer if active
void far *operator new(unsigned long size)
{
	unsigned int	cseg;
	unsigned int	coff;

	NT_GETCALLER(4, cseg, coff);
	return NT_AllocMem(size, MK_FP(cseg, coff));
}

// Does the actual allocation & tracking.
void far *NT_AllocMem(unsigned long _size, void far *caller)
{
#if USE_WINDOWSALLOC
	NT_SIZE size;

    // Work out the size to allocate
	if (!__newtrack)
		size = _size;
	else
		size = NT_NewSize(_size);

    // Allocate it
	HGLOBAL		hglb = GlobalAlloc(GPTR | GMEM_NODISCARD | GMEM_SHARE,
						size + sizeof(HGLOBAL));
	void far	*p = 0;

    // Lock the memory (if we got any)
	if (hglb)
		p = GlobalLock(hglb);

    // If we couldn't lock it, free any that we did allocate
	if (!p && hglb)
		GlobalFree(hglb);

    // Save the Handle in the first few bytes, and move the pointer past it
	if (p)
    {
		*((HGLOBAL *)p) = hglb;
		p = (void far *)(((HGLOBAL *)p) + 1);
    }

    // If NewTrack is not wanted, return now we have the actual memory
    if (!__newtrack)
		return p;

    // Return a NewTrack manipulated pointer to the data
	return (void far *)NT_New(p, size, caller);
#else
	if (!__newtrack)
		return farmalloc(_size);

	NT_SIZE		size = NT_NewSize(_size);

	return (void far *)NT_New(farmalloc(size), size, caller);
#endif
};


#endif // !def(USE_NEWTRACK) || (USE_NEWTRACK != 0)
