// @(#) %M% V%I% %H%
//
// File name
// -------------
// NEWTRACK.HPP
//
// (c) Cavendish Software Ltd 1991, 1992
//
// Document References
// -------------------
// This is a general purpose module, and as such has no document references
//
// File Description
// ----------------
// Newtrack v2.0/Windows.  This version of NewTrack supports windows and DLLs.
//


#ifndef NEWTRACK_HPP
#define NEWTRACK_HPP


// PREPROCESSOR SYMBOL DEFINITIONS -- Complete Exclusion of NewTrack
#if (!defined(USE_NEWTRACK)) || (USE_NEWTRACK)


// PREPROCESSOR SYMBOL DEFINITIONS -- DLL/Exports
#ifdef __DLL__
#define NT_EXPORT _export far
#else
#define NT_EXPORT
#endif


// PREPROCESSOR SYMBOL DEFINITIONS
// Try to get the caller's address off the stack.  Assuming that this
//	is compiled in Large model with parameters passed on the stack,
//	the callers return address starts at BP + 2 + argument_size.
//
// Register setup:
//	DS == SS
//
#define NT_GETCALLER(n, seg, off)													\
	asm push ax;		                                                           	\
																					\
	asm mov ax, [bp + 2 + n];                                                       \
	asm mov seg, ax;                                                                \
                                                                                    \
	asm mov ax, [bp + 0 + n];                                                       \
	asm mov off, ax;                                                                \
                                                                                    \
	asm pop ax;
/*
#define NT_GETCALLER(n)																\
	unsigned	coff;                                                               \
	unsigned	cseg;                                                               \
	unsigned	oldax;                                                              \
                                                                                    \
	asm mov oldax, ax;                                                           	\
	                                                                                \
	asm mov ax, [bp + 2 + n];                                                       \
	asm mov cseg, ax;                                                               \
                                                                                    \
	asm mov ax, [bp + 0 + n];                                                       \
	asm mov coff, ax;                                                               \
                                                                                    \
	asm mov ax, oldax;
*/


// PREPROCESSOR SYMBOL DEFINITIONS -- Over/Under run checking
#define NT_PRE_TEXT			"PrePrePrePre"
#define NT_PRE_SIZE			strlen(NT_PRE_TEXT)
#define NT_POST_TEXT		"PostPostPost"
#define NT_POST_SIZE		strlen(NT_POST_TEXT)


// PREPROCESSOR SYMBOL DEFINITIONS -- Fill Characters
#define NT_NEWFILL			'#'
#define NT_DELFILL			(0xff)


// PREPROCESSOR SYMBOL DEFINITIONS -- Macros to turn NewTrack on & off
#define NEWTRACK_ON()		__newtrack = 1
#define NEWTRACK_OFF()		__newtrack = 0
#define NEWTRACK_PUSH()		int __save__newtrack = __newtrack;
#define NEWTRACK_POP()		__newtrack = __save__newtrack;


// TYPE DEFINITIONS
typedef unsigned char huge	*NT_PTR;
typedef unsigned long		NT_SIZE;
typedef void far *			TRK_CALLER;


// EXTERNAL VARIABLES -- Turns NewTrack on & off in NEWTRACK.CPP
extern int _far __newtrack;


// FUNCTION PROTOTYPES
#ifdef __cplusplus
extern "C"
{
#endif
void			NT_EXPORT _far _pascal NT_Initialise(void);
unsigned long	NT_EXPORT _far _pascal NT_Terminate(void);
unsigned long	NT_EXPORT _far _pascal NT_NAllocs(void);
NT_PTR			NT_EXPORT _far _pascal NT_New(void far *_p, NT_SIZE size, TRK_CALLER caller);
void far *		NT_EXPORT _far _pascal NT_Delete(NT_PTR p);
NT_SIZE			NT_EXPORT _far _pascal NT_NewSize(unsigned long size);
void far *				  NT_AllocMem(unsigned long size, void far *caller);
#ifdef __cplusplus
};
#endif

#else // !def(USE_NEWTRACK) || USE_NEWTRACK


// PREPROCESSOR SYMBOL DEFINITIONS -- Fake NewTrack to the compiler
#define NEWTRACK_ON()
#define NEWTRACK_OFF()
#define NEWTRACK_PUSH()
#define NEWTRACK_POP()
#define NT_Initialise(void)
#define NT_Terminate(void)		0
#define NT_NAllocs(void)		0


#endif // !def(USE_NEWTRACK) || USE_NEWTRACK

#endif // !def(NEWTRACK_HPP)


