{OttoMenu 3.0 - Program Copyright (C) Doug Overmyer 12/17/91}
{Begun 12/2/91} {Rel 3.5} {tabs = 2}
program OttoMenu;

{$S-}{$R om.RES}{$R-}{$X+}{$V-}
uses WinTypes,WinProcs,Strings,WObjects,WinDos,StdDlgs,WFPlus,Buttons,
	SclpText,WIN31,ShellAPI,Bitmap,CommDlg;
const
	id_BMP       = 99;
  id_RGB       = 100;
	id_ButOffset = 120;
 	id_But0    = 200;     {Base value of Icon buttons   }
  id_But1    = 201;     {User defined button 1 iconbar}
  id_But2    = 202;     {      "             2 iconbar}
  id_But3    = 203;     {      "             3 iconbar}
  id_But4    = 204;     {      "             3 iconbar}
  id_But5    = 205;     {      "             5 iconbar}
  id_But6    = 206;     {User defined button 6 iconbar}
  id_But7    = 207;     {      "             7 iconbar}
  id_But8    = 208;     {      "             8 iconbar}
  id_But9    = 209;     {      "             9 iconbar}
  id_But10   = 210;     {      "            10 iconbar}
  id_But11   = 211;     {      "            11        }
  id_But12   = 212;     {                   12        }
  id_But13   = 213;     {                   13        }
  id_But14   = 214;     {                   14        }
  id_But15   = 215;     {                   15        }
  id_But21   = 221;     {page 1 icon}
  id_But22   = 222;     {page 2 icon}
  id_But23   = 223;     {page 3 icon}
  id_But24   = 224;     {page 4 icon}
  id_Gb1     = 300;     {group box for radio buttons}
  id_GB2     = 200;     {group box for page icons}
  id_St1     = 401;     {Static text 1         icon bar}
  id_St2     = 402;     {Static text 2         icon bar}
  id_Pict    = 501;
  id_D1      = 550;
  id_D1RB1   = 551;
  id_D1RB2   = 552;
  id_D2OK    = 601;     {OK button in Dlg2     }
  id_D2Browse= 650;     {Dlg2 Browse button}
  id_D2EC1   = 603;     {Edit Control 1 in Dlg2 item #}
  id_D2EC2   = 605;     {             2         Name}
  id_D2EC3   = 607;     {             3         file}
  id_D2EC4   = 609;     {             4         Start directory}
  id_D2EC5   = 617;     {             5         parameters}
  id_D2EC6   = 621;     {             6         start size}
  id_D3LB1   = 701;
  idm_About  = 801;     {menu id for OM_About menu}
{************************  Types    ************************}
type
TOMApplication = object(TApplication)
  SplashRect: TRect;
  constructor Init(AName:PChar);
  procedure InitMainWindow;virtual;
  procedure Redraw;
end;

ItemRec = record
ItemNum,PgmName,PgmFile,Dir,Params,Cmdshow:Array[0..69] of Char;
end;

PPgmItem = ^TPgmItem;
TPgmItem = object(TObject)
	PgmName:PChar;
  PgmFile:PChar;
  Dir:PChar;
  Params:PChar;
  CmdShow:PChar;
  constructor Init(NewPgmName,NewPgmFile,NewDir,NewParams,NewCmdShow:PChar);
  destructor Done;virtual;
end;

POMCol = ^TOMCol;
TOMCol = object(TCollection)
	TheItems:PCollection;
	constructor Init(ALimit,ADelta:Integer);
  destructor Done;virtual;
  function At(Indx:Integer):PPgmItem;virtual;
  procedure ReadItems(Start,Finish:Integer);virtual;
	procedure ItemGet(var PgmItem:ItemRec);virtual;
	procedure ItemSet(PgmItem:ItemRec);virtual;
  function GetCount:Integer;virtual;
  function IsValidIndx(Indx:Integer):Boolean;
end;

POMDlg2 = ^TOMDlg2;
TOMDlg2 = object(TDialog)              {Item setup dialog}
	EC1,EC2,EC3,EC4,EC5,EC6:PEdit;
  constructor Init(AParent:PWindowsObject;AName:PChar);
  procedure IDD2OK(var Msg:TMessage); virtual id_First+id_D2OK;
  procedure IDBrowse(var Msg:TMessage);virtual id_First+id_D2Browse;
end;

POMDlg3 = ^TOMDlg3;
TOMDlg3 = object(TDialog)              {Run dialog}
	procedure SetupWindow; virtual;
end;

POMAboutDlg = ^TOMAboutDlg;
TOMAboutDlg = object(TDialog)
	Logo:HBitmap;
  Brush:HBrush;
  constructor Init(AParent:PWindowsObject;AName:PChar;ALogo:HBitmap;ABrush:HBrush);
	procedure WMCtlColor(var Msg:TMessage);virtual wm_First+wm_CtlColor;
end;

POMRButton = ^TOMRButton;
TOMRButton = object(TRadioButton)
	procedure WMRButtonDown(var Msg:TMessage);virtual wm_First+wm_RButtonDown;
end;

POMGroupBox = ^TOMGroupBox;
TOMGroupBox = object(TGroupBox)
	procedure SetupWindow;virtual;
  function CanClose:Boolean;virtual;
  procedure WMDropFiles(var Msg:TMessage);virtual wm_First+wm_DropFiles;
end;

POMStatic = ^TOMStatic;
TOMStatic = object(TSText)
	procedure WMRButtonDown(var Msg:TMessage);virtual wm_First+wm_RButtonDown;
end;

type
POMWindow = ^TOMWindow;
TOMWindow = object(TWindow)
  BN1:Array[0..10] of PDDButton;  {icon bar button pointers}
  BN2:Array[0..5] of PODButton;
  BNR:Array[0..5] of PIcon; {page icons}
  GB1:POMGroupBox;
  GB2:PIconGroup;
  RB:Array[0..20] of POMRButton; {radio button pointers id's 301-320}
  ST1:POMStatic;
  Apps:POMCol;
  BkgndBr:HBrush;
  Logo,Pict:HBitmap;
  PictRect:TRect;
  PageNum,Max_Pages,AutoMin:Integer;
  Helv:HFont;
  D2TfB:ItemRec;
  Bitmap:PTBMP;
  StatDisp:Char;
	constructor Init(AParent:PWindowsObject;ATitle:PChar);
  destructor Done;virtual;
  procedure SetupWindow;virtual;
  function GetClassName:PChar;virtual;
  procedure SetRBText;virtual;
  procedure Paint(PaintDC:HDC;var PaintInfo:TPaintStruct);virtual;
  procedure SetStaticText;
  procedure	WMDrawItem(var Msg:TMessage);virtual wm_First + wm_DrawItem;
	procedure IDBut11(var Msg:TMessage);virtual id_First+id_But11; { }
  procedure IDBut12(var Msg:TMessage);virtual id_First+id_But12; { }
  procedure	IDBut13(var Msg:TMessage);virtual id_First+id_But13; { }
  procedure IDBut14(var Msg:TMessage);virtual id_First+id_But14; { }
  procedure IDBut15(var Msg:TMessage);virtual id_First+id_But15; {Free Icon}
  procedure DefChildProc(var Msg:TMessage);virtual;
  procedure WinExecc(var Msg:TMessage);virtual;
  procedure	WMSysCommand(var Msg:TMessage);virtual wm_First+wm_SysCommand;
  procedure SetItemValues(PgmItem:ItemRec);virtual;
	procedure WMCtlColor(var Msg:TMessage);virtual wm_First+wm_CtlColor;
  procedure RunIt;virtual;
  procedure UMDropFiles(var Msg:TMessage);virtual wm_User+wm_Dropfiles;
	procedure UMRButtonDown(var Msg:TMessage);virtual wm_User+wm_RButtonDown;
	procedure LoadBMP(BMPName:PChar);
  function CtrlToIndx(Id:Integer):Integer;virtual;
  procedure WMRButtonDown(var Msg:TMessage);virtual wm_First+wm_RButtonDown;
  procedure SetStatProp(var Msg:TMessage);virtual;
  procedure SetButProp(var Msg:TMessage);virtual;
  procedure SetBMPProp(var Msg:TMessage);virtual;
  procedure SetRGBProp(var Msg:TMessage);virtual;
  procedure WMDropFiles(var Msg:TMessage);virtual wm_First+wm_DropFiles;
  procedure GetPictRect;virtual;
  procedure CreateBrush(BkgndColor:PChar);virtual;
  procedure WMNCRButtonDown(Msg:TMessage);virtual wm_First+wm_NCRButtonDown;
end;

{***********************  Methods    *******************************}
constructor TOMApplication.Init(AName: PChar);
var
  DC, MemDC: HDC;
  OldBitMap, BitMap: HBitMap;
  BM: TBitMap;
begin
  DC := CreateDC('Display', Nil, Nil, Nil);
  BitMap := LoadBitMap(HInstance, 'OM_Logo');
  MemDC := CreateCompatibleDC(DC);
  OldBitMap := SelectObject(MemDC, BitMap);
  GetObject(BitMap, SizeOf(BM), @BM);
  with SplashRect do
  begin
    Left := 200;
    Top := 150;
    Right := Left + BM.bmWidth;
    Bottom := Top + BM.bmHeight;
    BitBlt(DC, Left, Top, BM.bmWidth, BM.bmHeight, MemDC, 0, 0, SRCCopy);
  end;
  DeleteObject(SelectObject(MemDC, OldBitMap));
  DeleteDC(MemDC);
  DeleteDC(DC);
  TApplication.Init(AName);
end;

procedure TOMApplication.InitMainWindow;
begin
	MainWindow := New(POMWindow,Init(nil,'OttoMenu'));
end;

procedure TOMApplication.Redraw;
begin
	InvalidateRect(0,@SplashRect,True);
end;
{**********************  TOMWindow  *******************************}
constructor TOMWindow.Init(AParent:PWindowsObject;ATitle:PChar);
Const
	BMP:Array[0..25] of PChar = ('','','','','','','','','','','',
  'OM_B1','OM_B2','OM_B3', 'OM_B4', 'OM_B5',
  '','','','','',
  'OM_B21', 'OM_B22','OM_B23','OM_B24','');
{bitmaps OM_B1 to OM_B5 are 34 x 34 16 color resources}
var
  TheBmp:HBitmap;
  Buf:Array[0..69] of Char;
  Indx:Integer;
  TheItem:PPgmItem;
begin
	Logo := 0;Pict := 0;
	TWindow.Init(AParent,ATitle);
  Apps := New(POMCol,Init(101,20));
  PageNum := 1;
  Max_Pages := 5;
  Apps^.ReadItems(0,100);
  Attr.Menu := 0; {LoadMenu(HInstance,'OM_Menu');}
  Attr.X := 20; Attr.Y := 25; Attr.W := 595; Attr.H := 325;
  Attr.Style := ws_Overlapped or ws_SysMenu or ws_MinimizeBox;
  For Indx := 0 to 10 do BN1[Indx] := nil;
  For Indx := 0 to 5 do BN2[Indx] := nil;
  For Indx := 0 to 4 do BNR[Indx] := nil;
  For Indx := 0 to 20 do RB[Indx] := nil;
  For Indx := 1 to 10 do
  	begin
    TheItem := Apps^.At(Indx+80);
  	BN1[Indx]:=New(PDDButton,Init(@Self,id_GB2+Indx,'',Pred(Indx)*35,0,35,35,False,TheItem^.PgmFile));
  	end;
	For Indx := 1 to 5 do
  	BN2[Indx]:=New(PODButton,Init(@Self,id_GB2+10+Indx,'',Pred(Indx)*35,35,35,35,False,BMP[Indx+10]));
  GB2 := New(PIconGroup,Init(@Self,id_Gb2,'',0,35,34,34));
  For Indx := 1 to Pred(Max_Pages) do
		BNR[Indx] := New(PIcon,Init(@Self,Indx+220,'',0,35,34,34,GB2,BMP[Indx+20]));
  St1 := New(POMStatic,Init(@Self,id_St1,'',355,5,235,25,sr_Recessed,
  			dt_Center or dt_VCenter or dt_SingleLine));
  GB1 := New(POMGroupBox,Init(@Self,id_Gb1,'Applications',200,50,350,230));
  For Indx := 1 to 10 do
  	RB[Indx]:=New(POMRButton,Init(@Self,(id_GB1+Indx),'',215,(75+Pred(Indx)*20),160,20,GB1));
  For Indx := 11 to 20 do
  	RB[Indx]:=New(POMRButton,Init(@Self,(id_GB1+Indx),'',385,(75+(Indx-11)*20),160,20,GB1));

	GetPrivateProfileString('OM','BkgndColor','12632256',Buf,SizeOf(Buf),'OM.INI');
  BkgndBr := 0;
  CreateBrush(Buf);
  StrCopy(Buf,'');
	GetPrivateProfileString('OM','PgmFile99','OMLOGO.BMP',Buf,SizeOf(Buf),'OM.INI');
	AutoMin :=Min(2,GetPrivateProfileInt('OM','AutoMin',0,'OM.INI'));
  Bitmap:= New(PTBMP,Init('xx'));
  if StrLen(Buf) <> 0 then
  	Bitmap^.LoadBitmapFile(buf);
  Pict := Bitmap^.BitmapHandle;
  Logo := LoadBitmap(HInstance,'OM_Logo');
  if Pict = 0 then
  	Pict := Logo;
  BNR[1]^.State := 1;
  GB2^.SelectionChanged(id_But21);
	GetPrivateProfileString('OM','StatDisp','M',Buf,SizeOf(Buf),'OM.INI');
  StatDisp := Buf[0];
end;

function TOMWindow.GetClassName:Pchar;
begin
	GetClassName := 'OMWindow';
end;

procedure TOMWindow.SetupWindow;
var
	SysMenu:hMenu;
  Indx:Word;
  CR:TRect;
  NewTop:Integer;
  LogFont:TLogFont;
  Msg:TMessage;
  PictMetrics:TBitmap;
begin
	TWindow.SetupWindow;
	SetClassWord(HWindow,GCW_HIcon,LoadIcon(HInstance,'OM_Icon'));
  SetClassWord(HWindow,GCW_HBrBackGround,BkgndBr);
  Sysmenu := GetSystemMenu(hWindow,false);
  AppendMenu(SysMenu,MF_Separator,0,nil);
  AppendMenu(Sysmenu,0,idm_About,'About...');
  GetClientRect(HWindow,CR);
  NewTop := CR.Bottom-Cr.Top-34;
  for Indx := 1  to 4 do
  	if BNR[Indx] <> nil then
    	begin
    	MoveWindow(BNR[Indx]^.HWindow,34*Pred(Indx),NewTop,34,34,False);
      MoveWindow(GB2^.HWindow,0,NewTOP,34*(Indx),34,False);
      end;
  GetObject(GetStockObject(System_Font),sizeof(LogFont),@LogFont);
  StrCopy(LogFont.lfFaceName,'Helv');
	LogFont.lfHeight := round(LogFont.lfHeight * 2 / 3);
  LogFont.lfWidth := 0;
  LogFont.lfPitchAndFamily := 0;
  Helv := CreateFontIndirect(LogFont);
  GetPictRect;
	SetStaticText;
  SetRBText;
  DragAcceptFiles(HWindow,TRUE);
end;

function GetHeapSpaces(Module:THandle):LongInt;far;external 'Kernel';

procedure TOMWindow.SetStaticText;
var
  Buf:Array[0..55] of Char;
  Mem :Record
  	GlobalFreeMem,User,GDI:LongInt;
  end;
  Res:Record
  	HRes,VRes,NColors:Integer;
  end;
  PageNumBuf:Array[0..25] of Char;
  lr:LongRec;
  Info:LongInt;
  nBitsPixel,nPlanes,nSizePalette:Integer;
  DC:HDc;
begin
if StatDisp = 'M' then
	begin
	LongInt(LR) := GetHeapSpaces(GetModuleHandle('User'));
  Mem.User := Round((LR.Lo  / LR.Hi)*100);
	LongInt(LR) := GetHeapSpaces(GetModuleHandle('GDI'));
  Mem.GDI := Round((LR.Lo / LR.Hi)*100) ;
	Mem.GlobalFreeMem := Round(GetFreeSpace(0) / 1024);
  wvsprintf(Buf,'GMem:%luK  User:%lu%%  GDI:%li%%',Mem);
  end
else
	begin
  Res.HRes := GetSystemMetrics(sm_CXScreen);
  Res.VRes := GetSystemMetrics(sm_CYScreen);
  DC := GetDC(HWindow);
  nPlanes := GetDeviceCaps(DC,Planes);
  nBitsPixel := GetDeviceCaps(DC,BitsPixel);
  nSizePalette := GetDeviceCaps(DC,SizePalette);
  if (RC_Palette AND GetDeviceCaps(DC,RASTERCAPS)) > 0 then
  	Res.NColors := nSizePalette
  else
 		Res.NColors := (nPlanes * nBitsPixel) shl 2 ;
  ReleaseDC(HWindow,DC);
  wvsprintf(Buf,'HRes:%i  VRes:%i  #Colors:%i',Res);
	end;
	St1^.SetFont(Helv);
  St1^.SetText(Buf);

  Str(PageNum,PageNumBuf);
  StrCat(StrCopy(Buf,'Page: '),PageNumBuf);
  SetWindowText(GB1^.HWindow,Buf);
end;

procedure TOMWindow.SetRBText;
var
	Offset:Integer;
	ChildWin:PRadioButton;
  Indx:Integer;
  Item:PPgmItem;
begin
	Offset := Pred(PageNum)*20;
	For Indx := Offset+1 to Offset+20 do
  	begin
    Item := Apps^.At(Indx);
    SetWindowText(RB[Indx-OffSet]^.HWindow,Item^.PgmName);
	  end;
end;

destructor TOMWindow.Done;
begin
	Dispose(Bitmap,Done);
	DeleteObject(Helv);
  Apps^.Done;
  if Logo <> 0 then DeleteObject(Logo);
	If HPrevInst = 0 then
		DeleteObject(BkgndBr);
  DragAcceptFiles(HWindow,FALSE);
  TWindow.Done;
end;

procedure TOMWindow.Paint(PaintDC:HDC;var PaintInfo:TPaintStruct);
const
	X1=190; Y1=48; X2=560; Y2=290;
var
	ThePen,OldPen:HPen;
  TheBrush,OldBrush:HBrush;
  MemDC:hDC;
begin
	TheBrush := GetStockObject(LtGray_Brush);
	ThePen := CreatePen(ps_Solid,1,$00000000);
  OldPen := SelectObject(PaintDC,ThePen);
  OldBrush := SelectObject(PaintDC,TheBrush);
  Rectangle(PaintDC,0,0,600,35);
  SelectObject(PaintDC,OldBrush);
  SelectObject(PaintDC,OldPen);
  DeleteObject(ThePen);
  DeleteObject(TheBrush);
  SRectangle(PaintDC,X1,Y1,X2,Y2,2,sr_Recessed);
	Bitmap^.Draw(PaintDC,PictRect,False);
end;

procedure	TOMWindow.WMDrawItem(var Msg:TMessage);
var
	PDIS : ^TDrawItemStruct;
begin
	PDIS := Pointer(Msg.lParam);
	case PDIS^.CtlType of
		odt_Button:
		case PDIS^.CtlID of
			id_But1..id_But10:Bn1[PDIS^.CtlID-200]^.DrawItem(Msg);
			id_But11..id_But15:Bn2[PDIS^.CtlID-210]^.DrawItem(Msg);
			id_But21..id_But24:BnR[PDIS^.CtlID-220]^.DrawItem(Msg);
		end;
	end;
end;

procedure TOMWindow.IDBut11(var Msg:TMessage);
var
	Item:PPgmItem;
begin
	Item := Apps^.At(91);
	if (Item^.Dir <> NIL) then
  		SetCurdir(Item^.Dir);
  if (Item^.PgmFile <> nil) then
  	WinExec(Item^.PgmFile,sw_Normal)
  else
		WinExec('command.com',sw_Normal);
end;

procedure TOMWindow.IDBut12(var Msg:TMessage);
begin
	Runit;
end;

procedure TOMWindow.IDBut13(var Msg:TMessage);
var
	Dlg3:POMDlg3;
begin
	Dlg3 := New(POMDlg3,Init(@Self,'Om_Dlg3'));
	Application^.ExecDialog(Dlg3);
end;

procedure TOMWindow.IDBut14(var Msg:TMessage);
begin
	SetStaticText;
end;

procedure TOMWindow.IDBut15(var Msg:TMessage);
begin
  ExitWindows(0,0);
end;

procedure TOMWindow.DefChildProc(var Msg:TMessage);
var
	ID:Integer;
begin
  case Msg.WParam of
  	id_But1..id_But10:
      WinExecc(Msg);
    Succ(id_GB1)..id_GB1+20:
      WinExecc(Msg);
    id_But21..id_But24:
			begin
			PageNum := Msg.wParam-220;
  		SetRBText;
  		SetStaticText;
			end;
    else
    	TWindow.DefChildProc(Msg);
    end;
end;

procedure TOMWindow.WinExecc(var Msg:TMessage);
var
	Indx:Integer;
	Item:PPgmItem;
  Buf:Array[0..100] of Char;
  Errval:Integer;
  nCmdShow,CmdShow:Integer;
begin
	Indx := CtrlToIndx(Msg.wParam);
	Item := Apps^.At(Indx);
  if (Item^.PgmFile = NIL) then
  	begin
  	if (Msg.wParam > id_Gb1) then
  		RB[Msg.WParam-id_GB1]^.Toggle;
    TWindow.DefChildProc(Msg);
    Exit;
    end;
  StrCopy(Buf,Item^.PgmFile);
  if (Item^.Params <> NIL) then
      	StrCat(StrCat(Buf,' '),Item^.Params);
  if (Item^.Cmdshow <> NIL) then
  	case Item^.CmdShow[0] of
    	'N','n':Cmdshow := sw_Normal;
      'M','m':CmdShow := sw_Maximize;
      'I','i':CmdShow := sw_Minimize;
    	else
      	CmdShow := sw_Normal;
    end
  else
  	CmdShow := sw_Normal;
	if (Item^.Dir <> NIL) then
  	SetCurdir(Item^.Dir);
  WinExec(Buf,CmdShow);
  if Msg.wParam > id_GB1 then
		RB[Msg.WParam-id_GB1]^.Toggle;
  If AutoMin = 1 then
  	ShowWindow(HWindow,sw_Minimize);
end;

procedure	TOMWindow.WMSysCommand(var Msg:TMessage);
begin
	case Msg.Wparam of
		idm_About:
 			application^.ExecDialog(New(POMAboutDlg,Init(@Self,'OM_About',Logo,BkgndBr)));
   	else
   		DefWndProc(Msg);
   	end;
end;

procedure TOMWindow.SetItemValues(PgmItem:ItemRec);
begin
	Apps^.ItemSet(PgmItem);
  SetRBText;
end;

procedure TOMWindow.WMCTLCOLOR(var Msg: TMessage);
begin
  case Msg.LParamHi of
    ctlcolor_Btn:
      begin
      SetBkMode(Msg.WParam, Transparent);
      Msg.Result := GetStockObject(ltGray_Brush);
      end;
  else
    DefWndProc(Msg);
  end;
end;

procedure TOMWindow.Runit;
const
  szFilter:Array[0..8] of Char ='*.*'#0'*.*'#0#0;
var
  Path,Name,Ext,OldDir:Array[0..fsPathName] of Char;
	szDirName:Array[0..256] of Char;
  szFile,szFileTitle:Array[0..256] of Char;
  OFN:TOpenFileName;
begin
	StrCopy(szFile,'');
  OFN.lStructSize := sizeof(TOpenFileName);
  OFN.hWndOwner := HWindow;
  OFN.lpStrFilter := @szFilter;
  OFN.lpStrCustomFilter := nil;
  OFN.nMaxCustFilter := 0;
  OFN.nFilterIndex := LongInt(1);
  OFN.lpStrFile := szFile;
  OFN.nMaxFile := sizeof(szFile);
  OFN.lpstrfileTitle := szFileTitle;
  OFN.nMaxFileTitle := sizeof(szFileTitle);
  OFN.lpstrInitialDir := NIL;
  OFN.lpStrTitle := 'Run A Program';
  OFN.flags := 0;
  OFN.nFileOffset := 0;
  OFN.nFileExtension := 0;
  OFN.lpstrDefext := nil;
  If GetOpenFileName(OFN) then
  	begin
    filesplit(szFile,Path,Name,Ext);
    SetCurDir(Path);
  	WinExec(Name,sw_Normal);
    SetCurdir(OldDir);
  	If AutoMin = 1 then
  		ShowWindow(HWindow,sw_Minimize);
    end;
end;

procedure TOMWindow.UMDropFiles(var Msg:TMessage);
var
	FileNamePtr:PChar;
  CtrlID:Integer;
	Buf1:Array[0..30] of Char;
  Indx:Integer;
	PgmItem:ItemRec;
  Dir,Name,Ext:Array[0..fsPathName] of Char;
begin
	FileNamePtr := Pointer(Msg.lParam);
  FileSplit(FileNamePtr,Dir,Name,Ext);
  AnsiLower(Name);
  Name[0] := UpCase(Name[0]);
	StrCopy(PgmItem.PgmName,Name);
  StrCopy(PgmItem.PgmFile,FileNamePtr);
  CtrlID :=Msg.wParam;
  If CtrlID = id_Pict then
  	Indx := id_BMP
  else
		Indx := CtrlToIndx(Msg.wParam);
  Str(Indx:2,PgmItem.ItemNum);
  StrCopy(PgmItem.Dir,'');
  StrCopy(PgmItem.Params,'');
  StrCopy(PgmItem.CmdShow,'N');
  SetItemValues(PgmItem);
end;

procedure TOMWindow.UMRButtonDown(var Msg:TMessage);
begin
  if Msg.wParam = id_St1 then
  	SetStatProp(Msg)
  else if (Msg.wParam > id_But11) and (Msg.wParam < Succ(id_But15)) then
  else if (Msg.wParam = id_RGB) then
  	SetRGBProp(Msg)
  else if (Msg.wParam = id_Pict) then
  	SetBMPProp(Msg)
  else if (Msg.wParam > id_GB2) and (Msg.wParam < id_GB1+100) then
  	SetButProp(Msg)
  else
  	DefWndProc(Msg);
end;

function TOMWindow.CtrlToIndx(ID:Integer):Integer;
begin
	if ID > id_GB1 then
		CtrlToIndx := ID - id_GB1 + (20*Pred(PageNum))
  else
		CtrlToIndx := ID - id_GB2 + 80;
end;

procedure TOMWindow.WMRButtonDown(var Msg:TMessage);
var
	MousePt:TPoint;
begin
	MousePt := MakePoint(Msg.lParam);
 	if PtInRect(PictRect,MousePt)  then
  	SendMessage(HWindow,wm_User+wm_RButtonDown,id_Pict,Msg.lParam)
  else
  	SendMessage(HWindow,wm_User+wm_RButtonDown,id_RGB,Msg.lParam);
	DefWndProc(Msg);
end;

procedure TOMWindow.SetStatProp(var Msg:TMessage);
begin
	if StatDisp = 'M' then
    StatDisp := 'R'
  else
		StatDisp := 'M';
  WritePrivateProfileString('OM','StatDisp',@StatDisp,'OM.INI');
  SetStaticText;
end;

procedure TOMWindow.SetButProp(var Msg:TMessage);
var
  Dlg2:POMDlg2;
begin
  FillChar(D2TfB,sizeof(D2TfB),$0);
	Dlg2 := New(POMDlg2,Init(@Self,'Om_Dlg2'));
  Str(CtrlToIndx(Msg.wParam),D2TfB.ItemNum);
  Dlg2^.TransferBuffer := @D2TfB;
  Apps^.ItemGet(D2TfB);
	if StrLen(D2TfB.Cmdshow) = 0 then
  	StrCopy(D2TfB.Cmdshow,'N');
  if (Application^.ExecDialog(Dlg2) = 1) then
  	begin
    SetItemValues(D2TfB);
  	if (Msg.wParam > id_But0) and (Msg.wParam < id_But11) then
  		BN1[Msg.wParam - id_But0]^.ChangeBMP(D2TfB.PgmFile);
  	end;
end;

procedure TOMWindow.SetBMPProp(var Msg:TMessage);
var
  Dlg2:POMDlg2;
begin
  FillChar(D2TfB,sizeof(D2TfB),$0);
	Dlg2 := New(POMDlg2,Init(@Self,'Om_Dlg2'));
  StrCopy(D2TfB.ItemNum,'99');
  Dlg2^.TransferBuffer := @D2TfB;
  Apps^.ItemGet(D2TfB);
  StrCopy(D2TfB.Cmdshow,'N');
  if (Application^.ExecDialog(Dlg2) = 1) then
  	begin
    SetItemValues(D2TfB);
  	if  (StrLen(D2TfB.PgmFile) <> 0) then
  		LoadBMP(D2TfB.PgmFile);
  	end;
end;

procedure TOMWindow.SetRGBProp(var Msg:TMessage);
var
	Chsclr:TChooseColor;
  Color:LongInt;
  ColorArray:Array[0..15] of LongInt;
  Indx:Integer;
  BkColor:Array[0..12] of Char;
  Buf:Array[0..15] of Char;
  Errornum:Integer;
begin
  	begin
  	for Indx := 0 to 15 do ColorArray[Indx] := LongInt(RGB(255,255,255));
		GetPrivateProfileString('OM','BkgndColor','12632256',Buf,SizeOf(Buf),'OM.INI');
    Val(Buf,Color,Errornum);
  	ChsClr.lStructsize:= sizeof(TChooseColor);
  	ChsClr.hWndOwner := HWindow;
  	ChsClr.hInstance := HInstance;
  	ChsClr.rgbResult := Color;
   	ChsClr.lpcustcolors := pLongInt(@ColorArray);
  	ChsClr.lcustdata := 0;
  	ChsClr.Flags :=  cc_RGBInit;
  	ChsClr.lptemplateName := PChar(nil);
		if Choosecolor(ChsClr) then
    	begin
    	Str(ChsClr.rgbResult,BkColor);
    	WritePrivateProfileString('OM','BkgndColor',BkColor,'OM.INI');
      CreateBrush(BkColor);
      end;
    end;
end;

procedure TOMWindow.WMDropFiles(var Msg:TMessage);
var
	DropItem:hDrop;
  FileNameBuf:Array[0..fsPathName] of Char;
  GFileName:PChar;
  Loc:TPoint;
begin
	DropItem := Msg.wParam;
  DragQueryFile(DropItem,0,FileNameBuf,sizeof(FileNameBuf));
  DragQueryPoint(DropItem,Loc);
  DragFinish(DropItem);
 	if PtInRect(PictRect,Loc) then
   	begin
  	GFileName :=StrNew(FileNameBuf);
  	SendMessage(HWindow,wm_User+wm_DropFiles,id_Pict,LongInt(GFileName));
    StrDispose(GFileName);
    LoadBMP(FileNameBuf);
  	end;
end;

procedure TOMWindow.LoadBMP(BMPName:PChar);
begin
	Dispose(BitMap,Done);
  Bitmap:= New(PTBMP,Init('xx'));
  Bitmap^.LoadBitmapFile(BMPName);
  Pict := Bitmap^.BitmapHandle;
  GetPictRect;
  InvalidateRect(HWindow,nil,True);
  UpdateWindow(HWindow);
end;

procedure TOMWindow.GetPictRect;
var
	CR:TRect;
  PictMetrics:TBitmap;
begin
	GetClientRect(HWindow,CR);
  GetObject(Pict,SizeOf(PictMetrics),@PictMetrics);
  PictRect.Left := Max((190 - PictMetrics.bmWidth) div 2 , 5);
  PictRect.Top := Max((CR.Bottom-CR.Top-105 - PictMetrics.bmHeight) div 2 , 0)+75;
  PictRect.Right := Min(PictRect.Left +PictMetrics.bmWidth,185);
  PictRect.Bottom := Min(PictRect.Top +PictMetrics.bmHeight,CR.Bottom-40);
end;

procedure TOMWindow.CreateBrush(BkgndColor:PChar);
var
	DC,MemDC:HDC;
  NewBmp,Bmp,OldBmp:HBitmap;
  NewBrush,OldBrush,MonoBrush:HBrush;
  nBkgndColor:TColorRef;
  ErrCode:Integer;
begin
	if BkgndBr > 0 then
  	DeleteObject(BkgndBr);
  Val(BkgndColor,nBkgndColor,ErrCode);
  Bmp :=LoadBitmap(HInstance,'OM_Br');
  MonoBrush :=CreatePatternBrush(Bmp);
	DC := GetDC(HWindow);
  NewBMP := CreateCompatibleBitmap(DC,8,8);
  MemDC := CreateCompatibleDC(DC);
  SetTextColor(MemDC,nBkgndColor);
  OldBrush := SelectObject(MemDC,MonoBrush);
  OldBmp := SelectObject(MemDC,NewBmp);
	PatBlt(MemDC,0,0,8,8,PatCopy); 
  SelectObject(MemDC,OldBmp);
  SelectObject(MemDC,OldBrush);
  DeleteObject(MonoBrush);
  BkgndBr := CreatePatternBrush(NewBMP);
  DeleteObject(Bmp);
  DeleteObject(NewBmp);
  DeleteDC(MemDC);
  ReleaseDC(HWindow,DC);
  SetClassWord(HWindow,GCW_HBrBackGround,BkgndBr);
  InvalidateRect(HWindow,nil,True);
end;

procedure TOMWindow.WMNCRButtonDown(Msg:TMessage);
var
	TheDialog:PDialog;
	RadioRec :Record
  	RB1,RB2:Bool;
  end;
  RBut1,RBut2:PRadioButton;
begin
	TheDialog :=New(PDialog,Init(@Self,'OM_DLG1'));
  New(RBut1,InitResource(TheDialog,id_D1RB1));
  New(RBut2,InitResource(TheDialog,id_D1RB2));
  RadioRec.RB1 := False;
  RadioRec.RB2 := True;
  TheDialog^.TransferBuffer := @RadioRec;
  Application^.ExecDialog(TheDialog);
  If RadioRec.RB1 then
  	begin
    AutoMin := 1;
    WritePrivateProfileString('OM','AutoMin','1','OM.INI')
    end
  else
  	begin
    AutoMin := 0;
    WritePrivateProfileString('OM','AutoMin','0','OM.INI');
    end;
end;
{***********************  TOMDlg2  ******************************}
constructor TOMDlg2.Init(AParent:PWindowsObject;AName:PChar);
begin
	TDialog.Init(AParent,AName);
  New(EC1,InitResource(@Self,id_D2Ec1,70));
  New(EC2,InitResource(@Self,id_D2Ec2,70));
  New(EC3,InitResource(@Self,id_D2Ec3,70));
  New(EC4,InitResource(@Self,id_D2Ec4,70));
  New(EC5,InitResource(@Self,id_D2Ec5,70));
  New(EC6,InitResource(@Self,id_D2Ec6,70));
end;

procedure TOMDlg2.IDD2OK(var Msg:TMessage);
begin
	TransferData(tf_GetData);
  EndDlg(1);
end;

procedure TOMDlg2.IDBrowse(var Msg:TMessage);
const
  szFilter:Array[0..8] of Char ='*.*'#0'*.*'#0#0;
var
  pBuf:PChar;
  Dir,Name,Ext:Array[0..fsPathName] of Char;
	szDirName:Array[0..256] of Char;
  szFile,szFileTitle:Array[0..256] of Char;
  OFN:TOpenFileName;
  Ptr:PChar;
begin
	Ptr := @szFilter;
	StrCopy(szFile,'');
  OFN.lStructSize := sizeof(TOpenFileName);
  OFN.hWndOwner := HWindow;
  OFN.lpStrFilter := Ptr;
  OFN.lpStrCustomFilter := nil;
  OFN.nMaxCustFilter := 0;
  OFN.nFilterIndex := LongInt(1);
  OFN.lpStrFile := szFile;
  OFN.nMaxFile := sizeof(szFile);
  OFN.lpstrfileTitle := szFileTitle;
  OFN.nMaxFileTitle := sizeof(szFileTitle);
  OFN.lpstrInitialDir := NIL;
  OFN.lpStrTitle := 'Select Program';
  OFN.flags := OFN_Pathmustexist or OFN_Filemustexist;
  OFN.nFileOffset := 0;
  OFN.nFileExtension := 0;
  OFN.lpstrDefext := nil;
  If GetOpenFileName(OFN) then
  	begin
    FileSplit(szFile,Dir,Name,Ext);
    StrLower(Name);
    Name[0] := UpCase(Name[0]);
    pBuf := Name;
    EC2^.SetText(pBuf);
    pBuf := szFile;
  	EC3^.SetText(pBuf);
    SetFocus(GetItemHandle(id_D2Ec4));
    end;
end;
{***********************  TOMDlg3  ******************************}
procedure TOMDlg3.SetupWindow;
var
ArgList : record
	StrPtr : PChar;
  Free:PChar;
  Size:LongInt;
  PctFree:LongInt;
end;
	szFree:Array[0..5] of Char;
  rFree:Real;
  szDr:Array[0..2] of Char;
  szOutput : Array[0..80] of Char;
  hListBox:hWnd;
begin
	TDialog.SetupWindow;
	hListBox :=GetItemHandle(Id_D3Lb1);
	SendMessage(hListBox,wm_SetFont,GetStockObject(OEM_Fixed_Font),0);
	DosError := 0; StrCopy(szOutput,'');
  WVSPrintf(szOutput,'Dr  MBf  MBt %%Free',ArgList);
  SendMessage(hListBox,lb_AddString,0,LongInt(@szOutput));

  StrCopy(szDr,'C:');
  while DosError = 0 do
   	begin
    SetCurDir(szDr);
      if DosError = 0 then
      	begin
        rFree := (DiskFree(0) / 1024 / 1024);
        Str(rFree:4:1,szFree);
        ArgList.Free := @szFree;
        ArgList.Size := Round( DiskSize(0) / 1024 /1024) ;
        ArgList.PctFree := Round(DiskFree(0) / (DiskSize(0) / 100 )) ;
        ArgList.StrPtr := @szDr;
        WVSPrintf(szOutput,'%s %s  %3li  %3li',ArgList);
        SendMessage(hListBox,lb_AddString,0,LongInt(@szOutput));
        end;
		Inc(szDr[0]);
    end;
end;
{********************  TOMAbout     **************************}
constructor TOMAboutDlg.Init(AParent:PWindowsObject;
			AName:PChar;ALogo:HBitmap;ABrush:HBrush);
begin
	TDialog.Init(AParent,AName);
  Logo := ALogo;
  Brush := ABrush;
end;

procedure TOMAboutDlg.WMCTLCOLOR(var Msg: TMessage);
const
  as_AboutSt1 =   126;  {about dlg static text   }
  as_AboutSt2 =   128;  {about dlg static blank static to draw upon}
var
	HSt1,HSt2:HWnd;
  MemDC:hDC;
  OldBitmap:HBitmap;
  CR:TRect;
  X,Y,W,H:Integer;
  LogoMetrics:TBitmap;
begin
  case Msg.LParamHi of
    ctlColor_Static:
      begin
        If (as_AboutSt1 = GetDlgCtrlID(Msg.lParamLo)) then
        	SetTextColor(Msg.WParam, RGB(0,0,255))
        else  if (as_AboutSt2 = GetDlgCtrlID(Msg.lParamLo)) then
        	begin
          MemDC := CreateCompatibleDC(Msg.WParam);
          OldBitmap := SelectObject(MemDC,Logo);
          GetClientRect(Msg.lParamLo,CR);
          W:= CR.Right-CR.Left;H:= CR.Bottom-CR.Top;
          GetObject(Logo,SizeOf(LogoMetrics),@LogoMetrics);
          X := Max((W - LogoMetrics.bmWidth) div 2 , 0);
          Y := Max((H - LogoMetrics.bmHeight) div 2 , 0);
          BitBlt(Msg.WParam,X,Y,W,H,MemDc,0,0,SrcCopy);
          SelectObject(MemDC,OldBitmap);
          DeleteDC(MemDc);
          end;
        SetBkMode(Msg.WParam, transparent);
        Msg.Result := GetStockObject(Null_Brush);
      end;
    ctlcolor_Dlg:
      begin
        SetBkMode(Msg.WParam, Transparent);
        Msg.Result := GetStockObject(ltGray_Brush);
      end;
  else
    DefWndProc(Msg);
  end;
end;
{************************  TPrgItem    *****************************}
constructor TPgmItem.Init(NewPgmName,NewPgmFile,NewDir,NewParams:PChar;NewCmdShow:Pchar);
begin
	PgmName := StrNew(NewPgmName);
  PgmFile := StrNew(NewPgmFile);
  Dir := StrNew(NewDir);
  Params := StrNew(NewParams);
  CmdShow := StrNew(NewCmdShow);
end;

destructor TPgmItem.Done;
begin
	StrDispose(PgmName);
  StrDispose(PgmFile);
  StrDispose(Dir);
  StrDispose(Params);
  StrDispose(CmdShow);
end;
{************************  TOMCol    *****************************}
constructor TOMCol.Init(ALimit,ADelta:Integer);
begin
	TheItems := New(PCollection,Init(ALimit,ADelta));
end;

destructor TOMCol.Done;
begin
	Dispose(TheItems,Done);
end;

function TOMCol.At(Indx:Integer):PPgmItem;
begin
	At := TheItems^.At(Indx);
end;

procedure TOMCol.ReadItems(Start,Finish:Integer);
var
	Buf1:Array[0..30] of Char;
  Indx:Integer;
  IndxStr:Array[0..5] of Char;
  Found:Boolean;
  Key:Array[0..20] of Char;
  PgmName,PgmFile,Dir,Params:Array[0..50] of Char;
  CmdShow:Array[0..5] of Char;
begin
  for Indx := Start to Finish do
  	begin
    StrCopy(PgmFile,'');Strcopy(Dir,'');StrCopy(Params,'');StrCopy(CmdShow,'');
    Str(Indx,IndxStr);
    StrCat(StrCopy(Key,'PgmName'),IndxStr);
		GetPrivateProfileString('OM',Key,'',PgmName,SizeOf(PgmName),'OM.INI');
    if PgmName[0] <> #0 then
    	begin
    	StrCat(StrCopy(Key,'PgmFile'),IndxStr);
			GetPrivateProfileString('OM',Key,'',PgmFile,SizeOf(PgmFile),'OM.INI');
    	StrCat(StrCopy(Key,'Dir'),IndxStr);
			GetPrivateProfileString('OM',Key,'',Dir,SizeOf(dir),'OM.INI');
    	StrCat(StrCopy(Key,'Params'),IndxStr);
			GetPrivateProfileString('OM',Key,'',Params,SizeOf(Params),'OM.INI');
    	StrCat(StrCopy(Key,'CmdShow'),IndxStr);
			GetPrivateProfileString('OM',Key,'',Cmdshow,SizeOf(CmdShow),'OM.INI');
    	end;
    TheItems^.AtInsert(Indx,New(PPgmItem,Init(PgmName,PgmFile,Dir,Params,Cmdshow)));
    end;
end;

procedure TOMCol.ItemGet(var PgmItem:ItemRec);
var
  Indx:Integer;
  IndxStr:Array[0..5] of Char;
  ErrCode:Integer;
  TheItem:PPgmItem;
begin
	Val(PgmItem.ItemNum,Indx,ErrCode);
  if (ErrCode <> 0) or (NOT(IsValidIndx(Indx))) then
  	Exit;
  begin
  TheItem := TheItems^.At(Indx);
  If TheItem^.PgmName <> nil then
  	StrCopy(PgmItem.PgmName,TheItem^.PgmName);
  If TheItem^.PgmFile <> nil then
  	StrCopy(PgmItem.PgmFile,TheItem^.PgmFile);
  If TheItem^.Dir <> nil then
  	StrCopy(PgmItem.Dir,TheItem^.Dir);
  If TheItem^.Params <> nil then
  	StrCopy(PgmItem.Params,TheItem^.Params);
  If TheItem^.Cmdshow <> nil then
  	StrCopy(PgmItem.CmdShow,TheItem^.Cmdshow);
	end;
end;

procedure TOMCol.ItemSet(PgmItem:ItemRec);
var
	Buf1:Array[0..30] of Char;
  Indx:Integer;
  IndxStr:Array[0..5] of Char;
  Found:Boolean;
  Key:Array[0..20] of Char;
  Errval:Integer;
begin
	Val(PgmItem.ItemNum,Indx,Errval);
  If IsValidIndx(Indx) then
  	begin
  	StrCopy(IndxStr,PgmItem.ItemNum) ;
    StrCat(StrCopy(Key,'PgmName'),IndxStr);
		WritePrivateProfileString('OM',Key,PgmItem.PgmName,'OM.INI');
    StrCat(StrCopy(Key,'PgmFile'),IndxStr);
		WritePrivateProfileString('OM',Key,PgmItem.PgmFile,'OM.INI');
    StrCat(StrCopy(Key,'Dir'),IndxStr);
		WritePrivateProfileString('OM',Key,PgmItem.Dir,'OM.INI');
    StrCat(StrCopy(Key,'Params'),IndxStr);
		WritePrivateProfileString('OM',Key,PgmItem.Params,'OM.INI');
    StrCat(StrCopy(Key,'CmdShow'),IndxStr);
		WritePrivateProfileString('OM',Key,PgmItem.CmdShow,'OM.INI');
    TheItems^.AtFree(Indx);
    TheItems^.AtInsert(Indx,New(PPgmItem,Init(PgmItem.PgmName,PgmItem.PgmFile,
    	PgmItem.Dir,PgmItem.Params,PgmItem.Cmdshow)));
    end;
end;

function TOMCol.GetCount:Integer;
begin
	GetCount := TheItems^.Count;
end;

function TOMCol.IsValidIndx(Indx:Integer):Boolean;
begin
	IsValidIndx :=((Indx >= 0) and (Indx < TheItems^.Count));
end;
{************************  TOMRButton    *****************************}
procedure TOMRButton.WMRButtonDown(var Msg:TMessage);
begin
  SendMessage(Parent^.HWindow,wm_User+wm_RButtonDown,GetID,0);
end;
{***************************************************************************}
procedure TOMGroupBox.SetupWindow;
begin
	TGroupBox.SetupWindow;
  DragAcceptFiles(HWindow,TRUE);
end;

function TOMGroupBox.CanClose:Boolean;
begin
	DragAcceptFiles(HWindow,FALSE);
	CanClose := TGroupBox.CanClose;
end;

procedure TOMGroupBox.WMDropFiles(var Msg:TMessage);
var
	DropItem:hDrop;
  FileNameBuf:Array[0..fsPathName] of Char;
  NewIcon:hIcon;
  MemDC,DC:HDC;
  OldBmp,NewBmp:HBitmap;
  OldBrush:HBrush;
  GFileName:PChar;
  CtrlID:Integer;
  Loc,SLoc:TPoint;
  ChildWin:HWnd;
begin
	DropItem := Msg.wParam;
  DragQueryFile(DropItem,0,FileNameBuf,sizeof(FileNameBuf));
  GFileName :=StrNew(FileNameBuf);
  DragQueryPoint(DropItem,Loc);
  DragFinish(DropItem);
  SLoc := Loc;
  ClienttoScreen(HWindow,SLoc);
  ChildWin := WindowFromPoint(SLoc);
  CtrlID := GetDlgCtrlID(ChildWin);
  SendMessage(Parent^.HWindow,wm_User+wm_DropFiles,CtrlID,LongInt(GFileName));
  StrDispose(GFileName);
end;
{************************  TOMStatic    *****************************}
procedure TOMStatic.WMRButtonDown(var Msg:TMessage);
begin
  SendMessage(Parent^.HWindow,wm_User+wm_RButtonDown,GetID,0);
end;
{***********************  MainLine  ********************************}
var
	OMApp : TOMApplication;
begin
	OMApp.Init('OttoMenu');
  OMApp.Redraw;
	OMApp.Run;
	OMApp.Done;
end.
