//	Test of Btrieve under windows
//	Adapted from Borland C++ sample program WHELLO.CPP

#define  STRICT
#include <windows.h>
#include <stdlib.h>
#include <string.h>

#include <strstrea.h>

#include "BTMNGER.HPP"
#include "btdef.hpp"
#include "btkey.hpp"

/////////////////////////// Btrieve test functions ////////////////////////

void GetBTVersion(char * Str)
    {
    BT_Manager BTRIEVE;

    int Ver,Rev;
    char Environ;
    int stat = BTRIEVE.Version(Ver,Rev,Environ);

	ostrstream os(Str,128);
    if( !stat )
		os << "Btrieve Ver " << Ver << "." << Rev << Environ << ends;
    else
		os << "Error " << stat << ends;
	}

//  RECORD FORMAT
class MyRec
    {
    public:
	int number;		// key 0
        char name[32];
    };

void TestBTCreate( char * Str )  //// Create Btrieve file ////
    {
    BT_Def BTFile(sizeof(MyRec),0);
    // add one key segment
    BTFile.AddFinalKeySegment(1,2,0,BTYPE_INTEGER);

    int stat = BTFile.CreateBtrieve("TEST.DB");

    ostrstream str(Str,128);

    if( !stat )
		str << "Success! Created Btrieve file TEST.DB!" << ends;
    else
		str << "Create failed: Code " << stat << ends;
	}

void TestBTAdd( char * Str )  //// Add a few records ////
    {
    BT_DataSet DSet("TEST.DB");
    BT_Key *K = DSet.GetKey(0);

    if( K )
	{
	MyRec Rec;
	int stat=0;

	for(int numRecs=1; !stat && numRecs<6; numRecs++)
	    {
	    ostrstream nm(Rec.name,31);
	    Rec.number = numRecs;
	    nm << "Record No. " << numRecs << ends;

        stat = K->Insert(&Rec);
	    }

	if(stat)
		strcpy(Str,"Insert failed!");
	else
		strcpy(Str,"Record insertion complete!");

	}
	else
		strcpy(Str,"Could not obtain key!");

    } /**/

void TestBTFind( char * Str )	 //// Search for record 3 ////
    {
    int searchVal = 3;
    BT_DataSet DSet("TEST.DB");
    BT_Key *K = DSet.GetKey(0);
    if( K )
	{
	MyRec Rec;
	int stat = K->GetEqual(&searchVal,&Rec);

	ostrstream str(Str,128);
	if( !stat )
	    str << "Found: " << Rec.name << ends;
	else
	    str << "Search Failed,Code " << stat << ends;
	}
    else
		strcpy(Str,"Could not obtain key for search!");

    } /**/

LRESULT CALLBACK _export WndProc( HWND hWnd, UINT iMessage,
                                 WPARAM wParam, LPARAM lParam );

class Main
{
public:
	static HINSTANCE hInstance;
	static HINSTANCE hPrevInstance;
	static int nCmdShow;
	static int MessageLoop( void );
};

class Window
{
protected:
    HWND hWnd;
public:
	HWND GetHandle( void ) { return hWnd; }

    BOOL Show( int nCmdShow ) { return ShowWindow( hWnd, nCmdShow ); }
    void Update( void ) { UpdateWindow( hWnd ); }

    virtual long WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam ) = 0;
};

class MainWindow : public Window
{
private:
    static char szClassName[14];
public:
	static void Register( void )
    {
		WNDCLASS wndclass;

        wndclass.style         = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc   = ::WndProc;
        wndclass.cbClsExtra    = 0;
		wndclass.cbWndExtra    = sizeof( MainWindow * );
        wndclass.hInstance     = Main::hInstance;
        wndclass.hIcon         = LoadIcon( Main::hInstance, "whello" );
        wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
        wndclass.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH );
        wndclass.lpszMenuName  = NULL;
        wndclass.lpszClassName = szClassName;

        if ( ! RegisterClass( &wndclass ) )
            exit( FALSE );
    }

	MainWindow( void )
    {
		hWnd = CreateWindow( szClassName,
            szClassName,
            WS_OVERLAPPEDWINDOW,
            CW_USEDEFAULT,
            0,
            CW_USEDEFAULT,
            0,
            NULL,
            NULL,
            Main::hInstance,
            (LPSTR) this );
        if ( ! hWnd )
            exit( FALSE );

        Show( Main::nCmdShow );
        Update();
    }
    long WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam );  

	void Paint( void );

};

HINSTANCE Main::hInstance = 0;
HINSTANCE Main::hPrevInstance = 0;
int Main::nCmdShow = 0;

int Main::MessageLoop( void )
{
    MSG msg;

    while( GetMessage( &msg, NULL, 0, 0 ) )
    {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
	}
    return msg.wParam;
}

char MainWindow::szClassName[] = "Btrieve Test!";

void MainWindow::Paint( void )
{
    PAINTSTRUCT ps;
    RECT rect;

    BeginPaint( hWnd, &ps );
    GetClientRect( hWnd, (LPRECT) &rect );
	SetTextAlign( ps.hdc, TA_LEFT );

	char buff[128];

	////////// Call Btrieve test functions ////////////
	GetBTVersion(buff);
	TextOut( ps.hdc, 0, 50, buff, strlen(buff) );

	TestBTCreate(buff);
	TextOut( ps.hdc, 0, 65, buff, strlen(buff) );

	TestBTAdd(buff);
	TextOut( ps.hdc, 0, 80, buff, strlen(buff) );

	TestBTFind(buff);
	TextOut( ps.hdc, 0, 95, buff, strlen(buff) );

    EndPaint( hWnd, &ps );
}


long MainWindow::WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam )
{
    switch (iMessage)
    {
        case WM_CREATE:
	    break;
        case WM_PAINT:
            Paint();
            break;
        case WM_DESTROY:
            PostQuitMessage( 0 );
            break;
        default:
            return DefWindowProc( hWnd, iMessage, wParam, lParam );
    }
    return 0;
}

// If data pointers are near pointers
#if defined(__SMALL__) || defined(__MEDIUM__)
inline Window *GetPointer( HWND hWnd )
{
    return (Window *) GetWindowWord( hWnd, 0 );
}
inline void SetPointer( HWND hWnd, Window *pWindow )
{
    SetWindowWord( hWnd, 0, (WORD) pWindow );
}

// else pointers are far
#elif defined(__LARGE__) || defined(__COMPACT__)
inline Window *GetPointer( HWND hWnd )
{
    return (Window *) GetWindowLong( hWnd, 0 );
}
inline void SetPointer( HWND hWnd, Window *pWindow )
{
    SetWindowLong( hWnd, 0, (LONG) pWindow );
}

#else
    #error Choose another memory model!
#endif

LRESULT  CALLBACK _export WndProc( HWND hWnd, UINT iMessage, WPARAM wParam,
                                 LPARAM lParam )
{
	Window *pWindow = GetPointer( hWnd );

	if ( pWindow == 0 )
    {
        if ( iMessage == WM_CREATE )
        {
            LPCREATESTRUCT lpcs;

            lpcs = (LPCREATESTRUCT) lParam;
            pWindow = (Window *) lpcs->lpCreateParams;
			SetPointer( hWnd, pWindow );

		return pWindow->WndProc( iMessage, wParam, lParam );
        }
        else
            return DefWindowProc( hWnd, iMessage, wParam, lParam );
    }
    else
        return pWindow->WndProc( iMessage, wParam, lParam );
}

#pragma argsused
#pragma option -w-aus

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine,
                    int nCmdShow )
{
    Main::hInstance = hInstance;
    Main::hPrevInstance = hPrevInstance;
    Main::nCmdShow = nCmdShow;

	if ( ! Main::hPrevInstance ) {
        MainWindow::Register();
    }

    MainWindow MainWnd;

    return Main::MessageLoop();
}
