/**********************************************************************/
/*                  Dlgall.cpp by Bob Bourbonnais                     */
/*              released to the public domain 1/10/92                 */
/*     This program demonstrates using dialog boxs for everything.    */
/*       It is a summation of the other owl dialog box examples.      */
/*           This example has a dialog box as the main window.        */
/*     The main window dialog box can activate other dialog boxes     */
/*               either from the menu or from buttons.                */
/*      It can activate Modal, System Modal, Message Box, non-modal   */
/*       with parent and non-modal without parent dialog boxes.       */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "dlgall.h"

class TDialogAllDialog : public TDialog    // Dialog class to add
  {					 // processing for menu and
  public:				 // button selections
    TDialogAllDialog(LPSTR lpName)         // constructor calls
      :TDialog(NULL,lpName) {};		 // base class constructor
    virtual void HandleModalMenu(RTMessage Msg)      // menu handler
      = [CM_FIRST + IDM_MODAL_DIALOG];
    virtual void HandleMenuOK(RTMessage Msg)
      = [CM_FIRST + IDM_MB_OK];
    virtual void HandleSysModalMenu(RTMessage Msg)
      = [CM_FIRST + IDM_SYS_MODAL];
    virtual void HandleNonModalMenu(RTMessage Msg)
      = [CM_FIRST + IDM_NON_MODAL_DIALOG];
    virtual void HandleNoParentMenu(RTMessage Msg)
      = [CM_FIRST + IDM_NO_PARENT_NON_MODAL];

    virtual void HandleModalButton(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_MODAL_DIALOG];
    virtual void HandleButtonOK(RTMessage Msg)
      = [ID_FIRST + IDB_MB_OK];
    virtual void HandleSysModalButton(RTMessage Msg)
      = [ID_FIRST + IDB_SYS_MODAL];
    virtual void HandleNonModalButton(RTMessage Msg)
      = [ID_FIRST + IDB_NON_MODAL_DIALOG];
    virtual void HandleNoParentButton(RTMessage Msg)
      = [ID_FIRST + IDB_NO_PARENT_NON_MODAL];

    void DisplayStatus(int nStatus); // display status of buttons pressed
				     // when within message boxes
  };

void TDialogAllDialog:: HandleModalMenu(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Modal_Dialog_Box"));
  }               //ExecDialog activates a modal dialog box
void TDialogAllDialog:: HandleMenuOK(RTMessage)
  {
  int nStatus;
  nStatus = MessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_OK);
  DisplayStatus(nStatus);
  }
void TDialogAllDialog:: HandleSysModalMenu(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Sys_Modal_Dialog_Box"));
  }               //ExecDialog activates a modal dialog box
 void TDialogAllDialog:: HandleNonModalMenu(RTMessage)
  {
  GetApplication()->MakeWindow(new TDialog(this,"Non_Modal_Dialog_Box"));
  }               //MakeWindow activates a non-modal dialog box with parent
void TDialogAllDialog:: HandleNoParentMenu(RTMessage)
  {
  GetApplication()->MakeWindow(new TDialog(NULL,"No_Parent_Non_Modal"));
  }               // MakeWindow activates a non-modal dialog box
		  // the null qualifier makes it parentless.

void TDialogAllDialog:: HandleModalButton(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Modal_Dialog_Box"));
  }
void TDialogAllDialog:: HandleButtonOK(RTMessage)
  {
  int nStatus;
  nStatus = MessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_OK);
  DisplayStatus(nStatus);
  }
void TDialogAllDialog:: HandleSysModalButton(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Sys_Modal_Dialog_Box"));
  }
void TDialogAllDialog:: HandleNonModalButton(RTMessage)
  {
  GetApplication()->MakeWindow(new TDialog(this,"Non_Modal_Dialog_Box"));
  }
void TDialogAllDialog:: HandleNoParentButton(RTMessage)
  {
  GetApplication()->MakeWindow(new TDialog(NULL,"No_Parent_Non_Modal"));
  }

void TDialogAllDialog::DisplayStatus(int nStatus)
  {
  char szBuffer[40];
  switch (nStatus)
    {
    case IDABORT:
      wsprintf(szBuffer,"The Abort Button sent number %d",nStatus);
      break;
    case IDCANCEL:
      wsprintf(szBuffer,"The Cancel Button sent number %d",nStatus);
      break;
    case IDIGNORE:
      wsprintf(szBuffer,"The Ignore Button sent number %d",nStatus);
      break;
    case IDNO:
      wsprintf(szBuffer,"The No Button sent number %d",nStatus);
      break;
    case IDOK:
      wsprintf(szBuffer,"The OK Button sent number %d",nStatus);
      break;
    case IDRETRY:
      wsprintf(szBuffer,"The Retry Button sent number %d",nStatus);
      break;
    case IDYES:
      wsprintf(szBuffer,"The Yes Button sent number %d",nStatus);
      break;
    default:
      wsprintf(szBuffer,"Out of Range Value  %d Passed",nStatus);
    }
    int i;
    if (nStatus > 0)
       MessageBox(HWindow,szBuffer,"Button Message",MB_OK);
    else 	      //not enough memory to create message box
       for (i=0;i<100;i++)MessageBeep(0);     // so beep instead
  }


class TDialogAllApp : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialogAllApp(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialogAllApp::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TDialogAllDialog("Main_Window_Dialog");
  }                                // using message processing provided
				   // by derived class

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialogAllApp DialogAll("Dialog Tester",hInstance,  // create instance of
			   hPrevInstance,             // the dialog application
			   lpCmdLine,nCmdShow);
  DialogAll.Run();                                  // run it
  return (DialogAll.Status);                        // exit
  }
/**********************************************************************/
