/**********************************************************************/
/*                  Dlgnonmd.cpp by Bob Bourbonnais                   */
/*              released to the public domain 12/16/91                */
/*              This program demonstrates a dialog box                */
/*       with a menu and two buttons that can call a non-modal        */
/*      dialog box with parent from either the menu or a button.      */
/*      A non-modal dialog box will not keep control.  You can go     */
/*      to other windows while it is open.  A non-modal dialog box    */
/*      with a parent will allways appear in front of the parent even */
/*                    when the parent has the focus.                  */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "dlgnonmd.h"

class TDialog5Dialog : public TDialog    // Dialog class to add
  {					 // processing for menu and
  public:				 // button selections
    TDialog5Dialog(LPSTR lpName)         // constructor calls
      :TDialog(NULL,lpName) {};		 // base class constructor
    virtual void HandleMenuItem(RTMessage Msg)      // menu handler
      = [CM_FIRST + IDM_NON_MODAL_DIALOG];
    virtual void HandleButtonMessage(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_NON_MODAL_DIALOG];   // close button handled by
  };                                     // base class button handler
void TDialog5Dialog:: HandleMenuItem(RTMessage)
  {
  GetApplication()->MakeWindow(new TDialog(this,"Non_Modal_Dialog_Box"));
  }               //MakeWindow activates a non-modal dialog box with parent
void TDialog5Dialog:: HandleButtonMessage(RTMessage)
  {
  GetApplication()->MakeWindow(new TDialog(this,"Non_Modal_Dialog_Box"));
  }

class TDialog5App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog5App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog5App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TDialog5Dialog("Main_Window_Dialog");
  }                                // using message processing provided
				   // by derived class

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog5App Dialog5("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog5.Run();                                  // run it
  return (Dialog5.Status);                        // exit
  }
/**********************************************************************/
