/**********************************************************************/
/*                  Dlgsysmd.cpp by Bob Bourbonnais                   */
/*              released to the public domain 12/16/91                */
/*              This program demonstrates a dialog box                */
/*             with a menu and two buttons that can call              */
/*      a system modal dialog box from either the menu or a button.   */
/*      A system modal dialog box will not let you do anything in     */
/*           any windows program until you have delt with it.         */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "dlgsysmd.h"

class TDialog4Dialog : public TDialog    // Dialog class to add
  {					 // processing for menu and
  public:				 // button selections
    TDialog4Dialog(LPSTR lpName)         // constructor calls
      :TDialog(NULL,lpName) {};		 // base class constructor
    virtual void HandleMenuItem(RTMessage Msg)      // menu handler
      = [CM_FIRST + IDM_MODAL_DIALOG];
    virtual void HandleButtonMessage(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_MODAL_DIALOG];   // close button handled by
  };                                     // base class button handler
void TDialog4Dialog:: HandleMenuItem(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Modal_Dialog_Box"));
  }               //ExecDialog activates a modal dialog box
void TDialog4Dialog:: HandleButtonMessage(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Modal_Dialog_Box"));
  }

class TDialog4App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog4App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog4App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TDialog4Dialog("Main_Window_Dialog");
  }                                // using message processing provided
				   // by derived class

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog4App Dialog4("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog4.Run();                                  // run it
  return (Dialog4.Status);                        // exit
  }
/**********************************************************************/
