#define WIN31
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <string.h>
#include "Printer.h"

// --------------------------------------------------------------- //
// Save the program's instance handle                              //
// --------------------------------------------------------------- //
HINSTANCE hInst;


// --------------------------------------------------------------- //
// Starting point of all Windows programs                          //
// --------------------------------------------------------------- //
#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpCmdLine, int nCmdShow)
{
   MSG msg;

   if (!hPrevInstance)                    // Any previous instance?
      if (!InitApplication(hInstance))    // Initialize app-specific stuff
         return FALSE;
   if (!InitInstance(hInstance, nCmdShow))   // Instance-specific
      return FALSE;

   // Standard Windows message loop
   while (GetMessage(&msg, NULL, NULL, NULL)) 
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return (msg.wParam);
}


// --------------------------------------------------------------- //
// Initialize application-specific stuff and register the class    //
// --------------------------------------------------------------- //
BOOL InitApplication(HINSTANCE hInstance)
{
   WNDCLASS wc;

   wc.style          = CS_DBLCLKS;
   wc.lpfnWndProc    = (WNDPROC) MainWndProc;
   wc.cbClsExtra     = 0;
   wc.cbWndExtra     = 0;
   wc.hInstance      = hInstance;
   wc.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground  = (HBRUSH)GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName   = lpszMENUNAME;
   wc.lpszClassName  = lpszCLASSNAME;
   return (RegisterClass(&wc));
}


// --------------------------------------------------------------- //
// Initialize instance and display the main window                 //
// --------------------------------------------------------------- //
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance;
   hWnd = CreateWindow(lpszCLASSNAME, lpszTITLE,
      WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hInstance, NULL);

   if (!hWnd)
      return FALSE;
   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   return TRUE;
}


// --------------------------------------------------------------- //
// Standard message-handler routine for main window                //
// --------------------------------------------------------------- //
LRESULT FAR PASCAL _export MainWndProc(HWND hWnd, UINT message, 
                                       WPARAM wParam, LPARAM lParam)
{
   switch (message) 
   {
      HANDLE_MSG(hWnd, WM_DESTROY,        MainWnd_OnDestroy);
      HANDLE_MSG(hWnd, WM_PAINT,          MainWnd_OnPaint);
      HANDLE_MSG(hWnd, WM_LBUTTONDBLCLK,  MainWnd_OnLBDblClk);
   }
   return DefWindowProc(hWnd, message, wParam, lParam);
}


// --------------------------------------------------------------- //
// WM_DESTROY                                                      //
// --------------------------------------------------------------- //
#pragma argsused
void MainWnd_OnDestroy(HWND hWnd)
{
   PostQuitMessage(0);
}


// --------------------------------------------------------------- //
// WM_PAINT                                                        //
// --------------------------------------------------------------- //
void MainWnd_OnPaint(HWND hWnd)
{
   HDC hdc;
   PAINTSTRUCT ps;
   RECT r;

   hdc = BeginPaint(hWnd, &ps);
   GetClientRect(hWnd, &r);
   DrawStuff(hdc, r);
   EndPaint(hWnd, &ps);
}


// --------------------------------------------------------------- //
// WM_LBUTTONDBLCLK                                                //
// --------------------------------------------------------------- //
#pragma argsused
void MainWnd_OnLBDblClk(HWND hWnd, BOOL, int, int, UINT)
{
   HDC hdcPrn;
   DOCINFO DocInfo;
   char Temp[80];
   char *PDevice, *PDriver, *PPort;

   GetPrinterSettings(Temp, 80, &PDevice, &PDriver, &PPort);
   hdcPrn = CreateDC(PDriver, PDevice, PPort, NULL);
   if (hdcPrn != NULL)
   {
      DocInfo.cbSize = sizeof(DocInfo);
      DocInfo.lpszDocName = "Test";
      DocInfo.lpszOutput = NULL;
      StartDoc(hdcPrn, &DocInfo);
      StartPage(hdcPrn);

      RECT r;   
      r.left = r.top = 0;        // left and top CANNOT be changed
      r.right = 640;
      r.bottom = 480;
      DrawStuff(hdcPrn, r);

      EndPage(hdcPrn);
      EndDoc(hdcPrn);
      DeleteDC(hdcPrn);
   }
}


// --------------------------------------------------------------- //
// GetPrinterSettings                                              //
// --------------------------------------------------------------- //
void GetPrinterSettings(char *lpPrintInfo, int size, 
   char **lpPrintDevice, char **lpPrintDriver, char **PrintPort)
{
   GetProfileString("windows", "device", "", lpPrintInfo, size);
   *lpPrintDevice = strtok(lpPrintInfo, ",");
   lpPrintInfo += strlen(*lpPrintDevice) + 1;
   *lpPrintDriver = strtok(lpPrintInfo, ",");
   lpPrintInfo += strlen(*lpPrintDriver) + 1;
   *PrintPort = lpPrintInfo;
}


// --------------------------------------------------------------- //
// DrawStuff                                                       //
// --------------------------------------------------------------- //
void DrawStuff(HDC hdc, RECT r)
{
   if (GetDeviceCaps(hdc, TECHNOLOGY) == DT_RASDISPLAY)
   {
      SetMapMode(hdc, MM_TEXT);
   }
   else if (GetDeviceCaps(hdc, TECHNOLOGY) == DT_RASPRINTER)
   {
      SetMapMode(hdc, MM_ANISOTROPIC);
      SetViewportExt(hdc, GetDeviceCaps(hdc, HORZRES), GetDeviceCaps(hdc, VERTRES));
      SetWindowExt(hdc, r.right-r.left, r.bottom-r.top);
   }
   else return;

   SetWindowOrg(hdc, 0, 0);

   // draw here
   MoveTo(hdc, 0, 0);
   LineTo(hdc, 200, 350);
   MoveTo(hdc, 0, 400);
   LineTo(hdc, 356, 0);

   TextOut(hdc, 20, 20, "hello", 5);
   Rectangle(hdc, 200, 235, 350, 300);
   Ellipse(hdc, 80, 100, 100, 120);
}   

