 /*------------------------------------------
     ABOUT3.C -- About Box Demo Program No. 3
			(c) Charles Petzold, 1990
   -------------------------------------------*/

#include <windows.h>
#include "about3.h"

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
long FAR PASCAL EllipPushWndProc (HWND, WORD, WORD, LONG);

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
			     LPSTR lpszCmdLine, int nCmdShow)
	 {
	 static char szAppName [] = "About3";
	 MSG		msg;
	 HWND		hwnd;
	 WNDCLASS   wndclass;

	 if (!hPrevInstance)
		{
		wndclass.style		= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= WndProc;
		wndclass.cbClsExtra	= 0;
		wndclass.cbWndExtra	= 0;
		wndclass.hInstance	= hInstance;
		wndclass.hIcon		= LoadIcon (hInstance, szAppName);
		wndclass.hCursor		= LoadCursor (NULL, IDC_ARROW);
		wndclass.hbrBackground	= GetStockObject (WHITE_BRUSH);
		wndclass.lpszMenuName	= szAppName;
		wndclass.lpszClassName	= szAppName;

		RegisterClass (&wndclass);

		wndclass.style		= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= EllipPushWndProc;
		wndclass.cbClsExtra	= 0;
		wndclass.cbWndExtra	= 0;
		wndclass.hInstance	= hInstance;
		wndclass.hIcon		= NULL;
		wndclass.hCursor		= LoadCursor (NULL, IDC_ARROW);
		wndclass.hbrBackground	= COLOR_WINDOW + 1;
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= "EllipPush";

		RegisterClass (&wndclass);
		}

	 hwnd = CreateWindow (szAppName, "About Box Demo Program",
				    WS_OVERLAPPEDWINDOW,
				    CW_USEDEFAULT, CW_USEDEFAULT,
				    CW_USEDEFAULT, CW_USEDEFAULT,
				    NULL, NULL, hInstance, NULL);

	 ShowWindow (hwnd, nCmdShow);
	 UpdateWindow (hwnd);

	 while (GetMessage (&msg, NULL, 0, 0))
		{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
		}
	 return msg.wParam;
	 }

 BOOL FAR PASCAL AboutDlgProc (HWND hDlg, WORD message, WORD wParam, LONG lParam)
	 {
	 switch (message)
		{
		case WM_INITDIALOG:
		     return TRUE;

		case WM_COMMAND:
		     switch (wParam)
			    {
			    case IDOK:
				   EndDialog (hDlg, 0);
				   return TRUE;
			    }
		     break;
		}
	 return FALSE;
	 }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
	 {
	 static FARPROC   lpfnAboutDlgProc;
	 static HANDLE	hInstance;

	 switch (message)
		{
		case WM_CREATE:
		     hInstance = ((LPCREATESTRUCT) lParam) ->hInstance;

		     lpfnAboutDlgProc = MakeProcInstance (AboutDlgProc, hInstance);
		     return 0;

		case WM_COMMAND:
		     switch (wParam)
			    {
			    case IDM_ABOUT:
				   DialogBox (hInstance, "AboutBox", hwnd,
							lpfnAboutDlgProc);
				   return 0;
			    }
		     break;

		case WM_DESTROY:
		     PostQuitMessage (0);
		     return 0;
		}
	 return DefWindowProc (hwnd, message, wParam, lParam);
	 }

long FAR PASCAL EllipPushwndProc (HWND hwnd, WORD message,
						 WORD wParam, LONG lParam)
	 {
	 char		  szText [40];
	 HBRUSH	  hBrush;
	 HDC		  hdc;
	 PAINTSTRUCT  ps;
	 RECT		  rect;

	 switch (message)
		{
		case WM_PAINT:
		     GetClientRect (hwnd, &rect);
		     GetWindowText (hwnd, szText, sizeof szText);

		     hdc = BeginPaint (hwnd, &ps);

		     hBrush = CreateSolidBrush (GetSysColor (COLOR_WINDOW));
		     hBrush = SelectObject (hdc, hBrush);
		     SetBkColor (hdc, GetSysColor (COLOR_WINDOW));
		     SetTextColor (hdc, GetSysColor (COLOR_WINDOWTEXT));

		     Ellipse (hdc, rect.left, rect.top, rect.right, rect.bottom);
		     DrawText (hdc, szText, -1, &rect,
					  DT_SINGLELINE | DT_CENTER | DT_VCENTER);

		     DeleteObject (SelectObject (hdc, hBrush));

		     EndPaint (hwnd, &ps);
		     return 0;

		case WM_KEYUP:
		     if (wParam != VK_SPACE)
			    break;
							     // fall through
		case WM_LBUTTONUP:
		     SendMessage (GetParent (hwnd), WM_COMMAND,
			   GetWindowWord (hwnd, GWW_ID), (LONG) hwnd);
		     return 0;
		}
	 return DefWindowProc (hwnd, message, wParam, lParam);
	 }





