/****************************************************************************

      Qexit
      Copyright (c) 1990, Greg Leman
      4600 University Drive #212
      Durham, NC  27707

	PROGRAM: qexit.c

	PURPOSE: qexit template for Windows applications

	FUNCTIONS:

	WinMain() - calls initialization function, processes message loop
	qexitInit() - initializes window data and registers window
	qexitWndProc() - processes messages
	About() - processes messages for "About" dialog box

****************************************************************************/

#include "windows.h"			/* required for all Windows applications */
#include "qexit.h"			/* specific to this program			 */

HANDLE hInst;				/* current instance				 */
HANDLE hMenu; 			/* Handle to my new menu						*/

/****************************************************************************

	FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

	PURPOSE: calls initialization function, processes message loop

	COMMENTS:

	This will initialize the window class if it is the first time this
	application is run.  It then creates the window, and processes the
	message loop until a PostQuitMessage is received.  It exits the
	application by returning the value passed by the PostQuitMessage.

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;				 /* current instance		 */
HANDLE hPrevInstance;				 /* previous instance		 */
LPSTR lpCmdLine;				 /* command line			 */
int nCmdShow;					 /* show-window type (open/icon) */
{
	HWND hWnd;					 /* window handle			 */
	MSG msg;					 /* message				 */


   if (!hPrevInstance)			/* Has application been initialized? */
	if (!qexitInit(hInstance))
		return (NULL);   		/* Exits if unable to initialize	 */

   hInst = hInstance;			/* Saves the current instance		 */

   hMenu = LoadMenu(hInstance, "qexitMenu");
   hWnd = CreateWindow("qexit",  /* window class		 */
	 "Quick Exit",  /* window name		 */
	WS_OVERLAPPEDWINDOW,			  /* window style		 */
	CW_USEDEFAULT,				  /* x position			 */
	CW_USEDEFAULT,				  /* y position			 */
	CW_USEDEFAULT,				  /* width			 */
	CW_USEDEFAULT,				  /* height			 */
	NULL,					  /* parent handle		 */
	hMenu,					  /* menu or child ID		 */
	hInstance,				  /* instance			 */
	NULL);					  /* additional info		 */

	if (!hWnd)					  /* Was the window created? */
	return (NULL);

	ShowWindow(hWnd, 0xFF8F);			  /* Shows the window		 */

	while (GetMessage(&msg,	   /* message structure				 */
		NULL,		   /* handle of window receiving the message */
		NULL,		   /* lowest message to examine			 */
		NULL))		   /* highest message to examine		 */
	{
	TranslateMessage(&msg);	   /* Translates virtual key codes		 */
	DispatchMessage(&msg);	   /* Dispatches message to window		 */
	}
	return (msg.wParam);	   /* Returns the value from PostQuitMessage */
}


/****************************************************************************

	FUNCTION: qexitInit(HANDLE)

	PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL qexitInit(hInstance)
HANDLE hInstance;				   /* current instance		 */
{
	HANDLE hMemory;				   /* handle to allocated memory */
	PWNDCLASS pWndClass;			   /* structure pointer		 */
	BOOL bSuccess;				   /* RegisterClass() result	 */

	hMemory = LocalAlloc(LPTR, sizeof(WNDCLASS));
	pWndClass = (PWNDCLASS) LocalLock(hMemory);

	pWndClass->style = NULL;
	pWndClass->lpfnWndProc = qexitWndProc;
	pWndClass->hInstance = hInstance;
	pWndClass->hIcon = LoadIcon(hInstance, "qexit");
	pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);
	pWndClass->hbrBackground = GetStockObject(WHITE_BRUSH);
	pWndClass->lpszMenuName = "qexitMenu";
	pWndClass->lpszClassName = (LPSTR) "qexit";

	bSuccess = RegisterClass(pWndClass);

	LocalUnlock(hMemory);				/* Unlocks the memory	*/
	LocalFree(hMemory);					/* Returns it to Windows */

	return (bSuccess);		 /* Returns result of registering the window */
}

/****************************************************************************

	FUNCTION: qexitWndProc(HWND, unsigned, WORD, LONG)

	PURPOSE:  Processes messages

	MESSAGES:

	WM_CREATE	- create window
	WM_DESTROY	- destroy window
	WM_COMMAND	- menu selections and others

	COMMENTS:


****************************************************************************/

long FAR PASCAL qexitWndProc(hWnd, message, wParam, lParam)
HWND hWnd;				  /* window handle			 */
unsigned message;			  /* type of message			 */
WORD wParam;				  /* additional information		 */
LONG lParam;				  /* additional information		 */
{
	HMENU hMenu;			  /* handle to the System menu		 */

	switch (message) {

	case WM_CREATE:				/* message: window being created */
		break;

	case WM_DESTROY:		  /* message: window being destroyed */
		PostQuitMessage(0);
		break;

   case WM_QUERYOPEN:
         if( MessageBox(hWnd,"Are you Very Sure?",
                  (LPSTR) "Exiting Windows", MB_OKCANCEL|MB_ICONEXCLAMATION)
           == IDOK)
             {     
			         DestroyWindow(hWnd);
                  ExitWindows( (DWORD)NULL, 1);
             }
      break;

	default:			  /* Passes it on if unproccessed	*/
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (NULL);
}

