{ Windows 3.1 Sound board detection and capabilities }

program SndCaps;

uses Objects,OWindows,ODialogs,WinTypes,WinPRocs,Win31,Strings,MMSystem;

{$R SNDCAPS.RES }

const
     cm_About = 999;
     id_MidiBtn = 198;
     id_ListBox = 102;

type
    pMidiDlg = ^tMidiDlg;
    tMidiDlg = object(tDialog)
                 procedure SetUpWindow; virtual;
               end;

    pMainDlg = ^tMainDlg;
    tMainDlg = object(TDlgWindow)
                 MidiPB : pButton;
                 NumInDevs,NumOutDevs : word;
                 NumOutMidi,NumInMidi : word;
                 constructor Init(Aparent : pWindowsObject; AName : PChar);
                 procedure SetUpWindow; virtual;
                 function GetClassName : PChar; virtual;
                 procedure GetWindowClass(var AWndClass : tWndClass);
                           virtual;
                 procedure DoAbout(var Msg : TMEssage);
                           virtual cm_First + cm_About;
                 procedure FillDialog;
                 procedure DevSelect(var Msg : TMessage);
                           virtual id_First+ id_ListBox;
                 procedure ShowMidi(var Msg : TMessage);
                           virtual id_First + id_MidiBtn;
               end;

    tApp = object(TApplication)
             BWCC : THandle;
             constructor Init(AName : pChar);
             procedure InitMainWindow; virtual;
             destructor Done; virtual;
           end;

var
    CurDev : word;

constructor tApp.Init;

  begin
    inherited init(AName);
    BWCC := LoadLibrary('C:\WINDOWS\SYSTEM\BWCC.DLL');
    if BWCC < 32 then
    begin
      MessageBox(0,'Cannot find BWCC.DLL!','Sound Capabilities',mb_OK);
      exit;
    end;
  end;

destructor tApp.Done;

  begin
    FreeLibrary(BWCC);
    inherited Done;
  end;


procedure tApp.InitMainWindow;

  begin
    MainWindow := new(pMainDlg,Init(nil,PChar(100)));
  end;

constructor tMainDlg.Init;

  begin
    inherited Init(AParent,AName);
    MidiPB := new(pButton,InitResource(@Self,id_MidiBtn));
  end;

procedure tMainDlg.FillDialog;

  var
     i : word;
     OutCaps : tWaveOutCaps;
     InCaps : tWaveInCaps;

  begin
    NumOutDevs := WaveOutGetNumDevs;
    NumInDevs := WaveInGetNumDevs;
    for i := 0 to NumOutDevs - 1 do
    begin
      fillchar(OutCaps,sizeof(OutCaps),0);
      WaveOutGetDevCaps(i,@OutCaps,sizeof(OutCaps));
      SendDlgItemMsg(102,lb_AddString,0,longint(@(OutCaps.szPName)));
    end;
    for i := 0 to NumInDevs - 1 do
    begin
      fillchar(InCaps,sizeof(InCaps),0);
      WaveInGetDevCaps(i,@InCaps,sizeof(InCaps));
      SendDlgItemMsg(102,lb_AddString,0,longint(@(InCaps.szPName)));
    end;
  end;

procedure tMainDlg.DevSelect;

  var
     CurSel : word;
     Formats,Controls : longint;
     Channels : word;
     DevIn : boolean;
     OutCaps : tWaveOutCaps;
     InCaps : tWaveInCaps;
     Major,Minor : string;
     Buffer : array[0..4] of char;

  begin
    if Msg.lParamHi = lbn_SelChange then
    begin
      for CurDev := 200 to 205 do
        SendDlgItemMsg(CurDev,bm_SetCheck,0,0);
      for CurDev := 300 to 305 do
        SendDlgItemMsg(CurDev,bm_SetCheck,0,0);
      for CurDev := 400 to 404 do
        SendDlgItemMsg(CurDev,bm_SetCheck,0,0);

      DevIn := FALSE;
      CurSel := SendDlgItemMsg(102,lb_GetCurSel,0,0);
      if CurSel > (NumOutDevs - 1) then
      begin
        CurSel := CurSel - NumOutDevs;
        DevIn := TRUE;
      end;
      CurDev := CurSel;
      case DevIn of
        FALSE : begin
                  WaveOutGetDevCaps(Curdev,@OutCaps,sizeof(OutCaps));
                  Formats := OutCaps.dwFormats;
                  Controls := OutCaps.dwSupport;
                  Channels := OutCaps.wChannels;
                  str(Hi(OutCaps.vDriverVersion),Major);
                  str(Lo(OutCaps.vDriverVersion),Minor);
                  Major := Major + '.' + Minor;
                  StrPCopy(Buffer,Major);
                  SendDlgItemMsg(500,wm_SetText,0,longint(@Buffer));
                  SendDlgItemMsg(501,wm_SetText,0,longint(@(OutCaps.szPName)));
                  StrCopy(Buffer,'Output Formats');
                  SendDlgItemMsg(199,wm_SetText,0,longint(@Buffer));
                end;
         TRUE : begin
                  WaveInGetDevCaps(CurDev,@InCaps,sizeof(InCaps));
                  Formats := Incaps.dwFormats;
                  Channels := InCaps.wChannels;
                  Controls := 0;
                  str(Hi(InCaps.vDriverVersion),Major);
                  str(Lo(InCaps.vDriverVersion),Minor);
                  Major := Major + '.' + Minor;
                  StrPCopy(Buffer,Major);
                  SendDlgItemMsg(500,wm_SetText,0,longint(@Buffer));
                  SendDlgItemMsg(501,wm_SetText,0,longint(@(InCaps.szPName)));
                  StrCopy(Buffer,'Input Formats');
                  SendDlgItemMsg(199,wm_SetText,0,longint(@Buffer));
                end;
      end;
      if Formats and WAVE_FORMAT_1M08 = WAVE_FORMAT_1M08 then
        SendDlgItemMsg(200,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_1M16 = WAVE_FORMAT_1M16 then
        SendDlgItemMsg(201,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_2M08 = WAVE_FORMAT_2M08 then
        SendDlgItemMsg(202,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_2M16 = WAVE_FORMAT_2M16 then
        SendDlgItemMsg(203,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_4M08 = WAVE_FORMAT_4M08 then
        SendDlgItemMsg(204,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_4M16 = WAVE_FORMAT_4M16 then
        SendDlgItemMsg(205,bm_SetCheck,1,0);

      if Formats and WAVE_FORMAT_1S08 = WAVE_FORMAT_1S08 then
        SendDlgItemMsg(300,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_1S16 = WAVE_FORMAT_1S16 then
        SendDlgItemMsg(301,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_2S08 = WAVE_FORMAT_2S08 then
        SendDlgItemMsg(302,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_2S16 = WAVE_FORMAT_2S16 then
        SendDlgItemMsg(303,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_4S08 = WAVE_FORMAT_4S08 then
        SendDlgItemMsg(304,bm_SetCheck,1,0);
      if Formats and WAVE_FORMAT_4S16 = WAVE_FORMAT_4S16 then
        SendDlgItemMsg(305,bm_SetCheck,1,0);

      if Controls and WAVECAPS_PITCH = WAVECAPS_PITCH then
        SendDlgItemMsg(400,bm_SetCheck,1,0);
      if Controls and WAVECAPS_PLAYBACKRATE = WAVECAPS_PLAYBACKRATE then
        SendDlgItemMsg(401,bm_SetCheck,1,0);
      if Controls and WAVECAPS_VOLUME = WAVECAPS_VOLUME then
        SendDlgItemMsg(402,bm_SetCheck,1,0);
      if Controls and WAVECAPS_LRVOLUME = WAVECAPS_LRVOLUME then
      begin
        SendDlgItemMsg(403,bm_SetCheck,1,0);
        SendDlgItemMsg(404,bm_SetCheck,1,0);
      end;
      str(Channels,Major); StrPCopy(Buffer,Major);
      SendDlgItemMsg(210,wm_SetText,0,longint(@Buffer));
      NumOutMidi := MidiOutGetNumDevs;
      NumInMidi := MidiInGetNumDevs;
      if (NumOutMidi > 0) or (NumInMidi > 0) then
      begin
        MidiPB^.Show(sw_Show);
      end;
    end;
  end;

procedure tMainDlg.ShowMidi;

  begin
    Application^.ExecDialog(new(pMidiDlg,Init(@Self,PChar(102))));
  end;

procedure tMidiDlg.SetUpWIndow;

  var
     MidiOutCaps : tMidiOutCaps;
     Major,Minor : string;
     Buffer : array[0..50] of char;
     i : word;

  begin
    MidiOutGetDevCaps(CurDev,@MidiOutCaps,sizeof(MidiOutCaps));
    with MidiOutCaps do
    begin
      str(Hi(vDriverVersion),Major);
      str(Lo(vDriverVersion),Minor);
      Major := Major + '.' + Minor;
      StrPCopy(Buffer,Major);
      SendDlgItemMsg(103,wm_SetText,0,longint(@Buffer));
      SendDlgItemMsg(105,wm_SetText,0,longint(@(szPName)));
      if wTechnology and MOD_MIDIPORT = MOD_MIDIPORT then
        SendDlgItemMsg(200,bm_SetCheck,1,0);
      if wTechnology and MOD_SQSYNTH = MOD_SQSYNTH then
        SendDlgItemMsg(201,bm_SetCheck,1,0);
      if wTechnology and MOD_FMSYNTH = MOD_FMSYNTH then
        SendDlgItemMsg(202,bm_SetCheck,1,0);
      if wTechnology and MOD_MAPPER = MOD_MAPPER then
        SendDlgItemMsg(203,bm_SetCheck,1,0);
      if dwSupport and MIDICAPS_CACHE = MIDICAPS_CACHE then
        SendDlgItemMsg(300,bm_SetCheck,1,0);
      if dwSupport and MIDICAPS_VOLUME = MIDICAPS_VOLUME then
        SendDlgItemMsg(301,bm_SetCheck,1,0);
      if dwSupport and MIDICAPS_LRVOLUME = MIDICAPS_LRVOLUME then
      begin
        SendDlgItemMsg(302,bm_SetCheck,1,0);
        SendDlgItemMsg(303,bm_SetCheck,1,0);
      end;
      str(wVoices,Major); StrPCopy(Buffer,Major);
      SendDlgItemMsg(110,wm_SetText,0,longint(@Buffer));
      str(wNotes,Major); StrPCopy(Buffer,Major);
      SendDlgItemMsg(111,wm_SetText,0,longint(@Buffer));
      fillchar(buffer,sizeof(Buffer),'0');
      Buffer[16] := #0;
      for i := 0 to 15 do
        if (wChannelMask and i) = i then Buffer[i] := '1';
      SendDlgItemMsg(112,wm_SetText,0,longint(@Buffer));
    end;
  end;

procedure tMainDlg.SetUpWIndow;

  begin
    inherited SetUpWindow;
    PostMessage(HWindow,wm_Command,cm_About,0);
    MidiPB^.Show(sw_Hide);
    FillDialog;
  end;

function tMainDlg.GetClassName : PChar;

  begin
    GetClassName := 'bordlg_SoundCaps';
  end;

procedure tMainDlg.GetWindowClass;

  begin
    inherited GetWindowClass(AWndClass);
    AWndClass.hIcon := LoadIcon(HInstance,PChar(100));
  end;

procedure tMainDlg.DoAbout;

  begin
    Application^.ExecDialog(new(pDialog,Init(@Self,PChar(101))));
  end;

var
   TheApp : tApp;

begin
  TheAPp.Init('SNDCAPS');
  TheApp.Run;
  TheApp.DOne;
end.

