/*******************************************************************************
**									      **
** Spots        -	AMIGA-like SPOTS demo program for MS Windows 3.0      **
**									      **
** (C) 21.02.1991 by WIZARD-SOFT                                              **
**									      **
** Author: Kai Nacke							      **
**									      **
** File: spots.c   							      **
**									      **
** Last Update: 20.04.1991						      **
**									      **
********************************************************************************
**                                                                            **
**  WIZARD-SOFT                                      \   |    /               **
**  ===========                                        \ |   /                **
**                                                  -  -  o   - -             **
**  Magic Software from                                 / \ \                 **
**                                                     /   \ \                **
**      West Germany!!                                      \ \               **
**                                                           \_\              **
**                                                                            **
*******************************************************************************/

#define NOCOMM
#include <windows.h>
#include "spots.h"

// Some global variables used in the program.
HWND hWnd;				/* Handle to window. */
HPALETTE hPalette;                      /* Handle to palette. */
WORD wWidth, wHeight;                   /* Width & height of client area. */

// These are some string ressources.
char *szSpotsClass = "SpotsClass";
char *szTitle = "Spots";

/*
 * FUNCTION:
 *    WORD NEAR PASCAL Random(WORD wLimit)
 *
 * PURPOSE:
 *    Returns a random number >= 0 && < wLimit.
 *
 * RETURNS:
 *    A random number.
 */

WORD NEAR PASCAL Random(WORD wLimit)
{
	static DWORD Next = 1L;

	Next = Next * 1103515245L + 12345L;
	return (WORD) (((Next / 65536L) % 32768L) * wLimit / 32768L);
} /* of Random() */

/*
 * FUNCTION:
 *    HPALETTE NEAR PASCAL BuildtColorPalette(VOID)
 *
 * PURPOSE:
 *    Creates a nice color palette.
 *
 * RETURNS:
 *    HPALETTE - handle of color palette.
 */

HPALETTE NEAR PASCAL BuildtColorPalette(VOID)
{
	PLOGPALETTE pLogPal;
	HPALETTE hPal;
	WORD i;
	BYTE cRed, cGreen, cBlue;

	hPal = NULL;
	if (pLogPal = (PLOGPALETTE) LocalAlloc(LPTR, sizeof(LOGPALETTE) + COLOR_NUMBER*sizeof(PALETTEENTRY)))	
	{
		cRed = cGreen = cBlue = 0x00;
		pLogPal->palVersion = 0x300;
		pLogPal->palNumEntries = COLOR_NUMBER;
		for (i = 0; i < COLOR_NUMBER; i++)
		{
			pLogPal->palPalEntry[i].peRed = ~cRed;
			pLogPal->palPalEntry[i].peGreen = ~cGreen;
			pLogPal->palPalEntry[i].peBlue = ~cBlue;
			pLogPal->palPalEntry[i].peFlags = (BYTE) 0;
			if (!(cRed += 32))
				if (!(cGreen += 64))
					cBlue += 32;
		} /* of for */
		hPal = CreatePalette(pLogPal);
		LocalFree((LOCALHANDLE) pLogPal);
	} /* of if */
	return hPal;
} /* of BuildtColorPalette() */

/*
 * FUNCTION:
 *    VOID NEAR PASCAL DrawSpot(HWND hWnd)
 *			
 * PURPOSE:
 *    Draws a spot.
 *
 * RETURNS:
 *    Nothing.
 */

VOID NEAR PASCAL DrawSpot(HWND hWnd)
{
        HDC hDC;
        HPALETTE hOldPalette;
        HBRUSH hOldBrush;
        HPEN hOldPen;
        WORD x, y;

        // Try to get the device context.
        if (hDC = GetDC(hWnd))
        {
                // Select and realize palette.
                hOldPalette = SelectPalette(hDC, hPalette, FALSE);
                RealizePalette(hDC);

                // Select new pen and brush.
                hOldPen = SelectObject(hDC, CreatePen(PS_SOLID, 1, PALETTEINDEX(Random(COLOR_NUMBER))));
                hOldBrush = SelectObject(hDC, CreateSolidBrush(PALETTEINDEX(Random(COLOR_NUMBER))));

                // Draw spot.
                Ellipse(hDC, (x=Random(wWidth)), (y=Random(wHeight)), x+Random(wWidth-x), y+Random(wHeight-y));

                // Select old pen and brush and delete new ones.
                DeleteObject(SelectObject(hDC, hOldPen));
                DeleteObject(SelectObject(hDC, hOldBrush));

                // Select old palette.
                SelectPalette(hDC, hOldPalette, FALSE);

                // Throw away device context.
                ReleaseDC(hWnd, hDC);
        } /* of if */
} /* of DrawSpot() */

/*
 * FUNCTION:
 *    BOOL FAR PASCAL DlgAboutProc(HWND hDlg, WORD wMsg,
 *				   WORD wParam, LONG lParam)
 * PURPOSE:
 *    Provides a simple 'About..' box.
 *
 * RETURNS:
 *    TRUE - if message was handled by this function.
 *    FALSE - otherwise.
 */

BOOL FAR PASCAL DlgAboutProc(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
        switch (wMsg)
        {
	        case WM_INITDIALOG:
	                return TRUE;

	        case WM_COMMAND:
	                if (wParam == IDOK || wParam == IDCANCEL)
	                {
		                EndDialog(hDlg, TRUE);
		                return TRUE;
	                } /* of if */
	                break;
        } /* of switch */

	// Did not handle the message.
        return FALSE;
} /* of DlgAboutProc() */

/*
 * FUNCTION:
 *    LONG FAR PASCAL SpotsWndProc(HWND hWnd, WORD wMsg,
 *                                 WORD wParam, LONG lParam)
 *
 * PURPOSE:
 *    The window function for the window class. Handles all
 *    messages.
 *
 * RETURNS:
 *    NULL.
 */

LONG FAR PASCAL SpotsWndProc(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
	FARPROC lpfnDlgProc;

        switch (wMsg)
        {
                case WM_SIZE:
                        wWidth = LOWORD(lParam);
                        wHeight = HIWORD(lParam);
                        break;
	        case WM_DESTROY:
	                PostQuitMessage(0);
	                break;
		case WM_SYSCOMMAND:
		        if (wParam == IDMN_ABOUT)
		        {
		                lpfnDlgProc = MakeProcInstance(DlgAboutProc, GetWindowWord(hWnd, GWW_HINSTANCE));
                      		DialogBox(GetWindowWord(hWnd, GWW_HINSTANCE), ID_DLGABOUT, hWnd, lpfnDlgProc);
		                FreeProcInstance(lpfnDlgProc);
			        break;
			} /* of if */
                default:
			return DefWindowProc(hWnd, wMsg, wParam, lParam);
	} /* of switch */

	// Return zero to caller.
	return 0L;
} /* of SpotsWndProc() */

/*
 * FUNCTION:
 *    int NEAR PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
 *                            LPSTR lpszCmdLine, int nCmdShow)
 *
 * PURPOSE:
 *    This is the entry function for windows. It does some initialization
 *    and enters the message loop.
 *
 * RETURNS:
 *    Depends on the program.
 */

int NEAR PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
        MSG Msg;
        HMENU hMenu;

        // Do initialization of first instance.
        if (!hPrevInstance)
        {
                WNDCLASS wc;

                // Fill the WNDCLASS structure and register the frame class.
                wc.style = 0;
                wc.lpfnWndProc = SpotsWndProc;
                wc.cbClsExtra = 0;
                wc.cbWndExtra = 0;
                wc.hInstance = hInstance;
                wc.hIcon = NULL;
                wc.hCursor = LoadCursor(NULL, IDC_ARROW);
                wc.hbrBackground = COLOR_WINDOW+1;
                wc.lpszMenuName = NULL;
                wc.lpszClassName = szSpotsClass;

                // Abort if we can't register class.
                if (!RegisterClass(&wc))
                        return FALSE;
        } /* of if */

        // Create a window for us.
        if (!(hWnd = CreateWindow(szSpotsClass, szTitle, WS_OVERLAPPEDWINDOW,
                                  CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL)))

                return FALSE;

        // Add a 'About...' menu.
        hMenu = GetSystemMenu(hWnd, FALSE);
        AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
        AppendMenu(hMenu, MF_STRING, IDMN_ABOUT, "&ber Spots...");

        // Set the mode of the window and force a WM_PAINT message.
        ShowWindow(hWnd, nCmdShow);
        UpdateWindow(hWnd);

        // Buildt a color palette for us.
        hPalette = BuildtColorPalette();

        // Dispatch the messages.
        while (TRUE)
	{
	        if (PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE))
	        {
	                if (Msg.message == WM_QUIT)
	                        break;
		        TranslateMessage(&Msg);
        	        DispatchMessage(&Msg);
        	} /* of if */
        	else
        	        DrawSpot(hWnd);
        } /* of while */

        // Before leaving, destroy the palette.
        DeleteObject(hPalette);

        // Exit program.
        return Msg.wParam;
} /* of WinMain() */
