//===========================================================================
//  Program          : SBTEST.C
//  Version          : 1.0
//  Operating System : DOS / Windows 3.0
//  Author           : Jean-Marc Krikorian
//                     525 Sandy Lane 
//                     Libertyville, IL  60048 
//                     (708) 816-3314 
// 
//  Copyright 1991 Jean-Marc Krikorian. All Rights Reserved.
// 
//===========================================================================

#include "windows.h"  
#include "sbtest.h"  
#include "stsbar.ext"

#define ID_STATUSBAR 2000

HANDLE hInst;
HWND   hWndStatusBar = 0;
HMENU  hMenu = 0;
WORD   wTextAttributes = 0;
WORD   wCurrentFaceColor = 0;
WORD   wCurrentFaceStyle = 0;
WORD   wCurrentTextColor = 0;
WORD   wCurrentTextFont = 0;
BOOL   bStatusBarVisible = FALSE;
WORD   ypos = 0;


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  MSG msg;				  

  if (!hPrevInstance)			
  	if (!InitApplication(hInstance)) 
	    return (FALSE);		

  if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

  while (GetMessage(&msg, NULL, NULL,	NULL)) 
  {
	  TranslateMessage(&msg);	
  	DispatchMessage(&msg);	
  }

  return (msg.wParam);	
}

BOOL InitApplication(HANDLE hInstance)
{
  WNDCLASS  wc;

  wc.style = NULL;                 
  wc.lpfnWndProc = MainWndProc;    
                                   
  wc.cbClsExtra = 0;               
  wc.cbWndExtra = 0;               
  wc.hInstance = hInstance;        
  wc.hIcon = LoadIcon(hInstance, "SBTestIcon");
  wc.hCursor = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
  wc.lpszMenuName =  "SBTestMenu";   
  wc.lpszClassName = "SBTestWClass"; 

  return (RegisterClass(&wc));
}

BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
  HWND   hWnd;
  HANDLE hStatusBarFont;
  HFONT  hFont;
  LONG   lMyLong;
  WORD   wSize;

  hInst = hInstance;

  hWnd = CreateWindow("SBTestWClass",                
                      "Status Bar Test Application",   
                      WS_OVERLAPPEDWINDOW,            
                      CW_USEDEFAULT,                  
                      CW_USEDEFAULT,                  
                      CW_USEDEFAULT,                  
                      CW_USEDEFAULT,                  
                      NULL,                           
                      NULL,                           
                      hInstance,                      
                      NULL);

  if (!hWnd)
    return (FALSE);

  // init Status Bar
  StatusBarInit(hInst);

  ypos = 10;

  // Create the status bar window
  hWndStatusBar = CreateWindow("StatusBarClass",
                               NULL,
                               WS_CHILD | SBS_MOVEABLE,
                               0,ypos,0,0,
                               hWnd,
                               ID_STATUSBAR,
                               hInst,
                               NULL);

  if (!hWndStatusBar)
  {
    MessageBox(hWnd, "No Status Bar", "FUCK!!!!", MB_OK);
    return (FALSE);
  }

  SendMessage(hWndStatusBar, SBM_FACESTYLE, 0, (LONG)SBFS_3DFACE);
  wCurrentFaceStyle = IDM_SB3DFACE;
  CheckMenuItem(hMenu, wCurrentFaceStyle, MF_CHECKED);

  SendMessage(hWndStatusBar, SBM_FACECOLOR, 0, (LONG)SBCLR_GRAY);
  wCurrentFaceColor = IDM_SBGRAYFACE;
  CheckMenuItem(hMenu, wCurrentFaceColor, MF_CHECKED);

  SendMessage(hWndStatusBar, SBM_TEXTCOLOR, 0, (LONG)SBCLR_BLACK);
  wCurrentTextColor = IDM_SBBLACKTEXT;
  CheckMenuItem(hMenu, wCurrentTextColor, MF_CHECKED);

  wCurrentTextFont = IDM_SBDEFAULTSYSTEM;
  CheckMenuItem(hMenu, wCurrentTextFont, MF_CHECKED);

  bStatusBarVisible = TRUE;
  CheckMenuItem(hMenu, IDM_SBSHOW, MF_CHECKED);

  ShowWindow(hWndStatusBar, SW_SHOW);

  ShowWindow(hWnd, nCmdShow);  
  UpdateWindow(hWnd);          

  return (TRUE);    
}

long FAR PASCAL MainWndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
  static char    SText[80];
         LOGFONT lf;

  switch (message)
  {
    case WM_CREATE:
      hMenu = GetMenu(hWnd);
      wsprintf(SText, "%s%d", (LPSTR)"This is the Status Bar...", GetWindowWord(hWnd, GWW_HINSTANCE));
      return 0;

  	case WM_COMMAND:
    {
      switch (wParam)
      {
  	    case IDM_SBSHOW:
          bStatusBarVisible = TRUE;
          CheckMenuItem(hMenu, IDM_SBSHOW, MF_CHECKED);
          CheckMenuItem(hMenu, IDM_SBHIDE, MF_UNCHECKED);
          ShowWindow(hWndStatusBar, SW_SHOW);
          return 0;

        case IDM_SBHIDE:
          bStatusBarVisible = FALSE;
          CheckMenuItem(hMenu, IDM_SBHIDE, MF_CHECKED);
          CheckMenuItem(hMenu, IDM_SBSHOW, MF_UNCHECKED);
          ShowWindow(hWndStatusBar, SW_HIDE);
          return 0;

        case IDM_SBDISPLAYTEXT:
          SendMessage(hWndStatusBar, SBM_DISPLAYTEXT, 0, (LONG)(LPSTR)SText);
      		return 0;

    	  case IDM_SB3DFACE:
          CheckMenuItem(hMenu, wCurrentFaceStyle, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceStyle = wParam;
          SendMessage(hWndStatusBar, SBM_FACESTYLE, 0, (LONG)SBFS_3DFACE);
          return 0;

  	    case IDM_SB2DFACE:
          CheckMenuItem(hMenu, wCurrentFaceStyle, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceStyle = wParam;
          SendMessage(hWndStatusBar, SBM_FACESTYLE, 0, (LONG)SBFS_2DFACE);
          return 0;

  	    case IDM_SBFLATFACE:
          CheckMenuItem(hMenu, wCurrentFaceStyle, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceStyle = wParam;
          SendMessage(hWndStatusBar, SBM_FACESTYLE, 0, (LONG)SBFS_FLATFACE);
          return 0;

    	  case IDM_SBGRAYFACE:
          CheckMenuItem(hMenu, wCurrentFaceColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceColor = wParam;
          SendMessage(hWndStatusBar, SBM_FACECOLOR, 0, (LONG)SBCLR_GRAY);
          return 0;

    	  case IDM_SBBLACKFACE:
          CheckMenuItem(hMenu, wCurrentFaceColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceColor = wParam;
          SendMessage(hWndStatusBar, SBM_FACECOLOR, 0, (LONG)SBCLR_BLACK);
          return 0;

  	    case IDM_SBWHITEFACE:
          CheckMenuItem(hMenu, wCurrentFaceColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceColor = wParam;
          SendMessage(hWndStatusBar, SBM_FACECOLOR, 0, (LONG)SBCLR_WHITE);
          return 0;

  	    case IDM_SBREDFACE:
          CheckMenuItem(hMenu, wCurrentFaceColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceColor = wParam;
          SendMessage(hWndStatusBar, SBM_FACECOLOR, 0, (LONG)SBCLR_RED);
          return 0;

    	  case IDM_SBGREENFACE:
          CheckMenuItem(hMenu, wCurrentFaceColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceColor = wParam;
          SendMessage(hWndStatusBar, SBM_FACECOLOR, 0, (LONG)SBCLR_GREEN);
          return 0;

  	    case IDM_SBBLUEFACE:
          CheckMenuItem(hMenu, wCurrentFaceColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentFaceColor = wParam;
          SendMessage(hWndStatusBar, SBM_FACECOLOR, 0, (LONG)SBCLR_BLUE);
          return 0;

        case IDM_SBHELV8:
          CheckMenuItem(hMenu, wCurrentTextFont, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextFont = wParam;
          lf.lfHeight = 8;
          lf.lfWidth = 0;          // this field is ignored
          lf.lfEscapement = 0;     // this field is ignored
          lf.lfOrientation = 0;    // this field is ignored
          lf.lfWeight = 0;         // this field is ignored
          lf.lfItalic = 0;         // this field is ignored
          lf.lfUnderline = 0;      // this field is ignored
          lf.lfStrikeOut = 0;      // this field is ignored
          lf.lfCharSet = 0;        // this field is ignored
          lf.lfOutPrecision = 0;   // this field is ignored
          lf.lfClipPrecision = 0;  // this field is ignored
          lf.lfQuality = 0;        // this field is ignored
          lf.lfPitchAndFamily = 0; // this field is ignored
          lstrcpy (lf.lfFaceName, "Helv");
          SendMessage(hWndStatusBar, SBM_SETFONT, ypos, (LONG)(LPLOGFONT)&lf);
          return 0;

        case IDM_SBARIAL25:
          CheckMenuItem(hMenu, wCurrentTextFont, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextFont = wParam;
          lf.lfHeight = 25;
          lf.lfWidth = 0;          // this field is ignored
          lf.lfEscapement = 0;     // this field is ignored
          lf.lfOrientation = 0;    // this field is ignored
          lf.lfWeight = 0;         // this field is ignored
          lf.lfItalic = 0;         // this field is ignored
          lf.lfUnderline = 0;      // this field is ignored
          lf.lfStrikeOut = 0;      // this field is ignored
          lf.lfCharSet = 0;        // this field is ignored
          lf.lfOutPrecision = 0;   // this field is ignored
          lf.lfClipPrecision = 0;  // this field is ignored
          lf.lfQuality = 0;        // this field is ignored
          lf.lfPitchAndFamily = 0; // this field is ignored
          lstrcpy (lf.lfFaceName, "Arial");
          SendMessage(hWndStatusBar, SBM_SETFONT, ypos, (LONG)(LPLOGFONT)&lf);
          return 0;

        case IDM_SBTMS12:
          CheckMenuItem(hMenu, wCurrentTextFont, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextFont = wParam;
          lf.lfHeight = 12;
          lf.lfWidth = 0;          // this field is ignored
          lf.lfEscapement = 0;     // this field is ignored
          lf.lfOrientation = 0;    // this field is ignored
          lf.lfWeight = 0;         // this field is ignored
          lf.lfItalic = 0;         // this field is ignored
          lf.lfUnderline = 0;      // this field is ignored
          lf.lfStrikeOut = 0;      // this field is ignored
          lf.lfCharSet = 0;        // this field is ignored
          lf.lfOutPrecision = 0;   // this field is ignored
          lf.lfClipPrecision = 0;  // this field is ignored
          lf.lfQuality = 0;        // this field is ignored
          lf.lfPitchAndFamily = 0; // this field is ignored
          lstrcpy (lf.lfFaceName, "Tms");
          SendMessage(hWndStatusBar, SBM_SETFONT, ypos, (LONG)(LPLOGFONT)&lf);
          return 0;

        case IDM_SBDEFAULTSYSTEM:
          CheckMenuItem(hMenu, wCurrentTextFont, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextFont = wParam;
          SendMessage(hWndStatusBar, SBM_SETFONT, ypos, 0L);
          return 0;

    	  case IDM_SBGRAYTEXT:
          CheckMenuItem(hMenu, wCurrentTextColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextColor = wParam;
          SendMessage(hWndStatusBar, SBM_TEXTCOLOR, 0, (LONG)SBCLR_GRAY);
          return 0;

    	  case IDM_SBBLACKTEXT:
          CheckMenuItem(hMenu, wCurrentTextColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextColor = wParam;
          SendMessage(hWndStatusBar, SBM_TEXTCOLOR, 0, (LONG)SBCLR_BLACK);
          return 0;

  	    case IDM_SBWHITETEXT:
          CheckMenuItem(hMenu, wCurrentTextColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextColor = wParam;
          SendMessage(hWndStatusBar, SBM_TEXTCOLOR, 0, (LONG)SBCLR_WHITE);
          return 0;

  	    case IDM_SBREDTEXT:
          CheckMenuItem(hMenu, wCurrentTextColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextColor = wParam;
          SendMessage(hWndStatusBar, SBM_TEXTCOLOR, 0, (LONG)SBCLR_RED);
          return 0;

    	  case IDM_SBGREENTEXT:
          CheckMenuItem(hMenu, wCurrentTextColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextColor = wParam;
          SendMessage(hWndStatusBar, SBM_TEXTCOLOR, 0, (LONG)SBCLR_GREEN);
          return 0;

  	    case IDM_SBBLUETEXT:
          CheckMenuItem(hMenu, wCurrentTextColor, MF_UNCHECKED);
          CheckMenuItem(hMenu, wParam, MF_CHECKED);
          wCurrentTextColor = wParam;
          SendMessage(hWndStatusBar, SBM_TEXTCOLOR, 0, (LONG)SBCLR_BLUE);
          return 0;

  	    case IDM_SBBOLD:
          if (GetMenuState(hMenu, wParam, MF_BYCOMMAND) == MF_CHECKED)
          {
            CheckMenuItem(hMenu, wParam, MF_UNCHECKED);
            wTextAttributes = wTextAttributes & ~SBTA_BOLD;
          }
          else
          {
            CheckMenuItem(hMenu, wParam, MF_CHECKED);
            wTextAttributes = wTextAttributes | SBTA_BOLD;
          }

          SendMessage(hWndStatusBar, SBM_DISPLAYTEXT, wTextAttributes, (LONG)(LPSTR)SText);
          return 0;

  	    case IDM_SBITALICS:
          if (GetMenuState(hMenu, wParam, MF_BYCOMMAND) == MF_CHECKED)
          {
            CheckMenuItem(hMenu, wParam, MF_UNCHECKED);
            wTextAttributes = wTextAttributes & ~SBTA_ITALICS;
          }
          else
          {
            CheckMenuItem(hMenu, wParam, MF_CHECKED);
            wTextAttributes = wTextAttributes | SBTA_ITALICS;
          }

          SendMessage(hWndStatusBar, SBM_DISPLAYTEXT, wTextAttributes, (LONG)(LPSTR)SText);
          return 0;

  	    case IDM_SBUNDERLINE:
          if (GetMenuState(hMenu, wParam, MF_BYCOMMAND) == MF_CHECKED)
          {
            CheckMenuItem(hMenu, wParam, MF_UNCHECKED);
            wTextAttributes = wTextAttributes & ~SBTA_UNDERLINE;
          }
          else
          {
            CheckMenuItem(hMenu, wParam, MF_CHECKED);
            wTextAttributes = wTextAttributes | SBTA_UNDERLINE;
          }

          SendMessage(hWndStatusBar, SBM_DISPLAYTEXT, wTextAttributes, (LONG)(LPSTR)SText);
          return 0;

  	    case IDM_SBSTRIKEOUT:
          if (GetMenuState(hMenu, wParam, MF_BYCOMMAND) == MF_CHECKED)
          {
            CheckMenuItem(hMenu, wParam, MF_UNCHECKED);
            wTextAttributes = wTextAttributes & ~SBTA_STRIKEOUT;
          }
          else
          {
            CheckMenuItem(hMenu, wParam, MF_CHECKED);
            wTextAttributes = wTextAttributes | SBTA_STRIKEOUT;
          }

          SendMessage(hWndStatusBar, SBM_DISPLAYTEXT, wTextAttributes, (LONG)(LPSTR)SText);
          return 0;

        case ID_STATUSBAR:
          switch (HIWORD(lParam))
          {
            case SBN_LBUTTONUP:
              MessageBeep(0);
              return 0;

            case SBN_LBUTTONDBLCLK:
              MessageBox(hWnd, "Left Mouse Button Double-Click", "Status Bar Test", MB_OK);
              return 0;

            case SBN_RBUTTONUP:
              MessageBeep(0);
              return 0;

            case SBN_RBUTTONDBLCLK:
              MessageBox(hWnd, "Right Mouse Button Double-Click", "Status Bar Test", MB_OK);
              return 0;
          }
      }
    }
    return 0;

    case WM_DESTROY:
      // uninit Status Bar
      StatusBarUnInit(GetWindowWord(hWnd, GWW_HINSTANCE));

      PostQuitMessage(0);
      return 0;


    case WM_SIZE:
      if (hWndStatusBar)
      {
        SendMessage(hWndStatusBar, SBM_SIZE, ypos, lParam);
        ypos += 10;
      }
      return 0;
  }

  return (DefWindowProc(hWnd, message, wParam, lParam));
}
