#define STRICT                       
#define WIN31


#include <owl.h>
#include <dialog.h>
#include <listbox.h>
#include <static.h>
#include <bwcc.h>
#include <windowsx.h>

#include "..\toolhelp\_toolhlp.h"
#include "tasklist.h"


#define   WM_TASKLISTCHANGE     ( WM_USER + 500 )
#define   WM_SHOWTASKLIST       ( WM_USER + 510 )
#define   WM_HIDEDLG            ( WM_USER + 520 )


#define   SC_ABOUT                0x1100
#define   SC_SHOWDIALOG           0x1200


_CLASSDEF( TApp )
_CLASSDEF( TMainWindow )
_CLASSDEF( TMainDialog )



char szTitle[]      = "Task Info";
char szAboutStr[]   = "&About";
char szShowDlgStr[] = "&Task List";
                                   

class TApp : public TApplication
{
    public:
        TApp( LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
              LPSTR lpCmdLine, int nCmdShow) :
        TApplication( AName, hInstance, hPrevInstance,
                      lpCmdLine, nCmdShow )
        {};
        virtual void InitMainWindow();
};



class TMainWindow : public TWindow
{
        static HWND hwndMain;
        FARPROC lpfnNotify;
        static char szClassName[];

    public:
        PTMainDialog pInfoDlg;

        TMainWindow( PTWindowsObject AParent, LPSTR ATitle,
                     PTModule AModule = NULL );
       ~TMainWindow();
        virtual void GetWindowClass( WNDCLASS _FAR & AWndClass );
        virtual void SetupWindow();
        LPSTR  GetClassName()
        {
            return( szClassName );
        }
        static BOOL FAR PASCAL _export ToolHelpNotify( WORD wId, DWORD dwData );
        virtual void WMQueryOpen( RTMessage msg )      = [ WM_FIRST + WM_QUERYOPEN      ];
        virtual void WMTaskListChange( RTMessage msg ) = [ WM_FIRST + WM_TASKLISTCHANGE ];
        virtual void WMShowTaskList( RTMessage msg )   = [ WM_FIRST + WM_SHOWTASKLIST   ];
        virtual void WMHideDlg( RTMessage msg )        = [ WM_FIRST + WM_HIDEDLG        ];
        virtual void WMSysCommand( RTMessage msg )     = [ WM_FIRST + WM_SYSCOMMAND     ];
};
HWND TMainWindow::hwndMain = NULL;
char TMainWindow::szClassName[] = "!App!ClassName";



class TMainDialog : public TDialog
{
        PTStatic  pSTTitle;
        PTListBox pLBTaskList;
    public:
        TMainDialog( PTWindowsObject AParent, LPSTR AResource, PTModule AModule = NULL );
        virtual void SetupWindow();
        virtual BOOL CanClose();
        virtual void WMSize( RTMessage msg ) = [ WM_FIRST + WM_SIZE ];
        virtual void WMClose(RTMessage msg ) = [ WM_FIRST + WM_CLOSE];
        virtual void WMListBox( RTMessage  ) = [ ID_FIRST + ID_LISTBOX_TASKS ];
        void FillTaskInfo();
};



TMainWindow::TMainWindow( PTWindowsObject AParent, LPSTR ATitle,
                          PTModule AModule ):
TWindow( AParent, ATitle, AModule )
{
    lpfnNotify = MakeProcInstance(( FARPROC )ToolHelpNotify, GetApplication()->hInstance );
    if ( !lpfnNotify )
    {
        MessageBeep( 0 );
    }
    else if ( !NotifyRegister( NULL, ( LPFNNOTIFYCALLBACK )lpfnNotify, NF_NORMAL ))
    {
        FreeProcInstance( lpfnNotify );
        lpfnNotify = NULL ;
        MessageBeep( 0 );
    } 
    pInfoDlg = NULL;
}



TMainWindow::~TMainWindow()
{
    if ( lpfnNotify )
    {
        NotifyUnRegister( NULL );
        FreeProcInstance( lpfnNotify );
    }
}



void TMainWindow::GetWindowClass( WNDCLASS _FAR & AWndClass )
{
    TWindow::GetWindowClass( AWndClass );
}



void TMainWindow::SetupWindow()
{
    TWindow::SetupWindow();
    hwndMain = HWindow;

    HMENU hSysMenu;

    hSysMenu = GetSystemMenu( HWindow, 0 );
    AppendMenu( hSysMenu, MF_BYCOMMAND|MF_STRING,
                SC_ABOUT, szAboutStr );
    AppendMenu( hSysMenu, MF_BYCOMMAND|MF_STRING,
                SC_SHOWDIALOG, szShowDlgStr );
}



void TMainWindow::WMTaskListChange( RTMessage )
{
    if ( pInfoDlg )
        pInfoDlg->FillTaskInfo();
}



void TMainWindow::WMShowTaskList( RTMessage )
{
    if ( !pInfoDlg )
    {
        pInfoDlg = new TMainDialog( this, "MAINDIALOG" );
        GetApplication()->MakeWindow( pInfoDlg );
        pInfoDlg->Show( SW_SHOWNORMAL );
    }
    else
    {
        if ( IsIconic( pInfoDlg->HWindow ))
        {
            pInfoDlg->Show( SW_RESTORE );
        }
        BringWindowToTop( pInfoDlg->HWindow );
    }
}



void TMainWindow::WMHideDlg( RTMessage )
{
    if ( pInfoDlg )
        pInfoDlg->Show( SW_HIDE );
}



void TMainWindow::WMQueryOpen( RTMessage msg )
{
    PostMessage( HWindow, WM_SHOWTASKLIST, 0, 0 );
    msg.Result = FALSE;
}



void TMainWindow::WMSysCommand( RTMessage msg )
{
    switch ( msg.WParam & 0xFFF0 )
    {
    case SC_ABOUT:
         MessageBeep( 0 );
         break;

    case SC_SHOWDIALOG:
         PostMessage( HWindow, WM_SHOWTASKLIST, 0, 0 );
         break;               

    default:
        DefWndProc( msg );
    }
}


void TMainDialog::WMListBox( RTMessage msg )
{
    if ( msg.LP.Hi == LBN_DBLCLK )
    {
        int nIndex = pLBTaskList->GetSelIndex();
        if ( nIndex >= 0 )
        {
	    TASKENTRY  te;
	    HTASK   hTask;
	    DWORD   dwItemData;

	    dwItemData = ListBox_GetItemData( pLBTaskList->HWindow, nIndex );
	    hTask      = ( HTASK )dwItemData;

	    if ( _TaskFindHandle( &te, hTask ))
            {
                MessageBeep( 0 );
            }
        }
    }
}


BOOL FAR PASCAL _export TMainWindow::ToolHelpNotify( WORD wId, DWORD dwData )
{
    if ( wId == NFY_STARTTASK  ||  wId == NFY_EXITTASK )
    {
        PostMessage( hwndMain, WM_TASKLISTCHANGE, 0, 0 );
    }
    return( FALSE );
}



TMainDialog::TMainDialog( PTWindowsObject AParent, LPSTR AResource, PTModule AModule ):
TDialog( AParent, AResource, AModule )
{
    pLBTaskList = new TListBox( this, ID_LISTBOX_TASKS );
    pSTTitle    = new TStatic( this, ID_STATIC_TITLE, 0 );
}



void TMainDialog::SetupWindow()
{
    HFONT hAnsiFFont;

    TDialog::SetupWindow();

    hAnsiFFont = GetStockFont( ANSI_FIXED_FONT );
    if ( hAnsiFFont )
    {
       SendMessage( pLBTaskList->HWindow, WM_SETFONT,
                    ( WORD )hAnsiFFont, TRUE );
       SendMessage( pSTTitle->HWindow, WM_SETFONT,
                    ( WORD )hAnsiFFont, TRUE );
    }
    PostMessage( Parent->HWindow, WM_TASKLISTCHANGE, 0, 0 );
}



BOOL TMainDialog::CanClose()
{
    (( PTMainWindow )Parent )->pInfoDlg = NULL; // Clear Parent's Pointer         
    return( TRUE );                             // Allow Closing !
}



void TMainDialog::WMSize( RTMessage msg )
{
    if ( msg.WParam == SIZE_MINIMIZED )
        PostMessage( Parent->HWindow, WM_HIDEDLG, 0, 0 );
    DefWndProc( msg );
}


void TMainDialog::WMClose( RTMessage msg )
{
    (( PTMainWindow )Parent )->pInfoDlg = NULL; // Clear Parent's Pointer         
    TDialog::WMClose( msg );
}

    
void TMainDialog::FillTaskInfo()
{
    TASKENTRY te;
    int nIndex = 0;
    char szTmp[100];

    // Disable updating of listbox entries
    SendMessage( pLBTaskList->HWindow, WM_SETREDRAW, FALSE, 0 );

    // Clear all current entries in listbox
    pLBTaskList->ClearList();                        

    // Fill listbox with Task Information
    if ( _TaskFirst( &te ) == TRUE )
       do {
           wsprintf( szTmp, "%-8s   %04X    %04X     %04X     %04X",
                 ( LPSTR )te.szModule,
                 te.hTask, te.hTaskParent,
                 te.hInst, te.hModule );
           pLBTaskList->AddString( szTmp );
           ListBox_SetItemData( pLBTaskList->HWindow, nIndex++, 
                                te.hTask );
       } while ( _TaskNext( &te ));
    
    // Enable updating of new listbox information
    SendMessage( pLBTaskList->HWindow, WM_SETREDRAW, TRUE, 0 );
}



void TApp::InitMainWindow()
{
    BWCCGetVersion();
    MainWindow = new TMainWindow( NULL, szTitle );
}



int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
    TApp App ( "Sample App", hInstance, hPrevInstance,
               lpCmdLine, SW_SHOWMINIMIZED );
    App.Run();
    return( App.Status );
}
