#include <windows.h>
#include "toolbar.h"

static HWND tbhwnd1, tbhwnd2, cbhwnd;

static TOOLBARICON tbar1[] = {
    { 2, 200, 6, 24, 24, 1, 0, NULL, "Kana_Undep", "Kana_Dep", "Kana_Grayed", "Kana_Pressed" },
    { 1, 230, 6, 24, 24, 0, 0, NULL, "Ascii_Undep", "Ascii_Dep", "Ascii_Grayed", "Ascii_Pressed" },
    { 9, 270, 6, 24, 24, 0, 1, "CVT_Disabled", "CVT_Undep", NULL, NULL, "CVT_Pressed" },
    { 3, 310, 6, 24, 24, -1, 3, "Bold_Disabled", "Bold_Undep", "Bold_Dep", "Bold_Grayed", "Bold_Pressed" },
    { 4, 340, 6, 24, 24, -1, 3, "Italics_Disabled", "Italics_Undep", "Italics_Dep", "Italics_Grayed", "Italics_Pressed" },
    { 5, 370, 6, 24, 24, 0, 3, "Und_Disabled", "Und_Undep", "Und_Dep", "Und_Grayed", "Und_Pressed" },
    { 6, 400, 6, 24, 24, 0, 3, "Rev_Disabled", "Rev_Undep", "Rev_Dep", "Rev_Grayed", "Rev_Pressed" }
};
static TOOLBARICON tbar2[] = {
    { 7, 200, 6, 24, 24, 1, 0, "LR_Disabled", "LR_Undep", "LR_Dep", "LR_Grayed", "LR_Pressed" },
    { 8, 230, 6, 24, 24, 0, 0, "UD_Disabled", "UD_Undep", "UD_Dep", "UD_Grayed", "UD_Pressed" }
};

long FAR PASCAL MainWinProc (HWND, WORD, WORD, LONG);

int PASCAL WinMain (HANDLE hThisInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
	MSG         msg;
	WNDCLASS    wndclass;
    HWND        hwnd;
    RECT        rect;


    /* Register window classes */

    if (!hPrevInstance) {
        wndclass.style          = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc    = MainWinProc;
		wndclass.cbClsExtra     = 0;
		wndclass.cbWndExtra     = 0;
        wndclass.hInstance      = hThisInstance;
		wndclass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
		wndclass.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground  = COLOR_APPWORKSPACE + 1;
        wndclass.lpszMenuName   = NULL;
        wndclass.lpszClassName  = "Frame";

		RegisterClass(&wndclass);
	}

    hwnd = CreateWindow("Frame", "Toolbar Test",
                        WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        CW_USEDEFAULT, CW_USEDEFAULT,
						NULL, NULL, hThisInstance, NULL);

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

    GetClientRect(hwnd, &rect);

    tbhwnd1 = CreateToolbar (hwnd, 0, 0, rect.right, 36, 1, 42, 7, hThisInstance, tbar1, "X_Cursor");
    tbhwnd2 = CreateToolbar (hwnd, 0, 36, rect.right, 36, 1, 43, 2, hThisInstance, tbar2, "X_Cursor");
    cbhwnd = CreateWindow("combobox", "Hello", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST,
                            8, 6, 160, 200, tbhwnd1, 127, hThisInstance, NULL);


	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (msg.wParam);
}


long FAR PASCAL MainWinProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	int i, j;
	char buffer[256];

	/* Takes care of menu items */

	switch (message) {

    case WM_KEYDOWN:
        if (wParam == VK_F2) {
            i = SendMessage(tbhwnd1, BM_GETSTATE, 0, 1L);
            if (i) i = 1;
            SendMessage(tbhwnd1, BM_SETSTATE, !i, 1L);
            SendMessage(tbhwnd1, BM_SETSTATE, i, 2L);
            EnableToolbarButton(tbhwnd1, 3, !i);
            EnableToolbarButton(tbhwnd1, 4, !i);
            EnableToolbarButton(tbhwnd1, 6, i);
            break;
        }
        return (0);

	case WM_COMMAND:
        sprintf(buffer, "WM_COMMAND, Toolbar:%d, Button:%d, lParam%08lx (%s)", LOBYTE(wParam), HIBYTE(wParam),
                lParam, (HIWORD(lParam) == BN_CLICKED) ? "Clicked" : "Something else");
        SetWindowText(hwnd, buffer);

        j = HIBYTE(wParam);

		switch (j) {
            case 1: i = SendMessage(tbhwnd1, BM_GETSTATE, 0, (LONG) j);
                    if (i) break;
                    SendMessage(tbhwnd1, BM_SETSTATE, TRUE, 1L);
                    SendMessage(tbhwnd1, BM_SETSTATE, FALSE, 2L);
                    EnableToolbarButton(tbhwnd1, 3, TRUE);
                    EnableToolbarButton(tbhwnd1, 4, TRUE);
                    EnableToolbarButton(tbhwnd1, 6, FALSE);
					break;
            case 2: i = SendMessage(tbhwnd1, BM_GETSTATE, 0, (LONG) j);
                    if (i) break;
                    SendMessage(tbhwnd1, BM_SETSTATE, FALSE, 1L);
                    SendMessage(tbhwnd1, BM_SETSTATE, TRUE, 2L);
                    EnableToolbarButton(tbhwnd1, 3, FALSE);
                    EnableToolbarButton(tbhwnd1, 4, FALSE);
                    EnableToolbarButton(tbhwnd1, 6, TRUE);
                    break;
            case 7:
            case 8:
                    i = SendMessage(tbhwnd2, BM_GETSTATE, 0, (LONG) j);
                    if (i) break;
                    SendMessage(tbhwnd2, BM_SETSTATE, TRUE, (LONG) j);
                    SendMessage(tbhwnd2, BM_SETSTATE, FALSE, (j == 7) ? 8L : 7L);
					break;
        }
        return (0);

	case WM_DESTROY:
		PostQuitMessage(0);
		return (0);
	}

    return (DefWindowProc(hwnd, message, wParam, lParam));
}
