#include <windows.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <mydef.h>

#define CR 0x0d
#define LF 0x0a
#define BS 0x08


#define IDM_ABOUT     0x100               /* menu id's */
#define IDM_FILE      0x101

#define IDC_INVISIBLE 0x200

#define IDC_LISTBOX   0x201
#define IDC_PATH      0x202
#define IDC_TEXT      0x203
#define IDC_RECT      0x204

#define XORIGIN 0
#define YORIGIN 0

#define PAGES               1
#define LINELENGTH          128
#define LINESPERPAGE        50
#define MAXLINES            LINESPERPAGE * PAGES

typedef struct
     {
     WORD wVirtKey;
     int  iMessage;
     WORD wRequest;
     } KeyStruct;

typedef struct
    {
    WORD Reserved;
    WORD ResourceType;
    WORD ResourceCount;
    } ICONFILEHDR;

typedef struct
    {
    BYTE Width;
    BYTE Height;
    BYTE ColorCount;
    BYTE Reserved1;
    WORD Reserved2;
    WORD Reserved3;
    DWORD DIBSize;
    DWORD DIBOffset;
    } ICONDIRECTORY;
typedef ICONDIRECTORY FAR *LPICONDIRECTORY;



/*-------------------------------------------------------------- VI.C         */
int PASCAL WinMain                (HANDLE Inst ,HANDLE hPrevInst ,LPSTR lpCmdLine ,int nCmdShow );
BOOL      AppInit                 (HANDLE hInstance );
long FAR PASCAL AppWndProc        (HWND hWnd ,uint message ,WORD wParam ,LONG lParam );
void      AppCommand              (WORD wParam );
void      VerticalScrollProcess   (WORD wParam ,LONG lParam );
BOOL FAR PASCAL AppAbout          (HWND hDlg ,uint message ,WORD wParam ,LONG lParam );
BOOL FAR PASCAL AppDlgProc        (HWND hDlg ,uint message ,WORD wParam ,LONG lParam );
void      UpdateListBox           (HWND hDlg );
WORD      GetListBoxIndex         (HWND hDlg );
void      StartApplication        (void );
void      Message                 (uchr *fmt_string ,...);
void      MakeFileList            (void );
void      AdjustScrollBar         (void );
void      DisplayIconBitMap       (HANDLE hBuf ,uint xLoc ,uint yLoc );
HANDLE    GetIconBitMap           (LPSTR FileName );
void      ViewIcons               (HDC hDC );
void      ViewIconRow             (HDC hDC ,int row );
void      ShowIcon                (uchr *FileName ,uint xLoc ,uint yLoc );


