///////////////////////////////////////////////////////////
//  Program Name: Button1.cpp
//  Programmer: Charlie Calvert                                        
//  Description: Simple Button Example
//  Date: 12/19/93
///////////////////////////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// Controls IDs
#define ID_BUTTON 101

// Declarations for class Button1
#define Button1_DefProc    DefWindowProc
BOOL Button1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void Button1_OnDestroy(HWND hwnd);
void Button1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
static char szAppName[] = "Button1";
static HWND MainWindow;
static HINSTANCE hInstance;


// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;
  
  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;  

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    TranslateMessage(&Msg);
    DispatchMessage(&Msg);
  } 

  return Msg.wParam;
}


//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style      	 = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc	 = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName	 = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}


//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Button1_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Button1_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, Button1_OnCommand);
    default: return Button1_DefProc(hwnd, Message, wParam, lParam);
  }
}


//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Button1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  CreateWindow("button", "Click on this Big Button",
               WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
               10, 7, 403, 238, hwnd, HMENU(ID_BUTTON),
               hInstance, NULL);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void Button1_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void Button1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  switch (id)
  {
    case ID_BUTTON:
      MessageBox(hwnd, "You pressed the button",
                 "Button Selection!", MB_OK | MB_ICONEXCLAMATION);
      break;
  }
}