///////////////////////////////////////////////////////////
//  Program Name: ChkBox1.cpp
//  Programmer: Charlie Calvert                                        
//  Description: Simple Edit Example
//  Date: 12/19/93
///////////////////////////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#pragma warning (disable: 4068)
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// Controls IDs
#define ID_CHECKBOX 101
#define ID_CLEARBUTTON 102
#define ID_SETBUTTON 103
#define ID_GETBUTTON 104

// Declarations for class ChkBox1
#define ChkBox1_DefProc    DefWindowProc
BOOL ChkBox1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void ChkBox1_OnDestroy(HWND hwnd);
void ChkBox1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
static char szAppName[] = "ChkBox1";
static HWND MainWindow;
static HINSTANCE hInstance;


// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;
  
  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;  

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    TranslateMessage(&Msg);
    DispatchMessage(&Msg);
  } 

  return Msg.wParam;
}


//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style      	 = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc	 = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName	 = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}


//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, ChkBox1_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, ChkBox1_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, ChkBox1_OnCommand);
    default: return ChkBox1_DefProc(hwnd, Message, wParam, lParam);
  }
}


//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL ChkBox1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  CreateWindow("button", "Clear Button",
               WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
               10, 7, 120, 30, hwnd, HMENU(ID_CLEARBUTTON),
               hInstance, NULL);

  CreateWindow("button", "Set Button",
               WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
               140, 7, 120, 30, hwnd, HMENU(ID_SETBUTTON),
               hInstance, NULL);

  CreateWindow("button", "Button Status",
               WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
               270, 7, 120,30, hwnd, HMENU(ID_GETBUTTON),
               hInstance, NULL);

  CreateWindow("button", "Generic CheckBox",
               WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX,
               10, 50, 410, 30, hwnd, HMENU(ID_CHECKBOX),
               hInstance, NULL);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void ChkBox1_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void ChkBox1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  char S[100];

  switch (id)
  {
    case ID_SETBUTTON:
      Button_SetCheck(GetDlgItem(hwnd, ID_CHECKBOX), 1);
      break;

    case ID_CLEARBUTTON:
      Button_SetCheck(GetDlgItem(hwnd, ID_CHECKBOX), 0);
      break;

    case ID_GETBUTTON:
      int Result = Button_GetCheck(GetDlgItem(hwnd, ID_CHECKBOX));
      if (Result == 0)
        strcpy(S, "Button not Checked");
      else
        strcpy(S, "Button Checked");
      MessageBox(hwnd, S, "Button Status", MB_OK | MB_ICONINFORMATION);
      break;
  }
}