///////////////////////////////////////////////////////////
//  Program Name: Edit1.cpp
//  Programmer: Charlie Calvert                                        
//  Description: Simple Edit Example
//  Date: 12/19/93
///////////////////////////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// Controls IDs
#define ID_EDIT 101
#define ID_GETTEXT 102
#define ID_SETTEXT 103

// Declarations for class Edit1
#define Edit1_DefProc    DefWindowProc
BOOL Edit1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void Edit1_OnDestroy(HWND hwnd);
void Edit1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
static char szAppName[] = "Edit1";
static HWND MainWindow;
static HINSTANCE hInstance;


// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;
  
  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;  

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    TranslateMessage(&Msg);
    DispatchMessage(&Msg);
  } 

  return Msg.wParam;
}


//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style      	 = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc	 = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName	 = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}


//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Edit1_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Edit1_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, Edit1_OnCommand);
    default: return Edit1_DefProc(hwnd, Message, wParam, lParam);
  }
}


//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Edit1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  CreateWindow("button", "Get Text",
               WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
               10, 7, 200, 30, hwnd, HMENU(ID_GETTEXT),
               hInstance, NULL);

  CreateWindow("button", "Set Text",
               WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
               220, 7, 200, 30, hwnd, HMENU(ID_SETTEXT),
               hInstance, NULL);

  CreateWindow("edit", "Original Text",
               WS_CHILD | WS_VISIBLE | WS_BORDER |
               ES_LEFT | ES_AUTOHSCROLL,
               10, 50, 410, 30, hwnd, HMENU(ID_EDIT),
               hInstance, NULL);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void Edit1_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void Edit1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  char S[100];

  switch (id)
  {
    case ID_SETTEXT:
      Edit_SetText(GetDlgItem(hwnd, ID_EDIT), "New Text");
      break;

    case ID_GETTEXT:
      Edit_GetText(GetDlgItem(hwnd, ID_EDIT), S, 100);
      MessageBox(hwnd, S, "You Entered", MB_OK | MB_ICONEXCLAMATION);
      break;
  }
}