///////////////////////////////////////////////////////////
//  Program Name: RadBtn1.cpp
//  Programmer: Charlie Calvert                                        
//  Description: RadioButtons and Tabbing Example
//               Tabbing comes from IsDialogMessage
//  Date: 12/19/93
///////////////////////////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#pragma warning (disable: 4068)
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// Controls IDs
#define ID_RADBTN1 101
#define ID_RADBTN2 102
#define ID_SETBUTTON1 103
#define ID_SETBUTTON2 104
#define ID_GETBUTTON 105

// Declarations for class RadBtn1
#define RadBtn1_DefProc    DefWindowProc
BOOL RadBtn1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void RadBtn1_OnDestroy(HWND hwnd);
void RadBtn1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
static char szAppName[] = "RadBtn1";
static HWND MainWindow;
static HINSTANCE hInstance;


// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;
  
  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;  

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    if (!IsDialogMessage(MainWindow, &Msg))
    {
      TranslateMessage(&Msg);
      DispatchMessage(&Msg);
    }
  } 

  return Msg.wParam;
}


//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style      	 = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc	 = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName	 = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}


//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, "RadioButtons and Tabbing",
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, RadBtn1_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, RadBtn1_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, RadBtn1_OnCommand);
    default: return RadBtn1_DefProc(hwnd, Message, wParam, lParam);
  }
}


//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL RadBtn1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  CreateWindow("button", "Set Button 1",
	       WS_CHILD | WS_VISIBLE | WS_GROUP |
               WS_TABSTOP | BS_PUSHBUTTON,
               10, 7, 120, 30, hwnd, HMENU(ID_SETBUTTON1),
               hInstance, NULL);

  CreateWindow("button", "Set Button 2",
               WS_CHILD | WS_VISIBLE |
               WS_TABSTOP | BS_PUSHBUTTON,
               140, 7, 120, 30, hwnd, HMENU(ID_SETBUTTON2),
               hInstance, NULL);

  CreateWindow("button", "Button Status",
               WS_CHILD | WS_VISIBLE |
               WS_TABSTOP | BS_DEFPUSHBUTTON,
               270, 7, 120,30, hwnd, HMENU(ID_GETBUTTON),
               hInstance, NULL);

  CreateWindow("button", "GroupBox with Auto-Tabbing",
               WS_CHILD | WS_VISIBLE | BS_GROUPBOX,
               10, 50, 320, 90, hwnd, NULL,
               hInstance, NULL);

  HWND GWnd = CreateWindow("button", "Generic CheckBox1",
	       WS_CHILD | WS_VISIBLE | WS_GROUP |
	       WS_TABSTOP | BS_AUTORADIOBUTTON,
               20, 70, 200, 30, hwnd, HMENU(ID_RADBTN1),
               hInstance, NULL);

  CreateWindow("button", "Generic CheckBox2",
               WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON,
               20, 100, 200, 30, hwnd, HMENU(ID_RADBTN2),
               hInstance, NULL);
  
  Button_SetCheck(GWnd, 1);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void RadBtn1_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void RadBtn1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  char S[100];

  switch (id)
  {
    case ID_SETBUTTON1:
      CheckRadioButton(hwnd, ID_RADBTN1, ID_RADBTN2, ID_RADBTN1);
      break;

    case ID_SETBUTTON2:
      CheckRadioButton(hwnd, ID_RADBTN1, ID_RADBTN2, ID_RADBTN2);
      break;

    case ID_GETBUTTON:
      int Result = Button_GetCheck(GetDlgItem(hwnd, ID_RADBTN1));
      if (Result == 0)
        strcpy(S, "First Button not Checked");
      else
        strcpy(S, "First Button Checked");
      MessageBox(hwnd, S, "Button Status", MB_OK | MB_ICONINFORMATION);
      break;
  }
}