///////////////////////////////////
//  Program Name: Figs.cpp
//  Programmer: Charlie Calvert                                        
//  Description: Figs windows program
//  Date: 7/22/92
////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
// ---------------------------------
// Interface
// ---------------------------------

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// Declarations for class Figs
#define Figs_DefProc    DefWindowProc
void Figs_OnDestroy(HWND hwnd);
void Figs_OnPaint(HWND hwnd);

static char szAppName[] = "Figs";
static HWND MainWindow;
static HINSTANCE hInstance;


// ---------------------------------
// Initialization
// ---------------------------------

////////////////////////////////////
// Program entry point
////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;  

  while (GetMessage(&Msg, NULL, 0, 0))
  {
	TranslateMessage(&Msg);
	DispatchMessage(&Msg);
  } 

  return Msg.wParam;
}

//////////////////////////////////
// Register the window
//////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style      	 = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc	 = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName	 = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}

///////////////////////////////////
// Create the window
///////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
		            NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

/////////////////////////////////////////////////////////
// The Window Procedure
/////////////////////////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_DESTROY, Figs_OnDestroy);
    HANDLE_MSG(hwnd, WM_PAINT, Figs_OnPaint);
    default: return Figs_DefProc(hwnd, Message, wParam, lParam);
  }
}

////////////////////////////////////
// Handle WM_DESTROY
////////////////////////////////////
#pragma argsused
void Figs_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

////////////////////////////////////
// Handle WM_PAINT
////////////////////////////////////
void Figs_OnPaint(HWND hwnd)
{
  HDC PaintDC;
  PAINTSTRUCT PaintStruct;

  PaintDC = BeginPaint(hwnd, &PaintStruct);

  HBRUSH GreenBrush = CreateSolidBrush(RGB(0, 127, 0));
  HPEN RedPen = CreatePen(PS_INSIDEFRAME, 10, RGB(255, 0, 0));
  HBRUSH OldBrush = SelectBrush(PaintDC, GreenBrush);
  HPEN OldPen = SelectPen(PaintDC, RedPen);

  Rectangle(PaintDC, 10, 10, 100, 100);
  Ellipse(PaintDC, 150, 10, 250, 100);
  RoundRect(PaintDC, 300, 10, 450, 100, 40, 80);
  Pie(PaintDC, 10, 150, 100, 240, 10, 150, 50, 200);
  Chord(PaintDC, 150, 150, 250, 240, 150, 150, 200, 200);

  const int NumPoints = 3;

  POINT P[NumPoints];
  P[0].x = 300;
  P[0].y = 240;
  P[1].x = 375;
  P[1].y = 150;
  P[2].x = 450;
  P[2].y = 240;

  Polygon(PaintDC, P, NumPoints);
   
  SelectBrush(PaintDC, OldBrush);
  SelectPen(PaintDC, OldPen);
  DeleteObject(RedPen);
  DeleteObject(GreenBrush);

  EndPaint(hwnd, &PaintStruct);
}
