//////////////////////////////////////
// Module: FileBox.h
// Programmer: Charlie Calvert
// Date 06/25/93
//////////////////////////////////////
//////////////////////////////////////
// Constants
#define ID_DRIVES 0
#define ID_DIRS 1
#define ID_FILES 2
#define ID_CLOSE 3
#define ID_FILELIST 4
#define ID_GROUP 5
#define ID_EDIT 6
#define ID_PATHS 7

#define BMPX 365
#define BMPY 100

#define XSIZE 403
#define YSIZE 360

// Types
enum TCurMode {DRIVEMODE, DIRMODE, FILEMODE};

// Declarations for class FileBox
#define FileBox_DefProc    DefWindowProc
BOOL CopyAll_OnCreate(HWND hwnd,
                       CREATESTRUCT FAR* lpCreateStruct);
void FileBox_OnDestroy(HWND hwnd);
void FileBox_OnClose(HWND hwnd);
void FileBox_OnCommand(HWND hwnd, int id,
                       HWND hwndCtl, UINT codeNotify);
void FileBox_OnGetMinMaxInfo(HWND hwnd,
                       MINMAXINFO FAR* lpMinMaxInfo);
void FileBox_OnPaint(HWND hwnd);
void FileBox_OnParentNotify(HWND hwnd, UINT msg,
                       HWND hwndChild, int idChild);
void FileBox_OnRButtonDown(HWND hwnd, BOOL fDoubleClick,
                       int x, int y, UINT keyFlags);

// Funcs
LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                   WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export NewEditProc(HWND hWindow, UINT Message,
                                   WPARAM wParam, LPARAM lParam);
void HandleRightButton(HWND hwnd);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
TCurMode DirShowType;
WNDPROC OldEditProc;
