//////////////////////////////////////
//  Program Name: FONTSTR.CPP
//  Programmer: Charlie Calvert
//  Description: Create description of a font
//  Date: 06/20/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>


// variables
TEXTMETRIC TextMetrics;
static char TheFaceName[80];

// procs
char * GetType(char * S);
char * GetFamily(char * S);
char * GetCharSet(char * S);

char * GetFontString(char * S, TEXTMETRIC TextMetric, char * FaceName)
{
  char szType[99], szFamily[99], szCharSet[99];

  TextMetrics = TextMetric;
  strcpy(TheFaceName, FaceName);

  GetType(szType);
  GetFamily(szFamily);
  GetCharSet(szCharSet);

  sprintf(S, "Font: %s \n Height: %d \n "
             "Ascent: %d \n Descent: %d \n "
             "AveCharW: %d \n MaxCharW: %d \n "
             "Weight: %d \n Italic: %hd \n "
             "Underlined: %d \n"
             "%s \n %s \n %s ",
  TheFaceName,
  TextMetrics.tmHeight,
  TextMetrics.tmAscent,
  TextMetrics.tmDescent,
  TextMetrics.tmAveCharWidth,
  TextMetrics.tmMaxCharWidth,
  TextMetrics.tmWeight,
  TextMetrics.tmItalic,
  TextMetrics.tmUnderlined,
  szType, szFamily, szCharSet);

  return S;
}

char * GetType(char * S)
{
  strcpy(S, "Font Type: ");

  if ((TextMetrics.tmPitchAndFamily & TMPF_FIXED_PITCH) ==
       TMPF_FIXED_PITCH)
  strcat(S, "Fixed <> ");
  if ((TextMetrics.tmPitchAndFamily & TMPF_VECTOR) == TMPF_VECTOR)
  strcat(S, "Vector <> ");
  if ((TextMetrics.tmPitchAndFamily & TMPF_TRUETYPE) == TMPF_TRUETYPE)
  strcat(S, "TrueType <> ");
  if ((TextMetrics.tmPitchAndFamily & TMPF_DEVICE) == TMPF_DEVICE)
  strcat(S, "Device <> ");

  if (strlen(S) > 11)
    S[strlen(S) - 3] = '\0';

  return S;
}

char * GetFamily(char * S)
{
  int R = TextMetrics.tmPitchAndFamily & 0XF0;
  strcpy(S, "Family: ");
  if (R == FF_DONTCARE)
    strcat(S, "Don't Care or don't know");
  if (R == FF_ROMAN)
    strcat(S, "Roman");
  if (R == FF_SWISS)
    strcat(S, "Swiss");
  if (R == FF_MODERN)
    strcat(S, "Modern");
  if (R == FF_SCRIPT)
    strcat(S, "Script");
  if (R == FF_DECORATIVE)
    strcat(S, "Decorative");

  return S;
}

char * GetCharSet(char * S)
{
  strcpy(S, "Char Set: ");

  if (TextMetrics.tmCharSet == ANSI_CHARSET)
    strcat(S, "Ansi");
  if (TextMetrics.tmCharSet == DEFAULT_CHARSET)
    strcat(S, "Default");
  if (TextMetrics.tmCharSet == SYMBOL_CHARSET)
    strcat(S, "Symbol");
  if (TextMetrics.tmCharSet == OEM_CHARSET)
    strcat(S, "OEM");

  return S;
}
