//////////////////////////////////////
// Program: CDINFO.CPP
// Programmer: Charlie Calvert
// Date: August 6, 1993
// Description: DLL Module from Harmony program
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <stdio.h>
#include <string.h>
#pragma warning (disable : 4068)

static HWND PlayWindow;
static WORD wDeviceID;
#define MsgLen 200


//////////////////////////////////////
// LibMain
//////////////////////////////////////
#pragma argsused
int CALLBACK LibMain(HINSTANCE hInstance, WORD wDataSeg,
                     WORD wHeapSize, LPSTR lpszCmdLine)
{
  if (wHeapSize > 0)
       UnlockData(0);

  return 1;
}

//////////////////////////////////////
// Wep
//////////////////////////////////////
#pragma argsused
int CALLBACK WEP (int nParameter)
{
  return 1;
}

//////////////////////////////////////
// GetErrorMessage
//////////////////////////////////////
LPSTR GetErrorMessage(DWORD RC, LPSTR S)
{
  if (!mciGetErrorString(RC, S, MsgLen))
    strcpy(S, "No message available");
  return S;
}

//////////////////////////////////////
// ErrorMsg
//////////////////////////////////////
BOOL CALLBACK _export ErrorMsg(DWORD Error,
                               LPSTR CallingFunc)
{
  char S[MsgLen + 50];
  char S1[MsgLen];

  GetErrorMessage(Error, S1);
  sprintf(S, "Calling Func: %s\nReturn Code: %ld\n %s",
          CallingFunc, Error, S1);
  if (Error)
  {
    MessageBox(0, S, "Information",
               MB_OK | MB_ICONINFORMATION);
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// OpenCD
//////////////////////////////////////
BOOL CALLBACK _export OpenCD(HWND PWindow)
{
  MCI_OPEN_PARMS Info;
  DWORD Result, Flags;

  memset(&Info, 0, sizeof(MCI_OPEN_PARMS));
  Info.dwCallback = DWORD(PWindow);
  Info.lpstrDeviceType =
                     MAKEINTRESOURCE(MCI_DEVTYPE_CD_AUDIO);
  Flags = MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID;
  Result = mciSendCommand(0, MCI_OPEN, Flags, DWORD(&Info));

  wDeviceID = Info.wDeviceID;

  if (Result)
  {
    ErrorMsg(Result, "OpenCD");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// CloseCDMCI
//////////////////////////////////////
BOOL CALLBACK _export CloseCDMCI(void)
{
  DWORD ErrorNum;
  MCI_GENERIC_PARMS Info;

  memset(&Info, 0, sizeof(MCI_GENERIC_PARMS));
  ErrorNum = mciSendCommand(wDeviceID, MCI_CLOSE,
                            MCI_NOTIFY, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "CloseCDMCI");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// StopCDMCI
//////////////////////////////////////
BOOL CALLBACK _export StopCDMCI(void)
{
  DWORD ErrorNum;
  MCI_GENERIC_PARMS Info;

  Info.dwCallback = 0;
  ErrorNum = mciSendCommand(wDeviceID, MCI_STOP,
                            MCI_NOTIFY, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "StopCDMCI");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// PauseCDMCI
//////////////////////////////////////
BOOL CALLBACK _export PauseCDMCI(void)
{
  MCI_GENERIC_PARMS Info;
  DWORD ErrorNum;
  char S1[MsgLen];

  memset(&Info, 0, sizeof(MCI_GENERIC_PARMS));
  ErrorNum = mciSendCommand(wDeviceID, MCI_PAUSE,
                            0, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "PauseCDMCI");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// SetTMSFasFormat
//////////////////////////////////////
void CALLBACK _export SetTMSFasFormat(void)
{
  MCI_SET_PARMS Info;
  DWORD Result;

  Info.dwCallback = 0;
  Info.dwTimeFormat = MCI_FORMAT_TMSF;
  Info.dwAudio = 0;

  Result = mciSendCommand(wDeviceID, MCI_SET,
                        MCI_SET_TIME_FORMAT, DWORD(&Info));

  if (Result)
    ErrorMsg(Result, "SetTMSFasFormat");
}

//////////////////////////////////////
// PlayCDOneTrack
//////////////////////////////////////
void CALLBACK _export PlayCDOneTrack(BYTE StartTrack)
{
  MCI_PLAY_PARMS Info;
  DWORD Flags, Result;

  memset(&Info, 0, sizeof(MCI_PLAY_PARMS));
  Info.dwFrom = MCI_MAKE_TMSF(StartTrack,0,0,0);

  Flags = MCI_FROM | MCI_NOTIFY;
  Result = mciSendCommand(wDeviceID, MCI_PLAY,
                          Flags, DWORD(&Info));

  if (Result)
    ErrorMsg(Result, "PlayCDOneTrack");
}

//////////////////////////////////////
// PlayMCICD
//////////////////////////////////////
void CALLBACK _export PlayMciCD(BYTE StartTrack, BYTE EndTrack)
{
  MCI_PLAY_PARMS Info;
  DWORD Flags, Result;
  char S1[MsgLen];

  memset(&Info, 0, sizeof(MCI_PLAY_PARMS));
  Info.dwFrom = MCI_MAKE_TMSF(StartTrack,0,0,0);
  Info.dwTo   = MCI_MAKE_TMSF(EndTrack,  0,0,0);

  Flags = MCI_FROM | MCI_TO | MCI_NOTIFY;
  Result = mciSendCommand(wDeviceID, MCI_PLAY,
                          Flags, DWORD(&Info));

  if (Result) ErrorMsg(Result, "PlayCDMCI");
}

//////////////////////////////////////
// GetCDNumTracks
//////////////////////////////////////
DWORD CALLBACK _export GetCDNumTracks(void)
{
  MCI_STATUS_PARMS Info;
  DWORD Result;


  Info.dwCallback = 0;
  Info.dwReturn   = 0;
  Info.dwItem     = MCI_STATUS_NUMBER_OF_TRACKS;
  Info.dwTrack    = 0;
  Result = mciSendCommand(wDeviceID, MCI_STATUS,
                      MCI_STATUS_ITEM, DWORD(&Info));
  if (Result)
  {
    ErrorMsg(Result, "GetCDNumTracks");
    return -1;
  }

  return Info.dwReturn;
}

//////////////////////////////////////
// GetCDTrackLength
//////////////////////////////////////
void CALLBACK _export GetCDTrackLength(DWORD TrackNum,
                       BYTE *Min, BYTE *Sec, BYTE *Frame)
{
  MCI_STATUS_PARMS Info;
  DWORD Result, MSF;
  char MessageText[MsgLen];

  memset(&Info, 0, sizeof(MCI_STATUS_PARMS));
  Info.dwTrack    = TrackNum;
  Info.dwItem     = MCI_STATUS_LENGTH;

  Result = mciSendCommand(wDeviceID, MCI_STATUS,
                     MCI_STATUS_ITEM | MCI_TRACK,
                     DWORD(&Info));

  if (Result)
  {
    ErrorMsg(Result, "GetCDTrackLength");
    return;
  }

  MSF =Info.dwReturn;

  *Min = MCI_MSF_MINUTE(MSF);
  *Sec = MCI_MSF_SECOND(MSF);
  *Frame = MCI_MSF_FRAME(MSF);
}

//////////////////////////////////////
// GetLengthofEachTrack
//////////////////////////////////////
void CALLBACK _export GetLengthOfEachTrack(DWORD TrackNum, BYTE *Min, 
                                           BYTE *Sec, BYTE *Frame)
{
  MCI_STATUS_PARMS Info;
  DWORD Result, Flags, MSF;

  memset(&Info, 0, sizeof(MCI_STATUS_PARMS));
  Info.dwTrack = TrackNum;
  Info.dwItem = MCI_STATUS_LENGTH;
  Flags = MCI_STATUS_ITEM | MCI_TRACK;
  Result = mciSendCommand(wDeviceID, MCI_STATUS,
                          Flags, DWORD(&Info));

  if (Result)
  {
    ErrorMsg(Result, "GetLengthOfEachTrack");
    return;
  }

  MSF = Info.dwReturn;
  *Min = MCI_MSF_MINUTE(MSF);
  *Sec = MCI_MSF_SECOND(MSF);
  *Frame = MCI_MSF_FRAME(MSF);
}

//////////////////////////////////////
// GetCurrentCDTrack
//////////////////////////////////////
DWORD CALLBACK _export GetCurrentCDTrack(void)
{
  MCI_STATUS_PARMS Info;
  DWORD Result;

  memset(&Info, 0, sizeof(MCI_STATUS_PARMS));
  Info.dwItem     = MCI_STATUS_CURRENT_TRACK;

  Result = mciSendCommand(wDeviceID, MCI_STATUS,
                       MCI_STATUS_ITEM, DWORD(&Info));

  if (Result)
  {
    ErrorMsg(Result, "GetCurrentCDTrack");
    return FALSE;
  }
  return Info.dwReturn;
}

//////////////////////////////////////
// HasDiskInserted
//////////////////////////////////////
BOOL CALLBACK _export HasDiskInserted(void)
{
  MCI_STATUS_PARMS Info;
  DWORD Flags, Result;

  memset(&Info, 0, sizeof(MCI_STATUS_PARMS));
  Info.dwItem = MCI_STATUS_MEDIA_PRESENT;

  Flags = MCI_STATUS_ITEM;
  Result=mciSendCommand(wDeviceID, MCI_STATUS,
                        Flags, DWORD(&Info));

  if (Result)
  {
    ErrorMsg(Result, "HasDiskInserted");
    return FALSE;
  }

  return Info.dwReturn > 0;
}

//////////////////////////////////////
// EjectCD
//////////////////////////////////////
void CALLBACK _export EjectCD(void)
{
  MCI_SET_PARMS Info;
  DWORD Flags, Result;

  memset(&Info, 0, sizeof(MCI_SET_PARMS));
  Flags = MCI_SET_DOOR_OPEN;
  Result = mciSendCommand( wDeviceID, MCI_SET,
                           Flags, DWORD(&Info));
  if (Result)
    ErrorMsg(Result, "EjectCD");
}

//////////////////////////////////////
// GetCDLocation
//////////////////////////////////////
DWORD CALLBACK _export GetCDLocation(void)
{
  MCI_STATUS_PARMS Info;
  DWORD Flags, ErrorNum;

  Info.dwItem = MCI_STATUS_POSITION;
  Flags = MCI_STATUS_ITEM;
  ErrorNum = mciSendCommand(wDeviceID, MCI_STATUS,
                            Flags, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "GetLocation");
    return -1;
  }
  return Info.dwReturn;
}
