# HARMONY.MAK

APPNAME = Harmony
INCPATH = C:\BC\INCLUDE
LIBPATH = C:\BC\LIB
PATHS = -I$(INCPATH) -L$(LIBPATH)
FLAGS = -H -R -ml -2 -W -v -w4 -vi- -wpro -weas -wpre
DLLFLAGS = -ml -R -WDE -2 -v  -wpro -weas -wpre
LIBS = PlayInfo.lib CDInfo.lib
OBJS = Harmony.obj WaveMidi.obj CDUtil.obj

# goal
ALL: PlayInfo.dll CDInfo.dll $(APPNAME).exe

# link EXES
$(APPNAME).exe: $(OBJS) $(APPNAME).def $(LIBS) $(APPNAME).res
  bcc $(FLAGS) $(OBJS) $(LIBS)
  rc $(APPNAME).res

# link DLLS
playinfo.dll: playinfo.obj playinfo.def
  bcc $(DLLFLAGS) $(PATHS) playinfo.obj

cdinfo.dll: cdinfo.obj cdinfo.def
  bcc $(DLLFLAGS) $(PATHS) cdinfo.obj

# compile
$(APPNAME).obj: $(APPNAME).cpp
  bcc -c $(FLAGS) $(PATHS) $(APPNAME).cpp

# compile
CDUtils.obj: CDUtils.cpp
  bcc -c $(FLAGS) $(PATHS) CDUtils.cpp

# compile
WaveMidi.obj: WaveMidi.cpp
  bcc -c $(FLAGS) $(PATHS) WaveMidi.cpp

# compile
.cpp.obj:
  bcc -c $(DLLFLAGS) $(PATHS) { $< }

# resource
.rc.res:
  brc -r $(PATHS) { $< }

# libraries
.dll.lib:
  implib $&.lib $&.dll
