//////////////////////////////////////
// Program: PLAYINFO.CPP
// Programmer: Charlie Calvert
// Date: August 6, 1993
// Description: DLL Module from Harmony program
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <stdio.h>
#include <string.h>
#include "playinfo.h"
#pragma warning (disable : 4068)
#pragma argsused

//////////////////////////////////////
// LibMain
//////////////////////////////////////
int CALLBACK LibMain(HINSTANCE hInstance, WORD wDataSeg,
                     WORD wHeapSize, LPSTR lpszCmdLine)
{
  if (wHeapSize > 0)
       UnlockData(0);

  return 1;
}

//////////////////////////////////////
// WEP
//////////////////////////////////////
#pragma argsused
int CALLBACK WEP (int nParameter)
{
  return 1;
}

//////////////////////////////////////
// GetDeviceID
//////////////////////////////////////
WORD CALLBACK _export GetDeviceID(void)
{
  return wDeviceID;
}

//////////////////////////////////////
// GetErrorMessage
//////////////////////////////////////
LPSTR GetErrorMessage(DWORD RC, LPSTR S)
{
  if (!mciGetErrorString(RC, S, MsgLen))
    strcpy(S, "No message available");
  return S;
}

//////////////////////////////////////
// ErrorMs
//////////////////////////////////////
BOOL CALLBACK _export ErrorMsg(DWORD Error, LPSTR CallingFunc)
{
  char S[MsgLen + 50];
  char S1[MsgLen];

  GetErrorMessage(Error, S1);
  sprintf(S, "Calling Func: %s\nReturn Code: %ld\n %s",
          CallingFunc, Error, S1);
  if (Error)
  {
    MessageBox(0, S, "Information", MB_OK | MB_ICONINFORMATION);
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// CloseMCI
//////////////////////////////////////
BOOL CALLBACK _export CloseMCI(void)
{
  DWORD ErrorNum;

  ErrorNum = mciSendCommand(wDeviceID, MCI_CLOSE, 0, 0);
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "CloseMCI");
    return FALSE;
  }
  wDeviceID = 0;
  return TRUE;
}

//////////////////////////////////////
// GetInfo
//////////////////////////////////////
LPSTR CALLBACK _export GetInfo(LPSTR S)
{
  MCI_INFO_PARMS Info;
  DWORD Flags, ErrorNum;

  Info.dwCallback = 0;
  Info.lpstrReturn = S;
  Info.dwRetSize = MsgLen;
  Flags = MCI_INFO_PRODUCT;
  ErrorNum =
    mciSendCommand(wDeviceID, MCI_INFO, Flags, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "GetInfo");
    return NULL;
  }
  return S;
}

//////////////////////////////////////
// GetLen
//////////////////////////////////////
DWORD CALLBACK _export GetLen(void)
{
  MCI_STATUS_PARMS Info;
  DWORD ErrorNum, Flags;

  memset(&Info, 0, sizeof(MCI_STATUS_PARMS));
  Info.dwItem = MCI_STATUS_LENGTH;
  Flags = MCI_STATUS_ITEM;
  ErrorNum =
    mciSendCommand(wDeviceID, MCI_STATUS, Flags, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "GetLen");
    return -1;
  }
  return Info.dwReturn;
}

//////////////////////////////////////
// GetLocation
//////////////////////////////////////
DWORD CALLBACK _export GetLocation(void)
{
  MCI_STATUS_PARMS Info;
  DWORD Flags, ErrorNum;

  Info.dwItem = MCI_STATUS_POSITION;
  Flags = MCI_STATUS_ITEM;
  ErrorNum = mciSendCommand(wDeviceID, MCI_STATUS,
                            Flags, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "GetLocation");
    return -1;
  }
  return Info.dwReturn;
}

//////////////////////////////////////
// GetMode
//////////////////////////////////////
DWORD CALLBACK _export GetMode(void)
{
  MCI_STATUS_PARMS Info;
  DWORD ErrorNum, Flags;

  memset(&Info, 0, sizeof(MCI_STATUS_PARMS));
  Info.dwItem = MCI_STATUS_MODE;
  Flags = MCI_STATUS_ITEM;
  ErrorNum = mciSendCommand(wDeviceID, MCI_STATUS,
                            Flags, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "GetMode");
    return -1;
  }
  return Info.dwReturn;
}

//////////////////////////////////////
// OpenMCI
//////////////////////////////////////
BOOL CALLBACK _export OpenMCI(HWND PWindow, LPSTR FileName,
                              LPSTR DeviceType)
{
  MCI_OPEN_PARMS OpenParms;
  DWORD Style, ErrorNum;

  PlayWindow = PWindow;
  OpenParms.lpstrDeviceType = DeviceType;
  OpenParms.lpstrElementName = FileName;
  Style = MCI_OPEN_TYPE | MCI_OPEN_ELEMENT;
  ErrorNum = mciSendCommand(0, MCI_OPEN,
                            Style, DWORD(&OpenParms));
  if ( ErrorNum)
  {
    ErrorMsg(ErrorNum, "OpenMCI");
    return FALSE;
  }
  wDeviceID = OpenParms.wDeviceID;
  return TRUE;
}

//////////////////////////////////////
// PauseMCI
//////////////////////////////////////
BOOL CALLBACK _export PauseMCI(void)
{
  MCI_GENERIC_PARMS Info;
  DWORD ErrorNum;
  char S1[MsgLen];

  memset(&Info, 0, sizeof(MCI_GENERIC_PARMS));
  ErrorNum = mciSendCommand(wDeviceID, MCI_PAUSE,
                            0, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "PauseMCI");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// PlayMCI
//////////////////////////////////////
BOOL CALLBACK _export PlayMCI(void)
{
  DWORD ErrorNum;
  MCI_PLAY_PARMS Info;

  Info.dwCallback = DWORD(PlayWindow);
  ErrorNum = mciSendCommand(wDeviceID, MCI_PLAY,
                            MCI_NOTIFY, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "PlayMCI");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// SetTimeFormatMS
//////////////////////////////////////
BOOL CALLBACK _export SetTimeFormatMs(void)
{
  MCI_SET_PARMS Info;
  DWORD ErrorNum, Flags;

  Info.dwTimeFormat = MCI_FORMAT_MILLISECONDS;
  Flags = MCI_SET_TIME_FORMAT;
  ErrorNum = mciSendCommand(wDeviceID, MCI_SET,
                            Flags, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "SetTimeFormatMS");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// StopMCI
//////////////////////////////////////
BOOL CALLBACK _export StopMCI(void)
{
  DWORD ErrorNum;
  MCI_GENERIC_PARMS Info;

  Info.dwCallback = 0;
  ErrorNum = mciSendCommand(wDeviceID, MCI_STOP,
                            MCI_NOTIFY, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "StopMCI");
    return FALSE;
  }
  return TRUE;
}


//////////////////////////////////////
// Can a device perform a function such
// as record, or pause, etc.
//////////////////////////////////////
BOOL CALLBACK _export CanPerformFunction(DWORD Test)
{
  DWORD ErrorNum, Flags;
  MCI_GETDEVCAPS_PARMS Info;

  memset(&Info, 0, sizeof(MCI_GENERIC_PARMS));
  Info.dwItem = Test;
  Flags = MCI_GETDEVCAPS_ITEM;
  ErrorNum = mciSendCommand(wDeviceID, MCI_GETDEVCAPS,
                            Flags, DWORD(&Info));
  if (ErrorNum)
  {
    ErrorMsg(ErrorNum, "CanPerformFunction");
    return FALSE;
  }

  return Info.dwReturn > 0;
}

//////////////////////////////////////
// Can this system play "waveaudio", or
// "cdaudio" or "sequencer" etc.
//////////////////////////////////////
BOOL CALLBACK _export DoesDeviceExistOnSystem(LPSTR DeviceType)
{
  DWORD ErrorNum, Flags;
  MCI_OPEN_PARMS Info;

  Info.lpstrDeviceType = DeviceType;
  Flags = MCI_OPEN_TYPE;
  ErrorNum = mciSendCommand(0, MCI_OPEN, Flags, DWORD(&Info));

  if (ErrorNum)
    return FALSE;
  else
  {
    wDeviceID = Info.wDeviceID;
    CloseMCI();
    return TRUE;
  }
}

//////////////////////////////////////
// DoRecord
//////////////////////////////////////
DWORD CALLBACK _export DoRecord(DWORD MMSecs)
{
  MCI_RECORD_PARMS Info;
  DWORD Result, Flags;

  Info.dwCallback = (DWORD)PlayWindow;
  Info.dwTo = MMSecs;
  Flags = MCI_TO | MCI_NOTIFY;
  Result = mciSendCommand(wDeviceID, MCI_RECORD,
                          Flags, DWORD(&Info));
  if (Result)
  {
    ErrorMsg(Result, "DoRecord");
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// SaveFile
//////////////////////////////////////
BOOL CALLBACK _export SaveFile(char *FileName)
{
  MCI_SAVE_PARMS MCISave;
  DWORD Result, Flags;
  char S1[MsgLen];

  MCISave.lpfilename = FileName;
  Flags = MCI_SAVE_FILE | MCI_WAIT;
  Result = mciSendCommand(wDeviceID, MCI_SAVE,
                          Flags, DWORD(&MCISave));
  if (Result)
  {
    ErrorMsg(Result, "SaveFile");
    return FALSE;
  }
  return TRUE;
}
