//////////////////////////////////////
//  Program Name: WAVEMIDI.CPP
//  Programmer: Charlie Calvert
//  Description: Harmony windows program
//  Date: 08/07/93
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <direct.h>
#include <mmsystem.h>
#include <string.h>
#include "harmony.h"
#include "cdinfo.h"
#include "stdio.h"
#include "playinfo.h"

extern BYTE State;
extern BYTE PlayType;
extern char DirStr[DIRSTRSIZE];
extern char DeviceString[DEVICESTRSIZE];

//////////////////////////////////////
// GetFileName
//////////////////////////////////////
BOOL FileOpen(HWND hwnd)
{
  char S[100];
  char S1[200];

  if (State == PAUSED)
    return TRUE;

  S[1] = '\0';
  int Index =
    ListBox_GetCurSel(GetDlgItem(hwnd, ID_FILELIST));
  if (Index == LB_ERR)
  {
    MessageBox(hwnd, "Select a valid file",
               NULL, MB_OK | MB_ICONSTOP);
    return FALSE;
  }
  ListBox_GetText(GetDlgItem(hwnd, ID_FILELIST), Index, S);
  strcpy(S1, DirStr);
  strcat(S1, "\\");
  strcat(S1, S);

  if (!OpenMCI(hwnd, S1, DeviceString))
    return FALSE;
  else
    return TRUE;
}

//////////////////////////////////////
// GetFileName
//////////////////////////////////////
char * GetFileName(HWND hwnd, char * szFile, int StringSize)
{
  OPENFILENAME ofn;
  char szDirName[256];
  char szFileTitle[256];
  char szFilter[256];
  char chReplace;

  memset(&ofn, 0, sizeof(OPENFILENAME));

  strcpy(szFilter,
         "Wave Files(*.wav)|*.wav|MIDI Files(*.mid)|*.mid|");
  chReplace = szFilter[strlen(szFilter) - 1];
  for (int i = 0; szFilter[i] != '\0'; i++)
  {
      if (szFilter[i] == chReplace)
         szFilter[i] = '\0';
  }

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = szFilter;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= szFile;
  ofn.nMaxFile = StringSize;
  ofn.lpstrFileTitle = szFileTitle;
  ofn.nMaxFileTitle = sizeof(szFileTitle);
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_FILEMUSTEXIST;

  GetOpenFileName(&ofn);

  return szFile;
}

//////////////////////////////////////
// LoadFile
//////////////////////////////////////
void LoadFile(HWND hwnd)
{
  char S[100];

  memset(&S, 0, 100);

  if (PlayType == WAVE)
    strcpy(S, "*.wav");
  else
    if (PlayType == MIDI)
      strcpy(S, "*.mid");

  GetFileName(hwnd, S, 100);
  _getdcwd(0, DirStr, DIRSTRSIZE);
}

//////////////////////////////////////
// HandleMIDIPAndS
//////////////////////////////////////
void HandleMIDIPAndS(HWND hwnd, int id)
{
  switch(id)
  {
    case CM_PAUSE:
      State = PAUSED;
      SetWindowText(GetDlgItem(hwnd, ID_MODE), "Paused");
      PauseMCI();
      break;

    case CM_STOP:
      State = CLOSED;
      SetWindowText(GetDlgItem(hwnd, ID_MODE), "Stopped");
      StopMCI();
      CloseMCI();
      break;
  }
}

//////////////////////////////////////
// HandleWAVEPAndS
//////////////////////////////////////
void HandleWAVEPAndS(HWND hwnd, int id)
{
  switch(id)
  {
    case CM_PAUSE:
      State = PAUSED;
      SetWindowText(GetDlgItem(hwnd, ID_MODE), "Paused");
      PauseMCI();
      break;

    case CM_STOP:
      State = CLOSED;
      SetWindowText(GetDlgItem(hwnd, ID_MODE), "Stopped");
      StopMCI();
      CloseMCI();
      break;
  }
}
