// Program MakeWin.cpp
#define  STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>

char Name[] = "MakeWin";
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

#pragma warning (disable: 4068)
#pragma argsused
int pascal WinMain(HINSTANCE hInst,
                   HINSTANCE hPrevInstance, 
                   LPSTR lpszCmdParam, int nCmdShow)
{
  HWND hwnd;
  MSG Msg;
  WNDCLASS W;

  memset(&W, 0, sizeof(WNDCLASS));
  W.style = CS_HREDRAW | CS_VREDRAW;
  W.lpfnWndProc = WndProc;
  W.hInstance = hInst;
  W.hbrBackground = GetStockBrush(WHITE_BRUSH);
  W.lpszClassName = Name;
  RegisterClass(&W);

  hwnd = CreateWindow(Name, Name, WS_OVERLAPPEDWINDOW,
                      10, 10, 600, 400, NULL, NULL, hInst, NULL);

  ShowWindow(hwnd,nCmdShow);
  UpdateWindow(hwnd);

  while (GetMessage(&Msg, NULL, 0, 0))
  {
	TranslateMessage(&Msg);
	DispatchMessage(&Msg);
  } 
  
  return Msg.wParam;
}

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  if (Message == WM_DESTROY)
  {
    PostQuitMessage(0);
    return 0;
  }
  return DefWindowProc(hwnd, Message, wParam, lParam);
}
