//////////////////////////////////////
// Program Name: DRAW.CPP
// Programmer: Charlie Calvert
// Description: Multimedia MDI windows example program
// Date: 07/25/93
//////////////////////////////////////
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <math.h>
#include "draw.h"

#define PI 3.14159265358979323846

//////////////////////////////////////
// Draw the shape
//////////////////////////////////////
void DrawSquare(HDC PaintDC, double Scale, int Theta)
{
  int x1,y1;
  int xt,yt;
  int i;
  HPEN Pens[5], OldPen;
  TCDS CDS;

  Pens[1] = CreatePen(PS_SOLID, 1, RGB(255, 0, 0));
  Pens[2] = CreatePen(PS_SOLID, 1, RGB(0, 255, 0));
  Pens[3] = CreatePen(PS_SOLID, 1, RGB(0, 0, 255));
  Pens[4] = CreatePen(PS_SOLID, 1, RGB(255, 0, 255));

  CDS[0].x = -100;
  CDS[0].y = -100;
  CDS[1].x = 100;
  CDS[1].y = -100;
  CDS[2].x = 100;
  CDS[2].y = 100;
  CDS[3].x = -100;
  CDS[3].y = 100;
  CDS[4].x = -100;
  CDS[4].y = -100;

  for (i = 0; i < 5; i++)
  {
    x1 = CDS[i].x;
    y1 = CDS[i].y;
    xt = x1;
    yt = y1;
    xt = Scale * (x1 * cos(Theta * PI / 180) + y1 *
                  sin(Theta * PI/180));
    yt = Scale * (y1 * cos(Theta * PI / 180) - x1 *
                  sin(Theta * PI/180));
    if (i == 0)
      MoveTo(PaintDC, xt, yt);
    else
    {
      OldPen = SelectPen(PaintDC, Pens[i]);
      LineTo(PaintDC, xt, yt);
      SelectPen(PaintDC, OldPen);
    }
  }
  for (i = 1; i < 5; i++)
    DeleteObject(Pens[i]);
}

//////////////////////////////////////
// Loop through the draw
//////////////////////////////////////
void DoDraw(HDC PaintDC)
{
  double Scale;
  int Theta;
  int Square;

  Scale = 1.0;
  Theta = 0;

  for (Square = 1; Square < 25; Square++)
  {
    DrawSquare(PaintDC, Scale, Theta);
    Theta = Theta + 10;
    Scale = Scale * 0.85;
  }
}
