//////////////////////////////////////
// Program Name: FERN.CPP
// Programmer: Charlie Calvert
// Description: MDI example program
// Date: 07/25/93
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include "draw.h"
#pragma warning(disable : 4068)

int FernTimer = 1;

// constants
double a[4] = {0, 0.85,  0.2,  -0.15};
double b[4] = {0, 0.04, -0.26,  0.28};
double c[4] = {0, -0.04,  0.23,  0.26};
double d[4] = {0.16,  0.85,  0.22,  0.24};
double e[4] = {0,     0,     0,     0};
double f[4] = {0,     1.6,   1.6,   0.44};
double x = 0;
double y = 0;

// variables
static double TempX, TempY;
static int MaxX, MaxY, k;
static long MaxIterations, Count;
static HWND hWndClient, hWndFrame;

// externs
extern HMENU hMenuMultiple, hMenuInit;
extern HMENU hMenuFileMultiple, hMenuFileInit;
extern HACCEL hAccel;

#define FernPlay_DefProc DefMDIChildProc
BOOL FernPlay_OnCreate(HWND hwnd,
                       CREATESTRUCT FAR* lpCreateStruct);
void FernPlay_OnClose(HWND hwnd);
void FernPlay_OnTimer(HWND hwnd, UINT id);
void FernPlay_MDIActivate(HWND hwnd, BOOL fActive,
                          HWND hwndActivate,
                          HWND hwndDeactivate);
BOOL FernPlay_OnQueryEndSession(HWND hwnd);
void FernPlay_OnPaint(HWND hwnd);
void FernPlay_OnSize(HWND hwnd, UINT state, int cx, int cy);

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK FernWndProc(HWND hwnd, UINT message, WPARAM wParam, 
                             LPARAM lParam)
{
  switch (message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, FernPlay_OnCreate);
    HANDLE_MSG(hwnd, WM_CLOSE, FernPlay_OnClose);
    HANDLE_MSG(hwnd, WM_TIMER, FernPlay_OnTimer);
    HANDLE_MSG(hwnd, WM_MDIACTIVATE, FernPlay_MDIActivate);
    HANDLE_MSG(hwnd, WM_PAINT, FernPlay_OnPaint);
    HANDLE_MSG(hwnd, WM_QUERYENDSESSION,
                     FernPlay_OnQueryEndSession);
    HANDLE_MSG(hwnd, WM_SIZE, FernPlay_OnSize);
  default:
    return FernPlay_DefProc(hwnd, message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL FernPlay_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  hWndClient = GetParent (hwnd);
  hWndFrame  = GetParent (hWndClient);
  Count = 0;
  SetTimer(hwnd, FernTimer, 0, NULL);
  return TRUE;
}

//////////////////////////////////////
// Handle WM_MDIACTIVATE
//////////////////////////////////////
#pragma argsused
void FernPlay_MDIActivate(HWND hwnd, BOOL fActive, HWND hwndActivate,
                          HWND hwndDeactivate)
{
  if (fActive)
    SendMessage(hWndClient, WM_MDISETMENU, 0,
                MAKELONG(hMenuMultiple, hMenuFileMultiple));

  if (!fActive)
    SendMessage(hWndClient, WM_MDISETMENU, 0,
                MAKELONG(hMenuInit, hMenuFileInit));
  DrawMenuBar (hWndFrame);
}

//////////////////////////////////////
// Handle WM_CLOSE
//////////////////////////////////////
void FernPlay_OnClose(HWND hwnd)
{
  Count = MaxIterations;
  if (IDOK != MessageBox (hwnd, "OK to close window?",
               "Fern", MB_ICONQUESTION | MB_OKCANCEL))
    return;
  else
    FORWARD_WM_CLOSE(hwnd, FernPlay_DefProc);
}

//////////////////////////////////////
// Handle WM_QUERYENDSESSION
//////////////////////////////////////
BOOL FernPlay_OnQueryEndSession(HWND hwnd)
{
  Count = MaxIterations;
  if (IDOK != MessageBox (hwnd, "OK to close window?",
                "Fern", MB_ICONQUESTION | MB_OKCANCEL))
    return FALSE;
  else
    return TRUE;
}

//////////////////////////////////////
// Handle WM_SIZE
//////////////////////////////////////
#pragma argsused
void FernPlay_OnSize(HWND hwnd, UINT state, int cx, int cy)
{
  RECT R;
  GetClientRect(hwnd, &R);
  MaxX = R.right;
  MaxY = R.bottom;
  MaxIterations = long(MaxY) * 50;
  if (state == SIZE_MINIMIZED)
    MaxIterations = 175;

  // MUST forward WM_SIZE messages
  FORWARD_WM_SIZE(hwnd, state, cx, cy, FernPlay_DefProc);
}

//////////////////////////////////////
// Handle WM_PAINT
//////////////////////////////////////
void FernPlay_OnPaint(HWND hwnd)
{
  Count = 0;
  KillTimer(hwnd, FernTimer);
  SetTimer(hwnd, FernTimer, 0, NULL);
  FORWARD_WM_PAINT(hwnd, FernPlay_DefProc);
}

//////////////////////////////////////
// Paint the fern
//////////////////////////////////////
void DoPaint(HWND hwnd)
{
  HDC PaintDC;
  k = rand() % 100;
  if ((k > 0 ) && (k <= 85))
    k = 1;
  if ((k > 85) && (k <= 92))
    k = 2;
  if (k > 92) k = 3;
  TempX = a[k] * x + b[k] * y + e[k];
  TempY = c[k] * x + d[k] * y + f[k];
  x = TempX;
  y = TempY;
  if ((Count >= MaxIterations) || (Count != 0))
  {
    PaintDC = GetDC(hwnd);
    SetPixel(PaintDC, (x * MaxY / 11 + MaxX / 2),
           (y * -MaxY / 11 + MaxY), RGB(0, 0XFF, 0));
    ReleaseDC(hwnd, PaintDC);
  }
  Count++;
}

//////////////////////////////////////
// Handle WM_TIMER
//////////////////////////////////////
#pragma argsused
void FernPlay_OnTimer(HWND hwnd, UINT id)
{
  if (Count >= MaxIterations)
    KillTimer(hwnd, FernTimer);

  for (int i = 0; i < 200; i++)
  {
    if (Count >= MaxIterations)
      return;
    DoPaint(hwnd);
  }
}
