//////////////////////////////////////
// Program Name: ISOTROP.CPP
// Programmer: Charlie Calvert
// Description: MDI example program
// Date: 07/25/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "draw.h"
#pragma warning(disable : 4068)

extern HMENU hMenuMultiple, hMenuInit;
extern HMENU hMenuFileMultiple, hMenuFileInit;
static HWND hwndClient, hwndFrame;

#define Isotrop_DefProc DefMDIChildProc
BOOL Isotrop_OnCreate(HWND hwnd,
                      CREATESTRUCT FAR* lpCreateStruct);
void Isotrop_MDIActivate(HWND hwnd, BOOL fActive, HWND hwndActivate,
                         HWND hwndDeactivate);
void Isotrop_OnPaint(HWND hwnd);
BOOL Isotrop_OnQueryEndSession(HWND hwnd);

//////////////////////////////////////
// The Windows Procedure
//////////////////////////////////////
LRESULT CALLBACK IsotropicWndProc(HWND hwnd, UINT message,
                                  WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Isotrop_OnCreate);
    HANDLE_MSG(hwnd, WM_MDIACTIVATE, Isotrop_MDIActivate);
    HANDLE_MSG(hwnd, WM_PAINT, Isotrop_OnPaint);
    HANDLE_MSG(hwnd, WM_QUERYENDSESSION,
               Isotrop_OnQueryEndSession);
  default:
    return Isotrop_DefProc(hwnd, message, wParam, lParam);
  }
}

//////////////////////////////////////
// HANDLE WM_QUERYENDSESSION
//////////////////////////////////////
BOOL Isotrop_OnQueryEndSession(HWND hwnd)
{
  if (IDOK != MessageBox (hwnd, "OK to close window?",
                "Isotropic", MB_ICONQUESTION | MB_OKCANCEL))
    return FALSE;
  else
    return TRUE;
}

//////////////////////////////////////
// HANDLE WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Isotrop_OnCreate(HWND hwnd,
                      CREATESTRUCT FAR* lpCreateStruct)
{
  hwndClient = GetParent(hwnd);
  hwndFrame = GetParent(hwndClient);
  return TRUE;
}

//////////////////////////////////////
// HANDLE WM_MDIACTIVATE
//////////////////////////////////////
#pragma argsused
void Isotrop_MDIActivate(HWND hwnd, BOOL fActive, 
                         HWND hwndActivate, HWND hwndDeactivate)
{
  if (fActive)
    SendMessage(hwndClient, WM_MDISETMENU, 0,
                MAKELONG(hMenuMultiple, hMenuFileMultiple));
  if (!fActive)
    SendMessage(hwndClient, WM_MDISETMENU, 0,
                MAKELONG(hMenuInit, hMenuFileInit));
  DrawMenuBar (hwndFrame);
}

//////////////////////////////////////
// HANDLE WM_PAINT
//////////////////////////////////////
void Isotrop_OnPaint(HWND hwnd)
{
  HDC PaintDC;
  PAINTSTRUCT PaintStruct;
  RECT R;

  PaintDC = BeginPaint (hwnd, &PaintStruct);

  SetMapMode(PaintDC, MM_ISOTROPIC);
  GetClientRect(hwnd, &R);
  SetWindowExt(PaintDC, 210, 210);
  SetViewportExt(PaintDC, R.right, R.bottom);
  SetViewportOrg(PaintDC, R.right / 2, R.bottom / 2);
  DoDraw(PaintDC);

  EndPaint (hwnd, &PaintStruct);
}
