//////////////////////////////////////
// Program Name: NORMAL.CPP
// Programmer: Charlie Calvert
// Description: MDI example program
// Date: 07/25/93
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "draw.h"
#pragma warning(disable : 4068)

extern HMENU hMenuMultiple, hMenuInit;
extern HMENU hMenuFileMultiple, hMenuFileInit;
static HWND hwndClient, hwndFrame;

#define NormalPlay_DefProc DefMDIChildProc
BOOL NormalPlay_OnCreate(HWND hwnd,
                         CREATESTRUCT FAR* lpCreateStruct);
void NormalPlay_MDIActivate(HWND hwnd, BOOL fActive,
                            HWND hwndActivate,
                            HWND hwndDeactivate);
void NormalPlay_OnPaint(HWND hwnd);

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK NormalWndProc(HWND hwnd, UINT message,
                               WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, NormalPlay_OnCreate);
    HANDLE_MSG(hwnd, WM_MDIACTIVATE, NormalPlay_MDIActivate);
    HANDLE_MSG(hwnd, WM_PAINT, NormalPlay_OnPaint);
  default:
    return NormalPlay_DefProc(hwnd, message, wParam, lParam);
  }
}

//////////////////////////////////////
// HANDLE WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL NormalPlay_OnCreate(HWND hwnd,
                         CREATESTRUCT FAR* lpCreateStruct)
{
  hwndClient = GetParent (hwnd);
  hwndFrame = GetParent (hwndClient);
  return TRUE;
}

//////////////////////////////////////
// HANDLE WM_MDIACTIVATE
//////////////////////////////////////
#pragma argsused
void NormalPlay_MDIActivate(HWND hwnd, BOOL fActive,
                            HWND hwndActivate,
                            HWND hwndDeactivate)
{
  // Set the Normal menu if gaining focus
  if (fActive)
    SendMessage(hwndClient, WM_MDISETMENU, 0,
                MAKELONG(hMenuMultiple, hMenuFileMultiple));
  if (!fActive)
    SendMessage(hwndClient, WM_MDISETMENU, 0,
                MAKELONG(hMenuInit, hMenuFileInit));
  DrawMenuBar (hwndFrame);
}

//////////////////////////////////////
// HANDLE WM_NORMAL
//////////////////////////////////////
void NormalPlay_OnPaint(HWND hwnd)
{
  HDC PaintDC;
  PAINTSTRUCT PaintStruct;
  RECT R;

  PaintDC = BeginPaint (hwnd, &PaintStruct);
  GetClientRect(hwnd, &R);
  SetViewportOrg(PaintDC, R.right / 2, R.bottom / 2);

  DoDraw(PaintDC);
  EndPaint (hwnd, &PaintStruct);
}
