//////////////////////////////////////
//  Program Name: MENUTEST.CPP
//  Programmer: Charlie Calvert
//  Description: MenuTest windows program
//  Date: 07/20/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include "menutest.h"
#pragma warning (disable: 4068)
#pragma warning (disable: 4100)
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

static char szAppName[] = "MenuTest";
static HWND MainWindow;
static HINSTANCE hInstance;
static HACCEL hAccel;

// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    if (!TranslateAccelerator(MainWindow, hAccel, &Msg))
    {
       TranslateMessage(&Msg);
       DispatchMessage(&Msg);
    }
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style         = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc   = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(hInst, "ICON_1");
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName  = "MENU_1";
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                      NULL, NULL, hInst, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                              WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, MenuTest_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, MenuTest_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, MenuTest_OnCommand);
    HANDLE_MSG(hwnd, WM_DRAWITEM, MenuTest_OnDrawItem);
    HANDLE_MSG(hwnd, WM_LBUTTONDOWN, MenuTest_OnLButtonDown);
    HANDLE_MSG(hwnd, WM_MOUSEMOVE, MenuTest_OnMouseMove);
    HANDLE_MSG(hwnd, WM_MEASUREITEM, MenuTest_OnMeasureItem);
    HANDLE_MSG(hwnd, WM_PAINT, MenuTest_OnPaint);
    default:
      return MenuTest_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL MenuTest_OnCreate(HWND hwnd,
                       CREATESTRUCT FAR* lpCreateStruct)
{
  Cursor1 = LoadCursor(hInstance, "CURSOR_1");
  Cursor2 = LoadCursor(hInstance, "CURSOR_2");
  Cursor3 = LoadCursor(hInstance, "CURSOR_3");

  Icon1 = LoadIcon(hInstance, "ICON_1");

  Bitmap1 = LoadBitmap(hInstance, "BITMAP_1");
  Bitmap1a = LoadBitmap(hInstance, "BITMAP1A");
  Bitmap2 = LoadBitmap(hInstance, "BITMAP_2");
  Bitmap2a = LoadBitmap(hInstance, "BITMAP2A");
  Bitmap3 = LoadBitmap(hInstance, "BITMAP_3");
  Bitmap3a = LoadBitmap(hInstance, "BITMAP3A");
  BMPExit = LoadBitmap(hInstance, "BMPEXIT");

  GetObject(Bitmap1, sizeof(BITMAP), &BStruct);

  ModifyMenu(GetMenu(hwnd),
             CM_BITMENU1, MF_BYCOMMAND | MF_OWNERDRAW,
             CM_BITMENU1, (LPCSTR)MAKELONG(Bitmap1, 0));
  ModifyMenu(GetMenu(hwnd), CM_BITMENU2,
             MF_BYCOMMAND | MF_OWNERDRAW,
             CM_BITMENU2, (LPCSTR)MAKELONG(Bitmap2, 0));
  ModifyMenu(GetMenu(hwnd), CM_BITMENU3,
             MF_BYCOMMAND | MF_OWNERDRAW,
             CM_BITMENU3, (LPCSTR)MAKELONG(Bitmap3, 0));
  ModifyMenu(GetMenu(hwnd), CM_EXIT,
             MF_BYCOMMAND | MF_BITMAP,
             CM_EXIT, (LPCSTR)MAKELONG(BMPExit, 0));

  HMENU SysMenu = GetSystemMenu(hwnd, FALSE);

  DeleteMenu(SysMenu, 6, MF_BYPOSITION);
  DeleteMenu(SysMenu, 6, MF_BYPOSITION);

  EditBrush = CreateSolidBrush(RGB(255, 127, 255));
  PaintIcon = FALSE;
  PaintGo = FALSE;
  PaintSlow = FALSE;
  PaintStop = TRUE;

  hAccel = LoadAccelerators(hInstance, "MYKEYS");

  if (hAccel == NULL)
    MessageBox(MainWindow, "No Accelerators", "Warning", MB_OK);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void MenuTest_OnDestroy(HWND hwnd)
{
  DeleteObject(EditBrush);
  DeleteObject(Bitmap1);
  DeleteObject(Bitmap1a);
  DeleteObject(Bitmap2);
  DeleteObject(Bitmap2a);
  DeleteObject(Bitmap3);
  DeleteObject(Bitmap3a);
  DeleteObject(BMPExit);
  DestroyCursor(Cursor1);
  DestroyCursor(Cursor2);
  DestroyCursor(Cursor3);
  DestroyIcon(Icon1);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Check menu if user selects a cursor
//////////////////////////////////////
void CheckItem(HWND hwnd, int ID)
{
  HMENU Menu = GetMenu(hwnd);
  CheckMenuItem(Menu,
                CM_ROUNDCURSOR, MF_BYCOMMAND | MF_UNCHECKED);
  CheckMenuItem(Menu,
                CM_DIAMONDCURSOR, MF_BYCOMMAND | MF_UNCHECKED);
  CheckMenuItem(Menu,
                CM_ICONCURSOR, MF_BYCOMMAND | MF_UNCHECKED);
  if (ID)
    CheckMenuItem(Menu, ID, MF_BYCOMMAND | MF_CHECKED);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void MenuTest_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT 
codeNotify)
{
  FARPROC lpfnHelpBox;

  switch(id)
  {
    case CM_NEW:
    case CM_OPEN:
    case CM_SAVE:
    case CM_SAVEAS:
    case CM_PRNDISK:
    case CM_PRNLPT1:
    case CM_PAGESETUP:
    case CM_PRINTERSETUP:
      MessageBox(hwnd, "Not yet implemented", "Info",
                 MB_OK | MB_ICONINFORMATION);
      break;

    case CM_EXIT:
      DestroyWindow(hwnd);
      break;

    case CM_ROUNDCURSOR:
      SetClassWord(hwnd, GCW_HCURSOR, (WORD)Cursor1);
      SetCursor(Cursor1);
      PaintIcon = FALSE;
      CheckItem(hwnd, CM_ROUNDCURSOR);
      break;

    case CM_DIAMONDCURSOR:
      SetClassWord(hwnd, GCW_HCURSOR, (WORD)Cursor2);
      SetCursor(Cursor2);
      PaintIcon = FALSE;
      CheckItem(hwnd, CM_DIAMONDCURSOR);
      break;

    case CM_ICONCURSOR:
      SetClassWord(hwnd, GCW_HCURSOR, (WORD)Cursor3);
      SetCursor(Cursor3);
      PaintIcon = TRUE;
      CheckItem(hwnd, CM_ICONCURSOR);
      break;

    case CM_BITMENU1:
      PaintGo = TRUE;
      PaintSlow = FALSE;
      PaintStop = FALSE;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_BITMENU2:
      PaintGo = FALSE;
      PaintSlow = TRUE;
      PaintStop = FALSE;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_BITMENU3:
      PaintGo = FALSE;
      PaintSlow = FALSE;
      PaintStop = TRUE;
      InvalidateRect(hwnd, NULL, TRUE);
      SetClassWord(hwnd, GCW_HCURSOR,
                  (WORD)LoadCursor(NULL, IDC_ARROW));
      SetCursor(LoadCursor(NULL, IDC_ARROW));
      CheckItem(hwnd, 0);
      PaintIcon = FALSE;
      break;

    case CM_HELP:
      lpfnHelpBox =
        MakeProcInstance((FARPROC)HelpBoxProc, hInstance);
      DialogBox(hInstance, "HELPBOX", hwnd,
               (DLGPROC)lpfnHelpBox);
      FreeProcInstance(lpfnHelpBox);
      break;
  }
}

//////////////////////////////////////
// Draw Bitmap in menu
//////////////////////////////////////
void DrawBitmap(HDC PaintDC, HBITMAP Bitmap, int YVal)
{
  HDC MemDC;
  HBITMAP OldBitmap;

  MemDC = CreateCompatibleDC(PaintDC);
  OldBitmap = SelectBitmap(MemDC, Bitmap);
  BitBlt(PaintDC, 0, YVal * BStruct.bmHeight, BStruct.bmWidth,
         BStruct.bmHeight, MemDC, 0, 0, SRCCOPY);
  SelectObject(MemDC, OldBitmap);
  DeleteObject(MemDC);
}

//////////////////////////////////////
// Handle WM_DRAWITEM
//////////////////////////////////////
#pragma argsused
void MenuTest_OnDrawItem(HWND hwnd,
                         const DRAWITEMSTRUCT FAR* lpDrawItem)
{
  switch(lpDrawItem->itemID)
  {
    case CM_BITMENU1:
      if (lpDrawItem->itemState & ODS_SELECTED)
        DrawBitmap(lpDrawItem->hDC, Bitmap1a, 0);
      else
        DrawBitmap(lpDrawItem->hDC, Bitmap1, 0);
      break;

    case CM_BITMENU2:
      if (lpDrawItem->itemState & ODS_SELECTED)
        DrawBitmap(lpDrawItem->hDC, Bitmap2a, 1);
      else
        DrawBitmap(lpDrawItem->hDC, Bitmap2, 1);
      break;

    case CM_BITMENU3:
      if (lpDrawItem->itemState & ODS_SELECTED)
        DrawBitmap(lpDrawItem->hDC, Bitmap3a, 2);
      else
        DrawBitmap(lpDrawItem->hDC, Bitmap3, 2);
      break;
  }
}

//////////////////////////////////////
// Handle WM_LBUTTONDOWN
//////////////////////////////////////
#pragma argsused
void MenuTest_OnLButtonDown(HWND hwnd, BOOL fDoubleClick, int x,
                            int y, UINT keyFlags)
{
  if (PaintIcon)
  {
    HDC PaintDC = GetDC(hwnd);
    DrawIcon(PaintDC, x, y, Icon1);
    ReleaseDC(hwnd, PaintDC);
  }
}

//////////////////////////////////////
// Handle WM_MEASUREITEM
//////////////////////////////////////
#pragma argsused
void MenuTest_OnMeasureItem(HWND hwnd, MEASUREITEMSTRUCT
                            FAR* lpMeasureItem)
{
  WORD CheckWidth;

  CheckWidth = LOWORD (GetMenuCheckMarkDimensions());
  switch ( lpMeasureItem->itemID )
  {
    case CM_BITMENU1:
    case CM_BITMENU2:
    case CM_BITMENU3:
     lpMeasureItem->itemWidth = BStruct.bmWidth - CheckWidth - 3;
     lpMeasureItem->itemHeight = BStruct.bmHeight - 1;
     break;
  }
}

//////////////////////////////////////
// Handle WM_MOUSEMOVE
//////////////////////////////////////
void MenuTest_OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags)
{
  if (((keyFlags & MK_LBUTTON) == MK_LBUTTON) && (PaintIcon))
  {
    HDC PaintDC = GetDC(hwnd);
    DrawIcon(PaintDC, x, y, Icon1);
    ReleaseDC(hwnd, PaintDC);
  }
}

//////////////////////////////////////
// Handle WM_PAINT
//////////////////////////////////////
void MenuTest_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  HDC PaintDC, MemDC;
  RECT R;
  HBITMAP OldBitmap;

  PaintDC = BeginPaint(hwnd, &PaintStruct);

  if (!PaintStop)
  {
    GetClientRect(hwnd, &R);
    int i = R.right / BStruct.bmWidth;
    int j = R.bottom / BStruct.bmHeight;

    MemDC = CreateCompatibleDC(PaintDC);

    if (PaintSlow)
      OldBitmap = SelectBitmap(MemDC, Bitmap2);
    else
      OldBitmap = SelectBitmap(MemDC, Bitmap1);

    for (int x = 0; x <= i; x++)
      for (int y = 0; y <= j; y++)
       BitBlt(PaintDC, BStruct.bmWidth * x, BStruct.bmHeight * y,
        BStruct.bmWidth, BStruct.bmHeight, MemDC, 0, 0, SRCCOPY);

    SelectObject(MemDC, OldBitmap);
    DeleteDC(MemDC);
  }

  EndPaint(hwnd, &PaintStruct);
}

// --------------------------------------------
// About Box Procedure
// --------------------------------------------
#pragma argsused
BOOL CALLBACK HelpBoxProc(HWND hDlg, WORD Message, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_INITDIALOG:
      SendDlgItemMessage(hDlg, ID_HELPEDIT,
                         WM_SETTEXT, 0, LPARAM(HelpStr));
      return TRUE;

    case WM_CTLCOLOR:
      switch(HIWORD(lParam))
       {
         // Cover up background of Static control
         case CTLCOLOR_STATIC:
           return (BOOL) GetStockObject(BLACK_BRUSH);

         case CTLCOLOR_EDIT:
           SetTextColor((HDC)wParam, RGB(127,127,127));
           return NULL;

         case CTLCOLOR_DLG:
           return (BOOL) EditBrush;
       }
       return (BOOL) NULL;

    case WM_COMMAND:
      if (wParam == IDOK || wParam == IDCANCEL)
      {
        EndDialog(hDlg, TRUE);
        return TRUE;
      }
      break;
  }
  return FALSE;
}
