//////////////////////////////////////
//  Program Name: MENUTEST.H
//  Programmer: Charlie Calvert
//  Description: MenuTest windows program
//  Date: 07/20/93
//////////////////////////////////////
#define CM_NEW 101
#define CM_OPEN 102
#define CM_SAVE 103
#define CM_SAVEAS 104
#define CM_PRNDISK 151
#define CM_PRNLPT1 152
#define CM_PAGESETUP 105
#define CM_PRINTERSETUP 106
#define CM_EXIT 107

#define CM_ROUNDCURSOR 201
#define CM_DIAMONDCURSOR 202
#define CM_ICONCURSOR 203

#define CM_BITMENU1 301
#define CM_BITMENU2 302
#define CM_BITMENU3 303

#define CM_HELP     401
#define ID_HELPEDIT 402

// Constant
char FAR *HelpStr="Choose ROUND CURSOR or DIAMOND CURSOR to see"
               " new cursors. Choose DRAW ICON to draw on the"
               " screen. Choose GO or SLOW to set background, "
               " choose BYE to reset screen. The close option "
               " has been removed from the system menu, so exit "
               " using the File menu";

// Declarations for class MenuTest
#define MenuTest_DefProc    DefWindowProc
BOOL MenuTest_OnCreate(HWND hwnd,
                       CREATESTRUCT FAR* lpCreateStruct);
void MenuTest_OnDestroy(HWND hwnd);
void MenuTest_OnCommand(HWND hwnd, int id,
                        HWND hwndCtl, UINT codeNotify);
void MenuTest_OnDrawItem(HWND hwnd,
                         const DRAWITEMSTRUCT FAR* lpDrawItem);
void MenuTest_OnLButtonDown(HWND hwnd, BOOL fDoubleClick,
                            int x, int y, UINT keyFlags);
void MenuTest_OnMeasureItem(HWND hwnd,
                         MEASUREITEMSTRUCT FAR* lpMeasureItem);
void MenuTest_OnMouseMove(HWND hwnd, int x,
                          int y, UINT keyFlags);
void MenuTest_OnPaint(HWND hwnd);

// variables
HICON Icon1;
HBRUSH EditBrush;
HCURSOR Cursor1, Cursor2, Cursor3;
HBITMAP Bitmap1, Bitmap1a, Bitmap2, Bitmap2a;
HBITMAP Bitmap3, Bitmap3a, BMPExit;
BITMAP BStruct;
BOOL PaintIcon, PaintGo, PaintSlow, PaintStop;

// function
LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                 WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
BOOL CALLBACK HelpBoxProc(HWND hDlg, WORD Message,
                          WPARAM wParam, LPARAM lParam);
