//////////////////////////////////////
//  File Name: METAPHOR.CPP
//  Programmer: Charlie Calvert
//  Description: Meta windows program
//  Date: 4/17/93
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <string.h>
#include <direct.h>
#include "metaphor.h"
#include "metautil.h"
#include "metaenum.h"
#pragma warning (disable: 4068)

// -------------------------------------------------------
// Interface
// -------------------------------------------------------

// Variables
static HBRUSH FBrush;
static char szAppName[] = "Metaphor";
static HWND MainWindow;
static HINSTANCE hInstance;
static TDATA Dat;
static RECT OldRect;
static HMETAFILE GooberMeta;
static HDC GooberDC;
HMETAFILE hmf;
char TempName[256];

// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, 
                   LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style         = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc   = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = 0;
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName  = "MetaMenu";
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                      NULL, NULL, hInst, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Meta_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Meta_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, Meta_OnCommand);
    HANDLE_MSG(hwnd, WM_LBUTTONDOWN, Meta_OnLButtonDown);
    HANDLE_MSG(hwnd, WM_LBUTTONUP, Meta_OnLButtonUp);
    HANDLE_MSG(hwnd, WM_MOUSEMOVE, Meta_OnMouseMove);
    HANDLE_MSG(hwnd, WM_PAINT, Meta_OnPaint);

    default: return Meta_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Meta_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  Dat.Color = RGB(0, 0, 0);
  FBrush = CreateSolidBrush(RGB(255, 255, 255));
  Dat.Thickness = 10;
  PostMessage(hwnd, WM_COMMAND, CM_STARTMETA, 0);

  _getdcwd(0, TempName, MAXSIZE);
  strcat(TempName, "\\goober.$$$");
  hmf = NULL;

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void Meta_OnDestroy(HWND hwnd)
{
  if (hmf)
    DeleteMetaFile(hmf);
  DeleteObject(FBrush);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void Meta_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  switch (id)
  {
    case CM_STARTMETA:
      GooberDC = CreateMetaFile(TempName);
      break;

    case CM_ENDMETA:
      TurnOffSave(hwnd);
      if (hmf)
        DeleteMetaFile(hmf);
      hmf = CloseMetaFile(GooberDC);
      SaveFile(hwnd, TempName);
      break;

    case CM_NEWMETA:
      CreateMeta(hwnd);
      break;

    case CM_LOAD:
      TurnOffSave(hwnd);
      LoadFile(hwnd);
      break;

    case CM_EXIT:
      DestroyWindow(hwnd);
      break;

    case CM_RECTANGLE:
      Dat.Shape = RECTANGLE;
      break;

    case CM_ERECTANGLE:
      Dat.Shape = ERECTANGLE;
      break;

    case CM_ELLIPSE:
      Dat.Shape = ELLIPSE;
      break;

    case CM_LINE:
      Dat.Shape = LINE;
      break;

    case CM_RED:
      Dat.Color = RGB(255, 0, 0);
      break;

    case CM_GREEN:
      Dat.Color = RGB(0, 255, 0);
      break;

    case CM_BLUE:
      Dat.Color = RGB(0, 0, 255);
      break;

    case CM_FRED:
      DeleteBrush(FBrush);
      FBrush = CreateSolidBrush(RGB(255, 0, 0));
      break;

    case CM_FGREEN:
      DeleteBrush(FBrush);
      FBrush = CreateSolidBrush(RGB(0, 255, 0));
      break;

    case CM_FBLUE:
      DeleteBrush(FBrush);
      FBrush = CreateSolidBrush(RGB(0, 0, 255));
      break;

    case CM_ONE:
      Dat.Thickness = 1;
      break;

    case CM_FIVE:
      Dat.Thickness = 5;
      break;

    case CM_TEN:
      Dat.Thickness = 10;
      break;

    case CM_TWENTY:
      Dat.Thickness = 20;
      break;

    case CM_FORTY:
      Dat.Thickness = 40;
      break;

    case CM_EIGHTY:
      Dat.Thickness = 80;
      break;
  }
}

//////////////////////////////////////
// DRAWSHAPE
//////////////////////////////////////
#pragma argsused
void DrawShape(HWND hwnd, HDC PaintDC, RECT R)
{
  switch(Dat.Shape)
  {

    case ELLIPSE:
      Ellipse(PaintDC, R.left, R.top, R.right, R.bottom);
      break;

    case LINE:
      MoveTo(PaintDC, R.left, R.top);
      LineTo(PaintDC, R.right, R.bottom);
      break;

    case ERECTANGLE:
    case RECTANGLE:
      Rectangle(PaintDC, R.left, R.top, R.right, R.bottom);
      break;
  }
}

//////////////////////////////////////
// DrawFinalShape
//////////////////////////////////////
#pragma argsused
void DrawFinalShape(HWND hwnd, HDC PaintDC, RECT R)
{
  HBRUSH B, OldBrush, OldGBrush;

  HPEN Pen = CreatePen(PS_INSIDEFRAME, Dat.Thickness, Dat.Color);
  HPEN OldPen = SelectPen(PaintDC, Pen);
  HPEN OldGPen = SelectPen(GooberDC, Pen);

  switch(Dat.Shape)
  {
    case ELLIPSE:
      OldBrush = SelectBrush(PaintDC, FBrush);
      OldGBrush = SelectBrush(GooberDC, FBrush);
      Ellipse(PaintDC, R.left, R.top, R.right, R.bottom);
      Ellipse(GooberDC, R.left, R.top, R.right, R.bottom);
      SelectObject(PaintDC, OldBrush);
      SelectBrush(GooberDC, OldGBrush);
      break;

    case LINE:
      MoveTo(PaintDC, R.left, R.top);
      LineTo(PaintDC, R.right, R.bottom);
      MoveTo(GooberDC, R.left, R.top);
      LineTo(GooberDC, R.right, R.bottom);
      break;

    case RECTANGLE:
      OldBrush = SelectBrush(PaintDC, FBrush);
      OldGBrush = SelectBrush(GooberDC, FBrush);
      Rectangle(PaintDC, R.left, R.top, R.right, R.bottom);
      Rectangle(GooberDC, R.left, R.top, R.right, R.bottom);
      SelectObject(PaintDC, OldBrush);
      SelectBrush(GooberDC, OldGBrush);
      break;

    case ERECTANGLE:
      B = GetStockBrush(NULL_BRUSH);
      OldBrush = SelectBrush(PaintDC, B);
      OldGBrush = SelectBrush(GooberDC, B);
      Rectangle(PaintDC, OldRect.left,
                OldRect.top, OldRect.right, OldRect.bottom);
      Rectangle(GooberDC, OldRect.left,
                OldRect.top, OldRect.right, OldRect.bottom);
      SelectObject(PaintDC, OldBrush);
      SelectBrush(GooberDC, OldGBrush);
      break;
  }
  SelectObject(PaintDC, OldPen);
  SelectObject(GooberDC, OldGPen);
  DeleteObject(Pen);
}

//////////////////////////////////////
// Handle WM_MOUSEMOVE
//////////////////////////////////////
#pragma argsused
void Meta_OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags)
{
  if (Dat.ButtonDown)
  {
    Dat.Drawing = TRUE;

    HDC PaintDC = GetDC(hwnd);

    SetROP2(PaintDC, R2_NOTXORPEN);
    if (OldRect.left != -32000)
      DrawShape(hwnd, PaintDC, OldRect);
    OldRect.left = Dat.DownX;
    OldRect.top = Dat.DownY;
    OldRect.right = x;
    OldRect.bottom = y;
    DrawShape(hwnd, PaintDC, OldRect);
    ReleaseDC(hwnd, PaintDC);
  }
}

//////////////////////////////////////
// WM_LBUTTONDOWN
//////////////////////////////////////
#pragma argsused
void Meta_OnLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, 
UINT
keyFlags)
{
  Dat.ButtonDown = TRUE;
  Dat.Drawing = FALSE;
  OldRect.left = -32000;
  Dat.DownX = x;
  Dat.DownY = y;
  SetCapture(hwnd);
}

//////////////////////////////////////
// WM_LBUTTONUP
//////////////////////////////////////
#pragma argsused
void Meta_OnLButtonUp(HWND hwnd, int x, int y, UINT keyFlags)
{
  if ((Dat.ButtonDown) && (Dat.Drawing))
  {
    Dat.Drawing = FALSE;
    HDC PaintDC = GetDC(hwnd);
    DrawFinalShape(hwnd, PaintDC, OldRect);
    ReleaseDC(hwnd, PaintDC);
    ReleaseCapture();
  }
  Dat.ButtonDown = FALSE;
}

//////////////////////////////////////
// WM_PAINT
//////////////////////////////////////
void Meta_OnPaint(HWND hwnd)
{
  HDC PaintDC;
  PAINTSTRUCT PaintStruct;
  RECT R;

  GetClientRect(hwnd, &R);

  PaintDC = BeginPaint(hwnd, &PaintStruct);

  if (IsAldusFile())
  {
    SetMapMode(PaintDC, MM_ANISOTROPIC);
    SetWindowExt(PaintDC, 1000, 1000);
    SetViewportExt(PaintDC, R.right, R.bottom);
    SetWindowOrg(PaintDC, R.right / 2, R.bottom / 2);
    PlayMetaFile(PaintDC, hmf);
  }
  else
    if (hmf) EnumTheMeta(hwnd, hmf);

  EndPaint(hwnd, &PaintStruct);
}
