//////////////////////////////////////
// Module: META.H
// Programmer: Charlie Calvert
// Description: Part of Meta project
//////////////////////////////////////
//////////////////////////////////////
// Const
#define CM_EXIT 101
#define CM_LOAD 102
#define CM_NEWMETA 103
#define CM_STARTMETA 104
#define CM_ENDMETA 105

#define CM_LINE 201
#define CM_ELLIPSE 202
#define CM_RECTANGLE 203
#define CM_ERECTANGLE 204

#define CM_RED 301
#define CM_GREEN 302
#define CM_BLUE 303

#define CM_FRED 401
#define CM_FGREEN 402
#define CM_FBLUE 403

#define CM_ONE 501
#define CM_FIVE 502
#define CM_TEN 503
#define CM_TWENTY 504
#define CM_FORTY 505
#define CM_EIGHTY 506

#define MAXSIZE 256

// Type
enum TShape {ELLIPSE, LINE, RECTANGLE, ERECTANGLE};

struct TDATA {
  int DownX, DownY;
  BOOL ButtonDown;
  BOOL Drawing;
  TShape Shape;
  int Thickness;
  COLORREF Color;
};

// Declarations for class Meta
#define Meta_DefProc    DefWindowProc
BOOL Meta_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void Meta_OnDestroy(HWND hwnd);
void Meta_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
void Meta_OnLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, 
                        UINT keyFlags);
void Meta_OnLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
void Meta_OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
void Meta_OnPaint(HWND hwnd);

// Funcs
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
