//////////////////////////////////////
//  Program Name: PrntFont.CPP
//  Programmer: Charlie Calvert
//  Description: PrntFont windows program
//  Date: 12/12/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "PrntFont.h"
#pragma warning (disable: 4068)

// variables
static char szAppName[] = "PrntFont";
static HWND MainWindow;
static HINSTANCE hInstance;

// ------------------------------------
// Initialization
// ------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName   = "Menu";
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInstance, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// --------------------------------------
// WndProc and Implementation
// --------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hWindow, WM_DESTROY, PrntFont_OnDestroy);
    HANDLE_MSG(hWindow, WM_COMMAND, PrntFont_OnCommand);
    HANDLE_MSG(hWindow, WM_PAINT, PrntFont_OnPaint);
    default:
      return PrntFont_DefProc(hWindow, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Get a new font, specify Escapement
//////////////////////////////////////
HFONT GetFont(int Size, char * Name)
{
  LOGFONT LogFont;
  HFONT TheFont;

  memset(&LogFont, 0, sizeof(LOGFONT));

  LogFont.lfHeight        = Size;
  LogFont.lfWeight        = 100;
  LogFont.lfEscapement    = 0;
  LogFont.lfItalic        = 1;
  LogFont.lfUnderline     = 1;
  LogFont.lfOutPrecision  = OUT_STROKE_PRECIS;
  LogFont.lfClipPrecision = CLIP_STROKE_PRECIS;
  LogFont.lfQuality       = DEFAULT_QUALITY;
  strcpy(LogFont.lfFaceName, Name);

  TheFont = CreateFontIndirect(&LogFont);

  return TheFont;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void PrntFont_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

//////////////////////////////////////
// Driver Version
//////////////////////////////////////
int FAR PASCAL GetDriverVersion(HDC PrnDC, char *S)
{
  int Ver;

  Ver = GetDeviceCaps(PrnDC, DRIVERVERSION);
  wvsprintf(S, "DriverVersion: 0%xh", &Ver);

  return 1;
}

//////////////////////////////////////
// TechType
//////////////////////////////////////
int FAR PASCAL GetTechType(HDC PrnDC, char *S)
{
  int Ver;
  static char *szTechInfo [] = {
		"Vector plotter",
		"Raster display",
		"Raster printer",
		"Raster camera",
		"Character stream",
		"Metafile",
		"Display file"};

  Ver = GetDeviceCaps (PrnDC, TECHNOLOGY);
  wvsprintf(S, "Technology: %s", &szTechInfo[Ver]);

  return 1;
}

//////////////////////////////////////
// GetPrinter
//////////////////////////////////////
int FAR PASCAL GetPrinter(LPSTR S)
{
  GetProfileString("windows", "device", ",,,", S, 99);
  return 1;
}

//////////////////////////////////////
// WritePrinterInfo
//////////////////////////////////////
int FAR PASCAL WritePrinter(HDC PrnDC)
{
  char S[100];
  char S1[100];
  HFONT MyFont, OldFont;
  int const SIZE = 100;
  DOCINFO DocInfo;
  
  MyFont = GetFont(SIZE, "New Times Roman");
  OldFont = SelectFont(PrnDC, MyFont);

  DocInfo.cbSize = sizeof(DOCINFO);
  DocInfo.lpszDocName = "Test";
  DocInfo.lpszOutput = NULL;

  StartDoc(PrnDC, &DocInfo);
  StartPage(PrnDC);

  GetPrinter(S);
  strcpy(S1, "Printer: ");
  strcat(S1, strtok(S, ","));
  TextOut(PrnDC, 10, SIZE, S1, strlen(S1));

  GetDriverVersion(PrnDC, S1);
  TextOut(PrnDC, 10, SIZE * 3, S1, strlen(S1));
  GetTechType(PrnDC, S1);
  TextOut(PrnDC, 10, SIZE * 5, S1, strlen(S1));

  EndPage(PrnDC);
  EndDoc(PrnDC);

  SelectFont(PrnDC, OldFont);
  if (MyFont != 0) DeleteObject(MyFont);

  return 1;
}

//////////////////////////////////////
// GetPrinterDC
//////////////////////////////////////
HDC FAR PASCAL GetPrinterDC(void)
{
  char S[100];
  char *szDevice, *szDriver, *szOutput;
  HDC DC;

  GetPrinter(S);

  #pragma warn -pia
  if ((szDevice = strtok(S, ",")) &&
      (szDriver = strtok(NULL, ", ")) &&
      (szOutput = strtok(NULL, ", ")))
  #pragma warn +pia

  DC = CreateDC(szDriver, szDevice, szOutput, NULL);
  return DC;
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void PrntFont_OnCommand(HWND hwnd, int id, HWND hwndCtl,
                        UINT codeNotify)
{
  switch (id)
  {
    case CM_PRINT:
      HDC PrnDC = GetPrinterDC();
      WritePrinter(PrnDC);
      DeleteDC(PrnDC);
      break;
  }
}

//////////////////////////////////////
// Handle WM_PAINT changing the color, and rotating the font
//////////////////////////////////////
void PrntFont_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  HFONT TheFont, OldFont;

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);

  TheFont = GetFont(75, "New Times Roman");
  OldFont = SelectFont(PaintDC, TheFont);
  TextOut(PaintDC, 1, 1, "Printer Font Tester!" , 20);
  SelectObject(PaintDC, OldFont);
  DeleteObject(TheFont);

  EndPaint(hwnd, &PaintStruct);
}
