//////////////////////////////////////
//  Program Name: SIMPFONT.CPP
//  Programmer: Charlie Calvert
//  Description: SimpFont windows program
//  Date: 3/20/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "simpfont.h"
#include "fontstr.h"
#pragma warning (disable: 4068)

// variables
static char szAppName[] = "SimpFont";
static HWND MainWindow;
static HINSTANCE hInstance;
static LOGFONT LogFont;
static HFONT TheFont;
static char aFaceName[80];
TEXTMETRIC TextMets;
char * FontChoice[] = {"New Times Roman", "Arial",
                       "Symbol", "StockFont"};
enum TChoice {Roman, Swiss, Symbol, StockFont};
TChoice Choice;

// ------------------------------------
// Initialization
// ------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName   = "Menu";
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInstance, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// --------------------------------------
// WndProc and Implementation
// --------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hWindow, WM_DESTROY, SimpFont_OnDestroy);
    HANDLE_MSG(hWindow, WM_CREATE, SimpFont_OnCreate);
    HANDLE_MSG(hWindow, WM_COMMAND, SimpFont_OnCommand);
    HANDLE_MSG(hWindow, WM_PAINT, SimpFont_OnPaint);
    default:
      return SimpFont_DefProc(hWindow, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Get a new font, specify Escapement
//////////////////////////////////////
HFONT GetFont(int Escapement, char * Name)
{
  memset(&LogFont, 0, sizeof(LOGFONT));

  LogFont.lfHeight        = 37;
  LogFont.lfWeight        = 400;
  LogFont.lfEscapement    = Escapement;
  LogFont.lfItalic        = 1;
  LogFont.lfUnderline     = 1;
  LogFont.lfOutPrecision  = OUT_STROKE_PRECIS;
  LogFont.lfClipPrecision = CLIP_STROKE_PRECIS;
  LogFont.lfQuality       = DEFAULT_QUALITY;
  strcpy(LogFont.lfFaceName, Name);

  if (TheFont != 0) DeleteObject(TheFont);

  TheFont = CreateFontIndirect(&LogFont);

  return TheFont;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void SimpFont_OnDestroy(HWND hwnd)
{
  if (TheFont != 0) DeleteObject(TheFont);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL SimpFont_OnCreate(HWND hwnd, CREATESTRUCT FAR* 
lpCreateStruct)
{
  GetFont(0, "New Times Roman");
  return TRUE;
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void SimpFont_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT 
codeNotify)
{
  char S[500];

  switch (id)
  {
    case CM_INFO:
      GetFontString(S, TextMets, aFaceName);
      MessageBox(hwnd, S, "Font Info", MB_OK);
      break;

    case CM_ROMAN:
      Choice = Roman;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_SWISS:
      Choice = Swiss;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_SYMBOL:
      Choice = Symbol;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_ANSI_FIXED_FONT:
      if (TheFont != 0) DeleteObject(TheFont);
      TheFont = GetStockFont(ANSI_FIXED_FONT);
      Choice = StockFont;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_ANSI_VAR_FONT:
      if (TheFont != 0) DeleteObject(TheFont);
      TheFont = GetStockFont(ANSI_VAR_FONT);
      Choice = StockFont;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_DEVICE_DEFAULT_FONT:
      if (TheFont != 0) DeleteObject(TheFont);
      TheFont = GetStockFont(DEVICE_DEFAULT_FONT);
      Choice = StockFont;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_OEM_FIXED_FONT:
      if (TheFont != 0) DeleteObject(TheFont);
      TheFont = GetStockFont(OEM_FIXED_FONT);
      Choice = StockFont;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_SYSTEM_FONT:
      if (TheFont != 0) DeleteObject(TheFont);
      TheFont = GetStockFont(SYSTEM_FONT);
      Choice = StockFont;
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_SYSTEM_FIXED_FONT:
      if (TheFont != 0) DeleteObject(TheFont);
      TheFont = GetStockFont(SYSTEM_FIXED_FONT);
      Choice = StockFont;
      InvalidateRect(hwnd, NULL, TRUE);
      break;
  }
}

//////////////////////////////////////
// Handle WM_PAINT changing the color, and rotating the font
//////////////////////////////////////
void SimpFont_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  HFONT OldFont;

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);

  if (Choice == StockFont)
  {
    OldFont = SelectFont(PaintDC, TheFont);
    GetTextFace(PaintDC, sizeof(aFaceName),
                (LPSTR) aFaceName);
    GetTextMetrics(PaintDC, &TextMets);
    SetTextColor(PaintDC, RGB(rand() % 255,
                 rand() % 255, rand() % 255));
    TextOut(PaintDC, 10, 10, aFaceName, strlen(aFaceName));
    TextOut(PaintDC, 10, 30, "Stock Fonts", 11);
    TextOut(PaintDC, 10, 50, "Ten Letters", 11);
    SelectFont(PaintDC, OldFont);
  }
  else
  {
    for (int i = 0; i <= 3; i++)
    {
      TheFont = GetFont(900 * i, FontChoice[Choice]);
      OldFont = SelectFont(PaintDC, TheFont);
      SetTextColor(PaintDC, RGB(rand() % 255,
                   rand() % 255, rand() % 255));
      TextOut(PaintDC, 200, 200, "Ahoy!" , 5);
      GetTextFace(PaintDC, sizeof(aFaceName),
                  (LPSTR) aFaceName);
      GetTextMetrics(PaintDC, &TextMets);
      SelectFont(PaintDC, OldFont);
    }
    TextOut(PaintDC, 10, 10, aFaceName, strlen(aFaceName));
  }

  EndPaint(hwnd, &PaintStruct);
}
