// =========================================================
// Program Name: SNAKE1.CPP
// Programmer: Charlie Calvert
// Description: Game with bitmaps, key handling and timer
// =========================================================

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdlib.h>
#pragma warning (disable : 4100)
#pragma warning (disable : 4068)
#include "snake1.h"
#include "grunt.h"

// statics
static char szAppName[] = "Snake";
static char szGameName[] = "GameWindow";
static HWND MainWindow;
static HWND hGameWindow;

// Shared variables
int Size = 32;
int StartCol;
int StartRow;
int MaxCols;
int MaxRows;
div_t NumXSects, NumYSects;

// Variables
HINSTANCE hInstance;
HBITMAP Head, Body, OneHundred;

//---------------------------------------------------------
// Setup
//---------------------------------------------------------

//////////////////////////////////////
// WinMain
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }
  return Msg.wParam;
}

//////////////////////////////////////
// Save hInstance, Create window, Show window maximized
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{
  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName,
                              "A Snake and its Tail",
                              WS_OVERLAPPEDWINDOW,
                              CW_USEDEFAULT, CW_USEDEFAULT,
                              CW_USEDEFAULT, CW_USEDEFAULT,
                              NULL, NULL, hInst, NULL);

  if (hWindow == NULL)
    return hWindow;

  nCmdShow = SW_SHOWMAXIMIZED;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

//////////////////////////////////////
// Register window
//////////////////////////////////////
ATOM Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(GRAY_BRUSH);
  WndClass.lpszMenuName   = NULL;
  WndClass.lpszClassName  = szAppName;

  RegisterClass (&WndClass);

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = GameWndProc;
  WndClass.hIcon          = 0;
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszClassName  = szGameName;

  return RegisterClass (&WndClass);
}

//--------------------------------------
// The Implementation
//--------------------------------------

//////////////////////////////////////
// WndProc
//////////////////////////////////////
LRESULT CALLBACK __export WndProc(HWND hWindow, UINT Message,
                                  WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hWindow, WM_CREATE, Snake_OnCreate);
    HANDLE_MSG(hWindow, WM_DESTROY, Snake_OnDestroy);
    default:
      return Snake_DefProc(hWindow, Message, wParam,lParam);
  }
}

//////////////////////////////////////
// WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Snake_OnCreate(HWND hwnd, CREATESTRUCT FAR*
lpCreateStruct)
{
  Head = LoadBitmap(hInstance, "Head");
  if (!Head)
  {
    MessageBox(hwnd, "No head", "Fatal Error", MB_OK);
    return FALSE;
  }

  Body = LoadBitmap(hInstance, "Body");
  if (!Body)
  {
    MessageBox(hwnd, "No body", "Fatal Error", MB_OK);
    return FALSE;
  }

  OneHundred = LoadBitmap(hInstance, "Hundred");
  if (!OneHundred)
  {
    MessageBox(hwnd, "No OneHundred", "Fatal Error", MB_OK);
    return FALSE;
  }

  int CXFull = GetSystemMetrics(SM_CXSCREEN);
  NumXSects = div(CXFull, Size);
  MaxCols = (NumXSects.quot - 1) * Size;
  int BordWidth = CXFull - MaxCols;
  div_t StartC = div(BordWidth, 2);
  StartCol = StartC.quot;

  int CYFull = GetSystemMetrics(SM_CYFULLSCREEN);
  NumYSects = div(CYFull, Size);
  MaxRows = (NumYSects.quot - 1) * Size;
  BordWidth = CYFull - MaxRows;
  StartC = div(BordWidth, 2);
  StartRow = StartC.quot;


  hGameWindow = CreateWindow("GameWindow", "A",
                         WS_CHILD | WS_VISIBLE,
                         StartCol, BORDERSIZE, MaxCols, MaxRows,
                         hwnd, NULL, hInstance, NULL);

  return TRUE;
}

//////////////////////////////////////
// WM_DESTROY
//////////////////////////////////////
#pragma argsused
void Snake_OnDestroy(HWND hWindow)
{
  if (Head) DeleteObject(Head);
  if (Body) DeleteObject(Body);
  if (OneHundred) DeleteObject(OneHundred);
  PostQuitMessage(0);
}
