//////////////////////////////////////
// Program Name: SCORE.CPP
// Programmer: Charlie Calvert
// Description: Score window and SaveScore dialog
// Date: 08/05/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdLib.h>
#include <stdio.h>
#include <string.h>
#include "snako.h"
#include "score.h"
#pragma warning(disable: 4068)
#pragma warning(disable: 4100)
#define TOTALSCORES 16

struct TSCORESTRUCT {
  char Name[SCORESIZE];
  LONG Total;
} SCORESTRUCT;

// Variables
LONG NewScore;
HBRUSH Pattern;
TSCORESTRUCT Scores[TOTALSCORES];
HWND hStaticWind, hStaticScore;
HWND hStatScreen, hDotsLeftWin;
HBITMAP Patternmap;
BOOL ScoreRecorded = FALSE;
extern BOOL ChangeScore = FALSE;
FILE * fp;

//////////////////////////////////////
// ScoreDlgProc
//////////////////////////////////////
void DoScoreDlg(HWND hwnd)
{
  HINSTANCE hInstance;
  FARPROC ScoreBox;

  hInstance = (HINSTANCE)GetWindowWord(hwnd, GWW_HINSTANCE);
  ScoreBox = MakeProcInstance((FARPROC)ScoreDlgProc, hInstance);
  DialogBox(hInstance, "Scores", hwnd, (DLGPROC)ScoreBox);
  FreeProcInstance(ScoreBox);
  ChangeScore = FALSE;
}


//////////////////////////////////////
// The window procedure
//////////////////////////////////////
LRESULT CALLBACK __export ScoreWndProc(HWND hwnd, UINT Message,
                                  WPARAM wParam, LPARAM lParam)
{
  TSCOREREP * ScoreRep;
  char S[10];

  switch(Message)
  {
    case WM_SETNUMSEGS:
      ScoreRep = (TSCOREREP *)lParam;
      SetWindowText(hStaticWind,itoa(ScoreRep->NumSects,S,10));
      SetWindowText(hDotsLeftWin,ltoa(ScoreRep->NumPrizes,S,10));
     SetWindowText(hStaticScore,ltoa(ScoreRep->TotalScore,S,10));
      SetWindowText(hStatScreen,itoa(ScoreRep->ScreenNum,S,10));
      return 0;

    case WM_SCORE:
      ChangeScore = TRUE;
      NewScore = lParam;
      DoScoreDlg(hwnd);
      return 0;

    HANDLE_MSG(hwnd, WM_CREATE, Score_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Score_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, Score_OnCommand);
    HANDLE_MSG(hwnd, WM_CTLCOLOR, Score_OnCtlColor);
    default: return Score_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Score_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  int YTopRow = 5;   // Place where top row of statics appear
  int YSecRow = 30;  // Second row of statics start here
  int SHeight = 17;  // Height of statics
  int BHeight = 22;  // Height of Buttons

  HINSTANCE hInstance =
            (HINSTANCE)GetWindowWord(hwnd, GWW_HINSTANCE);

  Patternmap = LoadBitmap(hInstance, "Pattern");
  if (!Patternmap)
  {
    MessageBox(hwnd, "No Pattern", "Fatal Error", MB_OK);
    return FALSE;
  }

  Pattern = CreatePatternBrush(Patternmap);
  SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)Pattern);

  CreateWindow("static", "Num Sections",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                10, YTopRow, 95, SHeight, hwnd, NULL,
                hInstance, NULL);

  hStaticWind = CreateWindow("static", "0",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                110, YTopRow, 50, SHeight, hwnd, NULL,
                hInstance, NULL);

  CreateWindow("static", "Total Score ",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                10, YSecRow, 95, SHeight, hwnd, NULL,
                hInstance, NULL);

  hStaticScore = CreateWindow("static", "0",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                110, YSecRow, 50, SHeight, hwnd, NULL,
                hInstance, NULL);

  // Right Screen

  int XVal = GetSystemMetrics(SM_CXFULLSCREEN) - 160;

  CreateWindow("static", "Screen Num",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                XVal, YTopRow, 95, SHeight, hwnd, NULL,
                hInstance, NULL);

  hStatScreen  = CreateWindow("static", "0",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                XVal + 100, YTopRow, 50, SHeight, hwnd, NULL,
                hInstance, NULL);

  CreateWindow("static", "Dots Left",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                XVal, YSecRow, 95, SHeight, hwnd, NULL,
                hInstance, NULL);

  hDotsLeftWin = CreateWindow("static", "0",
                WS_CHILD | WS_VISIBLE | SS_LEFT,
                XVal + 100, YSecRow, 50, SHeight, hwnd, NULL,
                hInstance, NULL);

  int Width = GetSystemMetrics(SM_CXSCREEN) / 2;

  CreateWindow("button", "&Start",
               WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
               Width - 100, YTopRow, 60, BHeight, hwnd,
               HMENU(ID_START), hInstance, NULL);

  CreateWindow("button", "&Fini",
	             WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                 Width - 30, YTopRow, 60, BHeight, hwnd,
                 HMENU(ID_FINI), hInstance, NULL);

  CreateWindow("button", "Sco&res",
	             WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                 Width + 40, YTopRow, 60, BHeight, hwnd,
                 HMENU(ID_SCORE), hInstance, NULL);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTORY
//////////////////////////////////////
#pragma argsused
void Score_OnDestroy(HWND hwnd)
{
  SetClassWord(hwnd, GCW_HBRBACKGROUND, NULL);
  DeleteBrush(Pattern);
  DeleteBitmap(Patternmap);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void Score_OnCommand(HWND hwnd, int id,
                     HWND hwndCtl, UINT codeNotify)
{
  switch(id)
  {
   case ID_START:
     SendMessage(GetParent(hwnd), WM_START, 0, 0L);
     break;

   case ID_FINI:
     SendMessage(GetParent(hwnd), WM_CLOSE, 0, 0L);
     break;

   case ID_SCORE:
     DoScoreDlg(hwnd);
     break;
  }
}

//////////////////////////////////////
// Color of controls for ScoreWindow
//////////////////////////////////////
HBRUSH Score_OnCtlColor(HWND hwnd, HDC hdc,
                        HWND hwndChild, int type)
{
  switch(type)
  {
    case CTLCOLOR_STATIC:
    case CTLCOLOR_BTN:
    case CTLCOLOR_EDIT:
      SetTextColor(hdc, RGB(0, 127, 0));
   	  SetBkMode(hdc, TRANSPARENT);
      return GetStockBrush(BLACK_BRUSH);
  }
  return FORWARD_WM_CTLCOLOR(hwnd, hdc, hwndChild,
                             type, Score_DefProc);
}

//////////////////////////////////////
// ScoreDlgProc
//////////////////////////////////////
int OpenScores(FILE * fp)
{
  if ((fp = fopen("Scores.Dta", "r+")) == NULL)
  {
    fp = fopen("Scores.Dta", "w+");
    memset(Scores, '\0', sizeof(Scores));
  }
  else
    fread(&Scores, sizeof(Scores), 1, fp);

  fclose(fp);
  return 1;
}

//////////////////////////////////////
// File io
//////////////////////////////////////
BOOL CloseScores(HWND hwnd, FILE * fp)
{
  int Result;

  if ((fp = fopen("Scores.Dta", "w+")) == NULL)
  {
    MessageBox(hwnd, "Error", "er", MB_OK);
    return 0;
  }

  Result = fwrite(&Scores, sizeof(Scores), 1, fp);
  if(!Result)
  {
    MessageBox(hwnd, "Error", "er", MB_OK);
    return 0;
  }

  fclose(fp);
  return 1;
}

//////////////////////////////////////
// FillListBox
//////////////////////////////////////
void FillListBox(HWND hDlg)
{
  char S[150];

  for (int i = 1; i < TOTALSCORES; i++)
  {
    if (strlen(Scores[i].Name) == 0)
      strcpy(Scores[i].Name, "Sammy");
    sprintf(S, "%2i) %-20s %10ld", i,
            Scores[i].Name, Scores[i].Total);
    SendDlgItemMessage(hDlg, ID_SCOREBOX,
                       LB_ADDSTRING, 0, (LPARAM)S);
	}
}

//////////////////////////////////////
// Swap routine
//////////////////////////////////////
void Swap(int i, int j)
{
  TSCORESTRUCT temp;
  temp = Scores[i];
  Scores[i] = Scores[j];
  Scores[j] = temp;
}

//////////////////////////////////////
// SortScores
//////////////////////////////////////
void SortScores(void)
{
  for (int i = TOTALSCORES; i >= 1; i--)
    for (int j = 2; j <= i; j++)
      if (Scores[j - 1].Total < Scores[j].Total)
        Swap(j-1, j);
}

//////////////////////////////////////
// RecordScore
//////////////////////////////////////
void RecordScore(HWND hDlg)
{
  SendDlgItemMessage(hDlg, ID_SCORENAME, WM_GETTEXT, SCORESIZE,
	                   (LPARAM)Scores[TOTALSCORES - 1].Name);
  Scores[TOTALSCORES-1].Total = NewScore;
  SortScores();
	SendDlgItemMessage(hDlg, ID_SCOREBOX, LB_RESETCONTENT,0,0);
  FillListBox(hDlg);
}

//////////////////////////////////////
// Automatically center a dialog
//////////////////////////////////////
void CenterDialog(HWND hDlg)
{
  RECT R;
  int i = GetSystemMetrics(SM_CXSCREEN);
  int j = GetSystemMetrics(SM_CYSCREEN);
  int Height = GetSystemMetrics(SM_CYCAPTION);
  Height += (GetSystemMetrics(SM_CYDLGFRAME) * 2);
  int Width = GetSystemMetrics(SM_CXDLGFRAME) * 2;
  GetClientRect(hDlg, &R);
  MoveWindow(hDlg, (i / 2)-(R.right / 2),  (j / 2)-R.bottom / 2,
             R.right + Width, R.bottom + Height, FALSE);
}

//////////////////////////////////////
// The Score Dialog Proc so user can
// see lists of scores and add his own
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK ScoreDlgProc(HWND hDlg, WORD Message, 
                           WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_INITDIALOG:
      SetWindowFont(GetDlgItem(hDlg, ID_SCOREBOX),
                    GetStockObject(SYSTEM_FIXED_FONT), FALSE);
      Edit_LimitText(GetDlgItem(hDlg, ID_SCORENAME), 20);
      OpenScores(fp);
      FillListBox(hDlg);
      if (ChangeScore)
        PostMessage(hDlg, WM_FOCUS, 0, 0);
      else
        {
          MoveWindow(GetDlgItem(hDlg, ID_SCOREBOX),
                     10, 6, 365, 225, FALSE);
          MoveWindow(GetDlgItem(hDlg, IDOK),
                     8, 240, 370, 25, FALSE);
          ShowWindow(GetDlgItem(hDlg, ID_SCORENAME), SW_HIDE);
          ShowWindow(GetDlgItem(hDlg, ID_SCORESTAT), SW_HIDE);
          ShowWindow(GetDlgItem(hDlg, ID_NEWNAME), SW_HIDE);
        }
      CenterDialog(hDlg);
      return TRUE;

    case WM_FOCUS:
      SetFocus(GetDlgItem(hDlg, ID_SCORENAME));
      break;

    case WM_COMMAND:
      switch(wParam)
      {
        case IDOK:
        case IDCANCEL:
          if (!ScoreRecorded)
            RecordScore(hDlg);
          if (ChangeScore)
             CloseScores(hDlg, fp);
          ScoreRecorded = FALSE;
          EndDialog(hDlg, TRUE);
          return TRUE;

        case ID_NEWNAME:
          RecordScore(hDlg);
          ScoreRecorded = TRUE;
          return TRUE;
      }
  }
  return FALSE;
}
