//////////////////////////////////////
//  Program Name: SNAKO.H
//  Programmer: Charlie Calvert
//  Description: A windows game
//  Date: 08/05/93
//////////////////////////////////////

#if !defined _SNAKE_H
#define _SNAKE_H

// const
#define SNAKETIMER 1
#define GRASSMAP 1
#define PRIZEMAP 2
#define ROADMAP 3

#define MAXY 21      // Max rows for maze on one level
#define MAXX 32 * 4  // Max cols for maze on one level
#define JUMPSPACE 32 // Width of one screen in bitmaps
#define XWIDTH 25    // Bitmap width in pixels
#define YHEIGHT 25   // Bitmap height in pixels
#define MAXSECTS 512 // Max length of snake: very flexible

#define BRIDGEX1 0   // Row for bridge to next screen
#define BRIDGEX2 1   // Row for bridge to next screen

#define LEFT 0
#define RIGHT 1
#define UP 2
#define DOWN 3

// Type
struct TSCOREREP{
  int NumSects;
  WORD NumPrizes;
  LONG TotalScore;
  WORD ScreenNum;
  WORD Level;
};

// Types
typedef struct  {
	HDC CompDC;
	HDC TCompDC;
	HBITMAP CompBmp;
	HBITMAP OldBmp;
	HBITMAP OldTBmp;
} TSAVEBITMAP;
typedef TSAVEBITMAP TSAVEBITMAPARY[6];

typedef struct
{
  int MaxScore;
  int MaxCols;
  int MinCols;
  int GrassX;
  int GrassY;
  int XPos;
  int MenuSpace;
  int SizeX;
  int SizeY;
  long TotalClicks;
  BOOL NewScreenStarted;
  int Speed;
  int NumTurns, Sections;
} TDATA;

typedef struct TSNAKEMAP {
  HBITMAP Head, Body, Grass, Road, Road2;
}SNAKEMAP;

typedef struct TSECTINFO {
  BOOL DirChange;
  int Dir;
  int Col, Row;
  int OldCol, OldRow;
} SECTINFO;

typedef struct {
  TSCOREREP ScoreRep;
  char Map[MAXY][MAXX];
  TDATA Dat;
  TSECTINFO SectInfo[MAXSECTS];
} TGAMEINFO;
typedef TGAMEINFO *PGAMEINFO;

#endif

// Macros
#define HANDLE_WM_START(hwnd, wParam, lParam, fn) \
    ((fn)(hwnd), 0L)
#define FORWARD_WM_START(hwnd, fn) \
    (void)(fn)((hwnd), WM_START, 0, 0L)

// Class Snake
#define Snake_DefProc    DefWindowProc
BOOL Snake_OnCreate(HWND hWindow,
                    CREATESTRUCT FAR* lpCreateStruct);
void Snake_OnDestroy(HWND hWindow);
void Snake_OnChar(HWND hWindow, UINT ch, int cRepeat);
void Snake_OnKey(HWND hWindow, UINT vk, BOOL fDown,
                 int cRepeat, UINT flags);
void Snake_OnPaint(HWND hWindow);
void Snake_OnSize(HWND hwnd, UINT state, int cx, int cy);
void Snake_OnStart(HWND hwnd);
void Snake_OnTimer(HWND hWindow, UINT id);

// Procs
HWND Create(HINSTANCE hInst, int nCmdShow);
BOOL Register(HINSTANCE hInst);
BOOL SetUpWindow(HWND hWindow);
void PaintPlayingField(HDC PaintDC);
LRESULT CALLBACK __export WndProc(HWND, UINT, WPARAM, LPARAM);
void InitializeSections(HWND hwnd);
int ReadArray(HWND hwnd);
